/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.excel;

import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.Serializable;
import java.util.Hashtable;

public class PixelConsumer
implements ImageConsumer,
Serializable {
    private boolean complete = false;
    public int height;
    public int iheight;
    private Image image;
    private boolean init = false;
    public int iwidth;
    public int[][] pix;
    private boolean region = false;
    private int sx1;
    private int sx2;
    private int sy1;
    private int sy2;
    private int trycnt = 0;
    public int width;

    public PixelConsumer(Image image1, int i, int j, int k, int l) {
        this(image1);
        this.region = true;
        this.sx1 = i;
        this.sy1 = j;
        this.sx2 = k;
        this.sy2 = l;
    }

    public PixelConsumer(Image image1) {
        this.image = image1;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PixelConsumer)) {
            return false;
        }
        PixelConsumer pixelconsumer = (PixelConsumer)obj;
        return this.image == pixelconsumer.image && this.sx1 == pixelconsumer.sx1 && this.sy1 == pixelconsumer.sy1 && this.sx2 == pixelconsumer.sx2 && this.sy2 == pixelconsumer.sy2;
    }

    private int getInt(byte byte0) {
        return byte0 & 0xFF;
    }

    public Object getKey() {
        return new Key(this);
    }

    public int hashCode() {
        return this.image.hashCode() + this.sx1 + this.sy1 + this.sx2 + this.sy2;
    }

    public synchronized void imageComplete(int i) {
        if (i == 1 || i == 4) {
            if (this.trycnt < 3) {
                ++this.trycnt;
                this.produce(this.image);
            } else {
                i = 3;
            }
        }
        if (i == 3 || i == 2) {
            this.complete = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void produce(Image image1) {
        ImageProducer imageproducer = image1.getSource();
        imageproducer.removeConsumer(this);
        imageproducer.startProduction(this);
        PixelConsumer pixelConsumer = this;
        synchronized (pixelConsumer) {
            while (!this.complete) {
                try {
                    this.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        imageproducer.removeConsumer(this);
    }

    public void produce() {
        if (!this.init) {
            this.init = true;
            this.produce(this.image);
        }
    }

    public void setColorModel(ColorModel colormodel) {
    }

    public void setDimensions(int i, int j) {
        if (this.region) {
            i = this.sx2 - this.sx1 + 1;
            j = this.sy2 - this.sy1 + 1;
        }
        if (this.pix == null || i != this.width || j != this.height) {
            this.width = i;
            this.height = j;
            this.pix = new int[this.width][this.height];
        }
        this.iwidth = this.width;
        this.iheight = this.height;
    }

    public void setHints(int i) {
    }

    public void setPixels(int i, int j, int k, int l, ColorModel colormodel, int[] ai, int i1, int j1) {
        boolean flag = false;
        boolean flag1 = false;
        int i2 = i + k;
        int j2 = j + l;
        int l2 = i1;
        int l1 = j;
        while (l1 < j2) {
            int k2 = l2;
            int k1 = i;
            while (k1 < i2 && k2 < ai.length) {
                int i3 = -16777216;
                if (this.region) {
                    if (k1 >= this.sx1 && k1 <= this.sx2 && l1 >= this.sy1 && l1 <= this.sy2) {
                        this.pix[k1 - this.sx1][l1 - this.sy1] = colormodel.getRGB(ai[k2++]) & 0xFFFFFF | i3;
                    }
                } else {
                    this.pix[k1][l1] = colormodel.getRGB(ai[k2++]) & 0xFFFFFF | i3;
                }
                ++k1;
            }
            l2 += j1;
            ++l1;
        }
    }

    public void setPixels(int i, int j, int k, int l, ColorModel colormodel, byte[] abyte0, int i1, int j1) {
        boolean flag = false;
        boolean flag1 = false;
        int k2 = i1;
        int i3 = i1;
        int i2 = i + k;
        int j2 = j + l;
        int l1 = j;
        while (l1 < j2) {
            int l2 = i3;
            int k1 = i;
            while (k1 < i2 && l2 < abyte0.length) {
                if (this.region) {
                    if (k1 >= this.sx1 && k1 <= this.sx2 && l1 >= this.sy1 && l1 <= this.sy2) {
                        this.pix[k1 - this.sx1][l1 - this.sy1] = this.getInt(abyte0[l2++]);
                        if (colormodel != null) {
                            this.pix[k1 - this.sx1][l1 - this.sy1] = colormodel.getRGB(this.pix[k1 - this.sx1][l1 - this.sy1]);
                        }
                    }
                } else {
                    this.pix[k1][l1] = this.getInt(abyte0[l2++]);
                    if (colormodel != null) {
                        this.pix[k1][l1] = colormodel.getRGB(this.pix[k1][l1]);
                    }
                }
                ++k1;
            }
            i3 += j1;
            ++l1;
        }
    }

    public void setProperties(Hashtable hashtable) {
    }

    static class Key {
        Image image;
        int sx1;
        int sx2;
        int sy1;
        int sy2;

        public Key(PixelConsumer pixelconsumer) {
            this.image = pixelconsumer.image;
            this.sx1 = pixelconsumer.sx1;
            this.sx2 = pixelconsumer.sx2;
            this.sy1 = pixelconsumer.sy1;
            this.sy2 = pixelconsumer.sy2;
        }

        public boolean equals(Object obj) {
            try {
                Key key = (Key)obj;
                return this.image == key.image && this.sx1 == key.sx1 && this.sy1 == key.sy1 && this.sx2 == key.sx2 && this.sy2 == key.sy2;
            }
            catch (Exception exception) {
                return false;
            }
        }

        public int hashCode() {
            return this.image.hashCode() + this.sx1 + this.sy1 + this.sx2 + this.sy2;
        }
    }
}

