/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.excel;

import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.poi.hssf.record.excel.DataOutputStreamLfirst;
import org.apache.poi.hssf.record.excel.OBJBiffElement;
import org.apache.poi.hssf.record.excel.PixelConsumer;
import org.apache.poi.hssf.record.excel.PixelGrabber;

public class ImdataBiffElement
extends OBJBiffElement {
    private static int BITMAPCELLLENGTH = 2068;
    private static int BITMAPCOREINFO;
    private static int HEADERBITS;
    private int bcBitCount = 24;
    private int bcHeight = 0;
    private int bcPlanes = 1;
    private int bcSize = 12;
    private int bcWidth = 0;
    private int env = 1;
    private byte[] imageData = null;
    private Image img = null;
    private int imgFormat = 9;
    private boolean isBackground = true;
    private int lcb = 0;

    static {
        HEADERBITS = 20;
        BITMAPCOREINFO = 12;
    }

    private ImdataBiffElement(byte[] imageData) {
        this((Image)null);
        this.imageData = imageData;
    }

    private ImdataBiffElement(Image image) {
        super(127, 0);
        this.setObjectType(OBJBiffElement.PICTURE);
        this.setGrbit(1556);
        this.setContent(image);
    }

    public static ImdataBiffElement createImdataBiffElement(byte[] imageData) {
        return new ImdataBiffElement(imageData);
    }

    public static ImdataBiffElement createImdataBiffElement(Image image) {
        return new ImdataBiffElement(image);
    }

    public Image getContent() {
        return this.img;
    }

    private byte[] getImageByteData() {
        if (this.img == null) {
            return this.imageData;
        }
        PixelConsumer pixelconsumer = new PixelConsumer(this.img);
        pixelconsumer.produce();
        if (pixelconsumer.width == 0 || pixelconsumer.height == 0) {
            return null;
        }
        int i = pixelconsumer.width;
        int j = pixelconsumer.height;
        int k = i * 3 % 4 != 0 ? 4 - i * 3 % 4 : 0;
        byte[] abyte0 = new byte[(i * 3 + k) * j];
        int l = 0;
        while (l < abyte0.length) {
            abyte0[l] = 0;
            ++l;
        }
        this.bcWidth = i;
        this.bcHeight = j;
        int[] ai = new int[i * j];
        PixelGrabber pixelgrabber = new PixelGrabber(this.img, 0, 0, i, j, ai, 0, i);
        try {
            pixelgrabber.grabPixels();
        }
        catch (InterruptedException interruptedexception) {
            return null;
        }
        pixelgrabber = null;
        pixelconsumer = null;
        int i1 = -1;
        int j1 = j - 1;
        while (j1 >= 0) {
            int k1 = 0;
            while (k1 < i) {
                int i2 = ai[j1 * i + k1];
                if (i2 >>> 24 == 0) {
                    i2 = -1;
                }
                abyte0[++i1] = (byte)(i2 & 0xFF);
                abyte0[++i1] = (byte)(i2 >> 8 & 0xFF);
                abyte0[++i1] = (byte)(i2 >> 16 & 0xFF);
                ++k1;
            }
            i1 += k;
            --j1;
        }
        this.lcb = abyte0.length + BITMAPCOREINFO;
        if (abyte0.length < BITMAPCELLLENGTH - HEADERBITS) {
            this.setLength(this.lcb + HEADERBITS - BITMAPCOREINFO);
            return abyte0;
        }
        this.setLength(BITMAPCELLLENGTH);
        int l1 = (abyte0.length + HEADERBITS) / BITMAPCELLLENGTH * 4 + abyte0.length;
        byte[] abyte1 = new byte[l1];
        i1 = HEADERBITS;
        int j2 = 0;
        int k2 = 0;
        while (k2 < abyte0.length) {
            abyte1[j2++] = abyte0[k2];
            if (++i1 == BITMAPCELLLENGTH) {
                abyte1[j2++] = 60;
                abyte1[j2++] = 0;
                int l2 = abyte0.length - k2;
                if (l2 > BITMAPCELLLENGTH) {
                    abyte1[j2++] = (byte)BITMAPCELLLENGTH;
                    abyte1[j2++] = (byte)(BITMAPCELLLENGTH >>> 8);
                } else {
                    abyte1[j2++] = (byte)(--l2 & 0xFF);
                    abyte1[j2++] = (byte)((l2 & 0xFF00) >>> 8);
                }
                i1 = 0;
            }
            ++k2;
        }
        return abyte1;
    }

    public void setBackground(boolean flag) {
        this.isBackground = flag;
    }

    public void setContent(Image image) {
        this.img = image;
    }

    public byte[] toBinary() throws IOException {
        byte[] abyte0 = this.getImageByteData();
        byte[] abyte1 = null;
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        DataOutputStreamLfirst dataoutputstreamlfirst = new DataOutputStreamLfirst(bytearrayoutputstream);
        dataoutputstreamlfirst.writeShort(93);
        if (this.isBackground) {
            dataoutputstreamlfirst.writeShort(70);
        } else {
            dataoutputstreamlfirst.writeShort(60);
        }
        dataoutputstreamlfirst.write(super.toHeadBinary());
        dataoutputstreamlfirst.write(9);
        dataoutputstreamlfirst.write(9);
        dataoutputstreamlfirst.write(0);
        dataoutputstreamlfirst.write(0);
        dataoutputstreamlfirst.write(8);
        dataoutputstreamlfirst.write(-1);
        dataoutputstreamlfirst.write(1);
        dataoutputstreamlfirst.write(0);
        dataoutputstreamlfirst.writeShort(0);
        dataoutputstreamlfirst.writeShort(this.imgFormat);
        dataoutputstreamlfirst.writeInt(0);
        dataoutputstreamlfirst.writeShort(0);
        dataoutputstreamlfirst.writeShort(0);
        dataoutputstreamlfirst.writeShort(0);
        dataoutputstreamlfirst.writeInt(0);
        if (this.isBackground) {
            dataoutputstreamlfirst.write(9);
            dataoutputstreamlfirst.writeBytes("_BkgndObj");
        }
        dataoutputstreamlfirst.writeShort(this.getType());
        dataoutputstreamlfirst.writeShort(this.getLength());
        dataoutputstreamlfirst.writeShort(this.imgFormat);
        dataoutputstreamlfirst.writeShort(this.env);
        dataoutputstreamlfirst.writeInt(this.lcb);
        dataoutputstreamlfirst.writeInt(this.bcSize);
        dataoutputstreamlfirst.writeShort(this.bcWidth);
        dataoutputstreamlfirst.writeShort(this.bcHeight);
        dataoutputstreamlfirst.writeShort(this.bcPlanes);
        dataoutputstreamlfirst.writeShort(this.bcBitCount);
        dataoutputstreamlfirst.write(abyte0);
        abyte1 = bytearrayoutputstream.toByteArray();
        dataoutputstreamlfirst.close();
        bytearrayoutputstream.close();
        return abyte1;
    }
}

