/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.BitField;
import org.apache.poi.util.LittleEndian;

public class WindowTwoRecord
extends Record {
    private BitField arabic;
    private BitField defaultHeader;
    private BitField displayFormulas = new BitField(1);
    private BitField displayGridlines = new BitField(2);
    private BitField displayGuts;
    private BitField displayRowColHeadings = new BitField(4);
    private BitField displayZeros;
    private short field_1_options;
    private short field_2_top_row;
    private short field_3_left_col;
    private int field_4_header_color;
    private short field_5_page_break_zoom;
    private short field_6_normal_zoom;
    private int field_7_reserved;
    private BitField freezePanes = new BitField(8);
    private BitField freezePanesNoSplit;
    private BitField paged;
    private BitField savedInPageBreakPreview;
    private BitField selected;
    public static final short sid = 574;

    public WindowTwoRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
        this.displayZeros = new BitField(16);
        this.defaultHeader = new BitField(32);
        this.arabic = new BitField(64);
        this.displayGuts = new BitField(128);
        this.freezePanesNoSplit = new BitField(256);
        this.selected = new BitField(512);
        this.paged = new BitField(1024);
        this.savedInPageBreakPreview = new BitField(2048);
    }

    public WindowTwoRecord(short id, short size, byte[] data) {
        super(id, size, data);
        this.displayZeros = new BitField(16);
        this.defaultHeader = new BitField(32);
        this.arabic = new BitField(64);
        this.displayGuts = new BitField(128);
        this.freezePanesNoSplit = new BitField(256);
        this.selected = new BitField(512);
        this.paged = new BitField(1024);
        this.savedInPageBreakPreview = new BitField(2048);
    }

    public WindowTwoRecord() {
        this.displayZeros = new BitField(16);
        this.defaultHeader = new BitField(32);
        this.arabic = new BitField(64);
        this.displayGuts = new BitField(128);
        this.freezePanesNoSplit = new BitField(256);
        this.selected = new BitField(512);
        this.paged = new BitField(1024);
        this.savedInPageBreakPreview = new BitField(2048);
    }

    public Object clone() {
        WindowTwoRecord rec = new WindowTwoRecord();
        rec.field_1_options = this.field_1_options;
        rec.field_2_top_row = this.field_2_top_row;
        rec.field_3_left_col = this.field_3_left_col;
        rec.field_4_header_color = this.field_4_header_color;
        rec.field_5_page_break_zoom = this.field_5_page_break_zoom;
        rec.field_6_normal_zoom = this.field_6_normal_zoom;
        rec.field_7_reserved = this.field_7_reserved;
        return rec;
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_options = LittleEndian.getShort(data, 0 + offset);
        this.field_2_top_row = LittleEndian.getShort(data, 2 + offset);
        this.field_3_left_col = LittleEndian.getShort(data, 4 + offset);
        this.field_4_header_color = LittleEndian.getInt(data, 6 + offset);
        if (size > 10) {
            this.field_5_page_break_zoom = LittleEndian.getShort(data, 10 + offset);
            this.field_6_normal_zoom = LittleEndian.getShort(data, 12 + offset);
        }
        if (size > 14) {
            this.field_7_reserved = LittleEndian.getInt(data, 14 + offset);
        }
    }

    public boolean getArabic() {
        return this.arabic.isSet(this.field_1_options);
    }

    public boolean getDefaultHeader() {
        return this.defaultHeader.isSet(this.field_1_options);
    }

    public boolean getDisplayFormulas() {
        return this.displayFormulas.isSet(this.field_1_options);
    }

    public boolean getDisplayGridlines() {
        return this.displayGridlines.isSet(this.field_1_options);
    }

    public boolean getDisplayGuts() {
        return this.displayGuts.isSet(this.field_1_options);
    }

    public boolean getDisplayRowColHeadings() {
        return this.displayRowColHeadings.isSet(this.field_1_options);
    }

    public boolean getDisplayZeros() {
        return this.displayZeros.isSet(this.field_1_options);
    }

    public boolean getFreezePanes() {
        return this.freezePanes.isSet(this.field_1_options);
    }

    public boolean getFreezePanesNoSplit() {
        return this.freezePanesNoSplit.isSet(this.field_1_options);
    }

    public int getHeaderColor() {
        return this.field_4_header_color;
    }

    public short getLeftCol() {
        return this.field_3_left_col;
    }

    public short getNormalZoom() {
        return this.field_6_normal_zoom;
    }

    public short getOptions() {
        return this.field_1_options;
    }

    public short getPageBreakZoom() {
        return this.field_5_page_break_zoom;
    }

    public boolean getPaged() {
        return this.paged.isSet(this.field_1_options);
    }

    public int getRecordSize() {
        return 22;
    }

    public int getReserved() {
        return this.field_7_reserved;
    }

    public boolean getSavedInPageBreakPreview() {
        return this.savedInPageBreakPreview.isSet(this.field_1_options);
    }

    public boolean getSelected() {
        return this.selected.isSet(this.field_1_options);
    }

    public short getSid() {
        return 574;
    }

    public short getTopRow() {
        return this.field_2_top_row;
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)574);
        LittleEndian.putShort(data, 2 + offset, (short)18);
        LittleEndian.putShort(data, 4 + offset, this.getOptions());
        LittleEndian.putShort(data, 6 + offset, this.getTopRow());
        LittleEndian.putShort(data, 8 + offset, this.getLeftCol());
        LittleEndian.putInt(data, 10 + offset, this.getHeaderColor());
        LittleEndian.putShort(data, 14 + offset, this.getPageBreakZoom());
        LittleEndian.putShort(data, 16 + offset, this.getNormalZoom());
        LittleEndian.putInt(data, 18 + offset, this.getReserved());
        return this.getRecordSize();
    }

    public void setArabic(boolean isarabic) {
        this.field_1_options = this.arabic.setShortBoolean(this.field_1_options, isarabic);
    }

    public void setDefaultHeader(boolean header) {
        this.field_1_options = this.defaultHeader.setShortBoolean(this.field_1_options, header);
    }

    public void setDisplayFormulas(boolean formulas) {
        this.field_1_options = this.displayFormulas.setShortBoolean(this.field_1_options, formulas);
    }

    public void setDisplayGridlines(boolean gridlines) {
        this.field_1_options = this.displayGridlines.setShortBoolean(this.field_1_options, gridlines);
    }

    public void setDisplayGuts(boolean guts) {
        this.field_1_options = this.displayGuts.setShortBoolean(this.field_1_options, guts);
    }

    public void setDisplayRowColHeadings(boolean headings) {
        this.field_1_options = this.displayRowColHeadings.setShortBoolean(this.field_1_options, headings);
    }

    public void setDisplayZeros(boolean zeros) {
        this.field_1_options = this.displayZeros.setShortBoolean(this.field_1_options, zeros);
    }

    public void setFreezePanes(boolean freezepanes) {
        this.field_1_options = this.freezePanes.setShortBoolean(this.field_1_options, freezepanes);
    }

    public void setFreezePanesNoSplit(boolean freeze) {
        this.field_1_options = this.freezePanesNoSplit.setShortBoolean(this.field_1_options, freeze);
    }

    public void setHeaderColor(int color) {
        this.field_4_header_color = color;
    }

    public void setLeftCol(short leftCol) {
        this.field_3_left_col = leftCol;
    }

    public void setNormalZoom(short zoom) {
        this.field_6_normal_zoom = zoom;
    }

    public void setOptions(short options) {
        this.field_1_options = options;
    }

    public void setPageBreakZoom(short zoom) {
        this.field_5_page_break_zoom = zoom;
    }

    public void setPaged(boolean p) {
        this.field_1_options = this.paged.setShortBoolean(this.field_1_options, p);
    }

    public void setReserved(int reserved) {
        this.field_7_reserved = reserved;
    }

    public void setSavedInPageBreakPreview(boolean p) {
        this.field_1_options = this.savedInPageBreakPreview.setShortBoolean(this.field_1_options, p);
    }

    public void setSelected(boolean sel) {
        this.field_1_options = this.selected.setShortBoolean(this.field_1_options, sel);
    }

    public void setTopRow(short topRow) {
        this.field_2_top_row = topRow;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[WINDOW2]\n");
        buffer.append("    .options        = ").append(Integer.toHexString(this.getOptions())).append("\n");
        buffer.append("       .dispformulas= ").append(this.getDisplayFormulas()).append("\n");
        buffer.append("       .dispgridlins= ").append(this.getDisplayGridlines()).append("\n");
        buffer.append("       .disprcheadin= ").append(this.getDisplayRowColHeadings()).append("\n");
        buffer.append("       .freezepanes = ").append(this.getFreezePanes()).append("\n");
        buffer.append("       .displayzeros= ").append(this.getDisplayZeros()).append("\n");
        buffer.append("       .defaultheadr= ").append(this.getDefaultHeader()).append("\n");
        buffer.append("       .arabic      = ").append(this.getArabic()).append("\n");
        buffer.append("       .displayguts = ").append(this.getDisplayGuts()).append("\n");
        buffer.append("       .frzpnsnosplt= ").append(this.getFreezePanesNoSplit()).append("\n");
        buffer.append("       .selected    = ").append(this.getSelected()).append("\n");
        buffer.append("       .paged       = ").append(this.getPaged()).append("\n");
        buffer.append("       .svdinpgbrkpv= ").append(this.getSavedInPageBreakPreview()).append("\n");
        buffer.append("    .toprow         = ").append(Integer.toHexString(this.getTopRow())).append("\n");
        buffer.append("    .leftcol        = ").append(Integer.toHexString(this.getLeftCol())).append("\n");
        buffer.append("    .headercolor    = ").append(Integer.toHexString(this.getHeaderColor())).append("\n");
        buffer.append("    .pagebreakzoom  = ").append(Integer.toHexString(this.getPageBreakZoom())).append("\n");
        buffer.append("    .normalzoom     = ").append(Integer.toHexString(this.getNormalZoom())).append("\n");
        buffer.append("    .reserved       = ").append(Integer.toHexString(this.getReserved())).append("\n");
        buffer.append("[/WINDOW2]\n");
        return buffer.toString();
    }

    protected void validateSid(short id) {
        if (id != 574) {
            throw new RecordFormatException("NOT A valid WindowTwo RECORD");
        }
    }
}

