/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class UseSelFSRecord
extends Record {
    public static final short FALSE = 0;
    public static final short TRUE = 1;
    private short field_1_flag;
    public static final short sid = 352;

    public UseSelFSRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    public UseSelFSRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public UseSelFSRecord() {
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_flag = LittleEndian.getShort(data, 0 + offset);
    }

    public short getFlag() {
        return this.field_1_flag;
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 352;
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)352);
        LittleEndian.putShort(data, 2 + offset, (short)2);
        LittleEndian.putShort(data, 4 + offset, this.getFlag());
        return this.getRecordSize();
    }

    public void setFlag(short flag) {
        this.field_1_flag = flag;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[USESELFS]\n");
        buffer.append("    .flag            = ").append(Integer.toHexString(this.getFlag())).append("\n");
        buffer.append("[/USESELFS]\n");
        return buffer.toString();
    }

    protected void validateSid(short id) {
        if (id != 352) {
            throw new RecordFormatException("NOT A UseSelFS RECORD");
        }
    }
}

