/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class UnknownRecord
extends Record {
    private short sid = 0;
    private byte[] thedata = null;

    public UnknownRecord(short id, short size, byte[] data, int offset) {
        this.sid = id;
        this.thedata = new byte[size];
        System.arraycopy(data, offset, this.thedata, 0, size);
    }

    public UnknownRecord(short id, short size, byte[] data) {
        this.sid = id;
        this.thedata = data;
    }

    public UnknownRecord() {
    }

    public Object clone() {
        UnknownRecord rec = new UnknownRecord();
        rec.sid = this.sid;
        rec.thedata = this.thedata;
        return rec;
    }

    protected void fillFields(byte[] data, short size, int offset) {
        throw new RecordFormatException("Unknown record cannot be constructed via offset -- we need a copy of the data");
    }

    protected void fillFields(byte[] data, short sid) {
        this.sid = sid;
        this.thedata = data;
    }

    public int getRecordSize() {
        int retval = 4;
        if (this.thedata != null) {
            retval += this.thedata.length;
        }
        return retval;
    }

    public short getSid() {
        return this.sid;
    }

    public int serialize(int offset, byte[] data) {
        if (this.thedata == null) {
            this.thedata = new byte[0];
        }
        LittleEndian.putShort(data, 0 + offset, this.sid);
        LittleEndian.putShort(data, 2 + offset, (short)this.thedata.length);
        if (this.thedata.length > 0) {
            System.arraycopy(this.thedata, 0, data, 4 + offset, this.thedata.length);
        }
        return this.getRecordSize();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[UNKNOWN RECORD:" + Integer.toHexString(this.sid) + "]\n");
        buffer.append("    .id        = ").append(Integer.toHexString(this.sid)).append("\n");
        buffer.append("[/UNKNOWN RECORD]\n");
        return buffer.toString();
    }

    protected void validateSid(short id) {
    }
}

