/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class UnitsRecord
extends Record {
    private short field_1_units;
    public static final short sid = 4097;

    public UnitsRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    public UnitsRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public UnitsRecord() {
    }

    public Object clone() {
        UnitsRecord rec = new UnitsRecord();
        rec.field_1_units = this.field_1_units;
        return rec;
    }

    protected void fillFields(byte[] data, short size, int offset) {
        int pos = 0;
        this.field_1_units = LittleEndian.getShort(data, pos + 0 + offset);
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 4097;
    }

    public short getUnits() {
        return this.field_1_units;
    }

    public int serialize(int offset, byte[] data) {
        int pos = 0;
        LittleEndian.putShort(data, 0 + offset, (short)4097);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(data, 4 + offset + pos, this.field_1_units);
        return this.getRecordSize();
    }

    public void setUnits(short field_1_units) {
        this.field_1_units = field_1_units;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[UNITS]\n");
        buffer.append("    .units                = ").append("0x").append(HexDump.toHex(this.getUnits())).append(" (").append(this.getUnits()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("[/UNITS]\n");
        return buffer.toString();
    }

    protected void validateSid(short id) {
        if (id != 4097) {
            throw new RecordFormatException("Not a Units record");
        }
    }
}

