/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class SeriesListRecord
extends Record {
    private short[] field_1_seriesNumbers;
    public static final short sid = 4118;

    public SeriesListRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    public SeriesListRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public SeriesListRecord() {
    }

    public Object clone() {
        SeriesListRecord rec = new SeriesListRecord();
        rec.field_1_seriesNumbers = this.field_1_seriesNumbers;
        return rec;
    }

    protected void fillFields(byte[] data, short size, int offset) {
        int pos = 0;
        this.field_1_seriesNumbers = LittleEndian.getShortArray(data, pos + 0 + offset);
    }

    public int getRecordSize() {
        return 4 + this.field_1_seriesNumbers.length * 2 + 2;
    }

    public short[] getSeriesNumbers() {
        return this.field_1_seriesNumbers;
    }

    public short getSid() {
        return 4118;
    }

    public int serialize(int offset, byte[] data) {
        int pos = 0;
        LittleEndian.putShort(data, 0 + offset, (short)4118);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putShortArray(data, 4 + offset + pos, this.field_1_seriesNumbers);
        return this.getRecordSize();
    }

    public void setSeriesNumbers(short[] field_1_seriesNumbers) {
        this.field_1_seriesNumbers = field_1_seriesNumbers;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[SERIESLIST]\n");
        buffer.append("    .seriesNumbers        = ").append(" (").append(this.getSeriesNumbers()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("[/SERIESLIST]\n");
        return buffer.toString();
    }

    protected void validateSid(short id) {
        if (id != 4118) {
            throw new RecordFormatException("Not a SeriesList record");
        }
    }
}

