/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.BitField;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class SeriesLabelsRecord
extends Record {
    private short field_1_formatFlags;
    private BitField labelAsPercentage;
    private BitField showActual = new BitField(1);
    private BitField showBubbleSizes;
    private BitField showLabel;
    private BitField showPercent = new BitField(2);
    public static final short sid = 4108;
    private BitField smoothedLine;

    public SeriesLabelsRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
        this.labelAsPercentage = new BitField(4);
        this.smoothedLine = new BitField(8);
        this.showLabel = new BitField(16);
        this.showBubbleSizes = new BitField(32);
    }

    public SeriesLabelsRecord(short id, short size, byte[] data) {
        super(id, size, data);
        this.labelAsPercentage = new BitField(4);
        this.smoothedLine = new BitField(8);
        this.showLabel = new BitField(16);
        this.showBubbleSizes = new BitField(32);
    }

    public SeriesLabelsRecord() {
        this.labelAsPercentage = new BitField(4);
        this.smoothedLine = new BitField(8);
        this.showLabel = new BitField(16);
        this.showBubbleSizes = new BitField(32);
    }

    public Object clone() {
        SeriesLabelsRecord rec = new SeriesLabelsRecord();
        rec.field_1_formatFlags = this.field_1_formatFlags;
        return rec;
    }

    protected void fillFields(byte[] data, short size, int offset) {
        int pos = 0;
        this.field_1_formatFlags = LittleEndian.getShort(data, pos + 0 + offset);
    }

    public short getFormatFlags() {
        return this.field_1_formatFlags;
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 4108;
    }

    public boolean isLabelAsPercentage() {
        return this.labelAsPercentage.isSet(this.field_1_formatFlags);
    }

    public boolean isShowActual() {
        return this.showActual.isSet(this.field_1_formatFlags);
    }

    public boolean isShowBubbleSizes() {
        return this.showBubbleSizes.isSet(this.field_1_formatFlags);
    }

    public boolean isShowLabel() {
        return this.showLabel.isSet(this.field_1_formatFlags);
    }

    public boolean isShowPercent() {
        return this.showPercent.isSet(this.field_1_formatFlags);
    }

    public boolean isSmoothedLine() {
        return this.smoothedLine.isSet(this.field_1_formatFlags);
    }

    public int serialize(int offset, byte[] data) {
        int pos = 0;
        LittleEndian.putShort(data, 0 + offset, (short)4108);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(data, 4 + offset + pos, this.field_1_formatFlags);
        return this.getRecordSize();
    }

    public void setFormatFlags(short field_1_formatFlags) {
        this.field_1_formatFlags = field_1_formatFlags;
    }

    public void setLabelAsPercentage(boolean value) {
        this.field_1_formatFlags = this.labelAsPercentage.setShortBoolean(this.field_1_formatFlags, value);
    }

    public void setShowActual(boolean value) {
        this.field_1_formatFlags = this.showActual.setShortBoolean(this.field_1_formatFlags, value);
    }

    public void setShowBubbleSizes(boolean value) {
        this.field_1_formatFlags = this.showBubbleSizes.setShortBoolean(this.field_1_formatFlags, value);
    }

    public void setShowLabel(boolean value) {
        this.field_1_formatFlags = this.showLabel.setShortBoolean(this.field_1_formatFlags, value);
    }

    public void setShowPercent(boolean value) {
        this.field_1_formatFlags = this.showPercent.setShortBoolean(this.field_1_formatFlags, value);
    }

    public void setSmoothedLine(boolean value) {
        this.field_1_formatFlags = this.smoothedLine.setShortBoolean(this.field_1_formatFlags, value);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[ATTACHEDLABEL]\n");
        buffer.append("    .formatFlags          = ").append("0x").append(HexDump.toHex(this.getFormatFlags())).append(" (").append(this.getFormatFlags()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("         .showActual               = ").append(this.isShowActual()).append('\n');
        buffer.append("         .showPercent              = ").append(this.isShowPercent()).append('\n');
        buffer.append("         .labelAsPercentage        = ").append(this.isLabelAsPercentage()).append('\n');
        buffer.append("         .smoothedLine             = ").append(this.isSmoothedLine()).append('\n');
        buffer.append("         .showLabel                = ").append(this.isShowLabel()).append('\n');
        buffer.append("         .showBubbleSizes          = ").append(this.isShowBubbleSizes()).append('\n');
        buffer.append("[/ATTACHEDLABEL]\n");
        return buffer.toString();
    }

    protected void validateSid(short id) {
        if (id != 4108) {
            throw new RecordFormatException("Not a SeriesLabels record");
        }
    }
}

