/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class SeriesChartGroupIndexRecord
extends Record {
    private short field_1_chartGroupIndex;
    public static final short sid = 4165;

    public SeriesChartGroupIndexRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    public SeriesChartGroupIndexRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public SeriesChartGroupIndexRecord() {
    }

    public Object clone() {
        SeriesChartGroupIndexRecord rec = new SeriesChartGroupIndexRecord();
        rec.field_1_chartGroupIndex = this.field_1_chartGroupIndex;
        return rec;
    }

    protected void fillFields(byte[] data, short size, int offset) {
        int pos = 0;
        this.field_1_chartGroupIndex = LittleEndian.getShort(data, pos + 0 + offset);
    }

    public short getChartGroupIndex() {
        return this.field_1_chartGroupIndex;
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 4165;
    }

    public int serialize(int offset, byte[] data) {
        int pos = 0;
        LittleEndian.putShort(data, 0 + offset, (short)4165);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(data, 4 + offset + pos, this.field_1_chartGroupIndex);
        return this.getRecordSize();
    }

    public void setChartGroupIndex(short field_1_chartGroupIndex) {
        this.field_1_chartGroupIndex = field_1_chartGroupIndex;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[SERTOCRT]\n");
        buffer.append("    .chartGroupIndex      = ").append("0x").append(HexDump.toHex(this.getChartGroupIndex())).append(" (").append(this.getChartGroupIndex()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("[/SERTOCRT]\n");
        return buffer.toString();
    }

    protected void validateSid(short id) {
        if (id != 4165) {
            throw new RecordFormatException("Not a SeriesChartGroupIndex record");
        }
    }
}

