/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.record.SSTSerializer;
import org.apache.poi.hssf.record.UnicodeString;

class SSTRecordSizeCalculator {
    private boolean finished = false;
    private boolean firstRecord = true;
    private boolean isRemainingString = false;
    private int pos = 0;
    private List recordLengths = new ArrayList();
    private int recordSize = 0;
    private int stringReminant = 0;
    private Map strings;
    private int totalBytesWritten = 0;
    private int totalWritten = 0;
    private int unipos = 0;
    private UnicodeString unistr = null;

    public SSTRecordSizeCalculator(Map strings) {
        this.strings = strings;
    }

    private void addMaxLengthRecordSize() {
        this.recordSize = 8228;
        this.pos = 12;
        this.firstRecord = false;
        this.recordLengths.add(new Integer(this.recordSize - 4));
    }

    private void calcRemainingStrings() {
        while (this.unipos < this.strings.size()) {
            int available = 8228 - this.pos;
            Integer intunipos = new Integer(this.unipos);
            this.unistr = (UnicodeString)this.strings.get(intunipos);
            if (this.unistr.getRecordSize() <= available) {
                this.totalBytesWritten += this.unistr.getRecordSize();
                this.pos += this.unistr.getRecordSize();
            } else {
                if (available >= 3) {
                    int toBeWritten = this.unistr.maxBrokenLength(available);
                    this.totalBytesWritten += toBeWritten;
                    this.stringReminant = this.unistr.getRecordSize() - toBeWritten + 1;
                    if (available != toBeWritten) {
                        int shortrecord = this.recordSize - (available - toBeWritten);
                        this.recordLengths.set(this.recordLengths.size() - 1, new Integer(shortrecord - 4));
                        this.recordSize = shortrecord;
                    }
                    this.isRemainingString = true;
                    ++this.unipos;
                    break;
                }
                int shortrecord = this.recordSize - available;
                this.recordLengths.set(this.recordLengths.size() - 1, new Integer(shortrecord - 4));
                this.recordSize = shortrecord;
                break;
            }
            ++this.unipos;
        }
    }

    private void calcReminant() {
        int available = 8228 - this.pos;
        if (this.stringReminant <= available) {
            this.totalBytesWritten += this.stringReminant - 1;
            this.pos += this.stringReminant;
            this.isRemainingString = false;
        } else {
            int toBeWritten = this.unistr.maxBrokenLength(available);
            if (available != toBeWritten) {
                int shortrecord = this.recordSize - (available - toBeWritten);
                this.recordLengths.set(this.recordLengths.size() - 1, new Integer(shortrecord - 4));
                this.recordSize = shortrecord;
            }
            this.totalBytesWritten += toBeWritten - 1;
            this.pos += toBeWritten;
            this.stringReminant -= toBeWritten - 1;
            this.isRemainingString = true;
        }
    }

    public List getRecordLengths() {
        return this.recordLengths;
    }

    public int getRecordSize() {
        int retval;
        this.initVars();
        int totalStringSpaceRequired = SSTSerializer.calculateUnicodeSize(this.strings);
        if (totalStringSpaceRequired > 8216) {
            retval = this.sizeOverContinuation(totalStringSpaceRequired);
        } else {
            retval = 12 + totalStringSpaceRequired;
            this.recordLengths.add(new Integer(totalStringSpaceRequired));
        }
        return retval;
    }

    private void initVars() {
        this.unistr = null;
        this.stringReminant = 0;
        this.unipos = 0;
        this.isRemainingString = false;
        this.totalBytesWritten = 0;
        this.finished = false;
        this.firstRecord = true;
        this.totalWritten = 0;
    }

    private int sizeOverContinuation(int totalStringSpaceRequired) {
        while (!this.finished) {
            this.recordSize = 0;
            this.pos = 0;
            if (this.firstRecord) {
                this.addMaxLengthRecordSize();
            } else {
                this.pos = 0;
                int toBeWritten = totalStringSpaceRequired - this.totalBytesWritten + (this.isRemainingString ? 1 : 0);
                int size = Math.min(8224, toBeWritten);
                if (size == toBeWritten) {
                    this.finished = true;
                }
                this.recordSize = size + 4;
                this.recordLengths.add(new Integer(size));
                this.pos = 4;
            }
            if (this.isRemainingString) {
                this.calcReminant();
            }
            this.calcRemainingStrings();
            this.totalWritten += this.recordSize;
        }
        int retval = this.totalWritten;
        return retval;
    }
}

