/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class SCLRecord
extends Record {
    private short field_1_numerator;
    private short field_2_denominator;
    public static final short sid = 160;

    public SCLRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    public SCLRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public SCLRecord() {
    }

    public Object clone() {
        SCLRecord rec = new SCLRecord();
        rec.field_1_numerator = this.field_1_numerator;
        rec.field_2_denominator = this.field_2_denominator;
        return rec;
    }

    protected void fillFields(byte[] data, short size, int offset) {
        int pos = 0;
        this.field_1_numerator = LittleEndian.getShort(data, pos + 0 + offset);
        this.field_2_denominator = LittleEndian.getShort(data, pos + 2 + offset);
    }

    public short getDenominator() {
        return this.field_2_denominator;
    }

    public short getNumerator() {
        return this.field_1_numerator;
    }

    public int getRecordSize() {
        return 8;
    }

    public short getSid() {
        return 160;
    }

    public int serialize(int offset, byte[] data) {
        int pos = 0;
        LittleEndian.putShort(data, 0 + offset, (short)160);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(data, 4 + offset + pos, this.field_1_numerator);
        LittleEndian.putShort(data, 6 + offset + pos, this.field_2_denominator);
        return this.getRecordSize();
    }

    public void setDenominator(short field_2_denominator) {
        this.field_2_denominator = field_2_denominator;
    }

    public void setNumerator(short field_1_numerator) {
        this.field_1_numerator = field_1_numerator;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[SCL]\n");
        buffer.append("    .numerator            = ").append("0x").append(HexDump.toHex(this.getNumerator())).append(" (").append(this.getNumerator()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .denominator          = ").append("0x").append(HexDump.toHex(this.getDenominator())).append(" (").append(this.getDenominator()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("[/SCL]\n");
        return buffer.toString();
    }

    protected void validateSid(short id) {
        if (id != 160) {
            throw new RecordFormatException("Not a SCL record");
        }
    }
}

