/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class RefreshAllRecord
extends Record {
    private short field_1_refreshall;
    public static final short sid = 439;

    public RefreshAllRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    public RefreshAllRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public RefreshAllRecord() {
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_refreshall = LittleEndian.getShort(data, 0 + offset);
    }

    public int getRecordSize() {
        return 6;
    }

    public boolean getRefreshAll() {
        return this.field_1_refreshall == 1;
    }

    public short getSid() {
        return 439;
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)439);
        LittleEndian.putShort(data, 2 + offset, (short)2);
        LittleEndian.putShort(data, 4 + offset, this.field_1_refreshall);
        return this.getRecordSize();
    }

    public void setRefreshAll(boolean refreshall) {
        this.field_1_refreshall = refreshall ? (short)1 : 0;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[REFRESHALL]\n");
        buffer.append("    .refreshall      = ").append(this.getRefreshAll()).append("\n");
        buffer.append("[/REFRESHALL]\n");
        return buffer.toString();
    }

    protected void validateSid(short id) {
        if (id != 439) {
            throw new RecordFormatException("NOT A REFRESHALL RECORD");
        }
    }
}

