/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class ProtectRecord
extends Record {
    private short field_1_protect;
    public static final short sid = 18;

    public ProtectRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    public ProtectRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public ProtectRecord() {
    }

    public Object clone() {
        ProtectRecord rec = new ProtectRecord();
        rec.field_1_protect = this.field_1_protect;
        return rec;
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_protect = LittleEndian.getShort(data, 0 + offset);
    }

    public boolean getProtect() {
        return this.field_1_protect == 1;
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 18;
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)18);
        LittleEndian.putShort(data, 2 + offset, (short)2);
        LittleEndian.putShort(data, 4 + offset, this.field_1_protect);
        return this.getRecordSize();
    }

    public void setProtect(boolean protect) {
        this.field_1_protect = protect ? (short)1 : 0;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[PROTECT]\n");
        buffer.append("    .protect         = ").append(this.getProtect()).append("\n");
        buffer.append("[/PROTECT]\n");
        return buffer.toString();
    }

    protected void validateSid(short id) {
        if (id != 18) {
            throw new RecordFormatException("NOT A PROTECT RECORD");
        }
    }
}

