/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class PrintHeadersRecord
extends Record {
    private short field_1_print_headers;
    public static final short sid = 42;

    public PrintHeadersRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    public PrintHeadersRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public PrintHeadersRecord() {
    }

    public Object clone() {
        PrintHeadersRecord rec = new PrintHeadersRecord();
        rec.field_1_print_headers = this.field_1_print_headers;
        return rec;
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_print_headers = LittleEndian.getShort(data, 0 + offset);
    }

    public boolean getPrintHeaders() {
        return this.field_1_print_headers == 1;
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 42;
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)42);
        LittleEndian.putShort(data, 2 + offset, (short)2);
        LittleEndian.putShort(data, 4 + offset, this.field_1_print_headers);
        return this.getRecordSize();
    }

    public void setPrintHeaders(boolean p) {
        this.field_1_print_headers = p ? (short)1 : 0;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[PRINTHEADERS]\n");
        buffer.append("    .printheaders   = ").append(this.getPrintHeaders()).append("\n");
        buffer.append("[/PRINTHEADERS]\n");
        return buffer.toString();
    }

    protected void validateSid(short id) {
        if (id != 42) {
            throw new RecordFormatException("NOT A PrintHeaders RECORD");
        }
    }
}

