/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.record.PColor;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class PaletteRecord
extends Record {
    public static final short FIRST_COLOR_INDEX = 8;
    public static final byte STANDARD_PALETTE_SIZE = 56;
    private short field_1_numcolors;
    private List field_2_colors;
    public static final short sid = 146;

    public PaletteRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    public PaletteRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public PaletteRecord(short id) {
        super(id, (short)56, PaletteRecord.getDefaultData());
    }

    public PaletteRecord() {
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_numcolors = LittleEndian.getShort(data, offset + 0);
        this.field_2_colors = new ArrayList(this.field_1_numcolors);
        int k = 0;
        while (k < this.field_1_numcolors) {
            this.field_2_colors.add(new PColor(data[2 + offset + k * 4 + 0], data[2 + offset + k * 4 + 1], data[2 + offset + k * 4 + 2]));
            ++k;
        }
    }

    public byte[] getColor(short byteIndex) {
        int i = byteIndex - 8;
        if (i < 0 || i >= this.field_2_colors.size()) {
            return null;
        }
        PColor color = (PColor)this.field_2_colors.get(i);
        return new byte[]{color.red, color.green, color.blue};
    }

    public static byte[] getDefaultData() {
        return new byte[]{56, 0, 0, 0, 0, 0, -1, -1, -1, 0, -1, 0, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, -1, -1, 0, 0, -1, 0, -1, 0, 0, -1, -1, 0, -128, 0, 0, 0, 0, -128, 0, 0, 0, 0, -128, 0, -128, -128, 0, 0, -128, 0, -128, 0, 0, -128, -128, 0, -64, -64, -64, 0, -128, -128, -128, 0, -103, -103, -1, 0, -103, 51, 102, 0, -1, -1, -52, 0, -52, -1, -1, 0, 102, 0, 102, 0, -1, -128, -128, 0, 0, 102, -52, 0, -52, -52, -1, 0, 0, 0, -128, 0, -1, 0, -1, 0, -1, -1, 0, 0, 0, -1, -1, 0, -128, 0, -128, 0, -128, 0, 0, 0, 0, -128, -128, 0, 0, 0, -1, 0, 0, -52, -1, 0, -52, -1, -1, 0, -52, -1, -52, 0, -1, -1, -103, 0, -103, -52, -1, 0, -1, -103, -52, 0, -52, -103, -1, 0, -1, -52, -103, 0, 51, 102, -1, 0, 51, -52, -52, 0, -103, -52, 0, 0, -1, -52, 0, 0, -1, -103, 0, 0, -1, 102, 0, 0, 102, 102, -103, 0, -106, -106, -106, 0, 0, 51, 102, 0, 51, -103, 102, 0, 0, 51, 0, 0, 51, 51, 0, 0, -103, 51, 0, 0, -103, 51, 102, 0, 51, 51, -103, 0, 51, 51, 51, 0};
    }

    public int getRecordSize() {
        return 6 + this.field_1_numcolors * 4;
    }

    public short getSid() {
        return 146;
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)146);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(data, 4 + offset, this.field_1_numcolors);
        int k = 0;
        while (k < this.field_1_numcolors) {
            PColor c = (PColor)this.field_2_colors.get(k);
            c.serialize(data, 6 + offset + k * 4);
            ++k;
        }
        return this.getRecordSize();
    }

    /*
     * Unable to fully structure code
     */
    public void setColor(short byteIndex, byte red, byte green, byte blue) {
        i = byteIndex - 8;
        if (i >= 0 && i < 56) ** GOTO lbl7
        return;
lbl-1000:
        // 1 sources

        {
            this.field_2_colors.add(new PColor(0, 0, 0));
lbl7:
            // 2 sources

            ** while (this.field_2_colors.size() <= i)
        }
lbl8:
        // 1 sources

        custColor = new PColor(red, green, blue);
        this.field_2_colors.set(i, custColor);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[PALETTE]\n");
        buffer.append("  numcolors     = ").append(this.field_1_numcolors).append('\n');
        int k = 0;
        while (k < this.field_1_numcolors) {
            PColor c = (PColor)this.field_2_colors.get(k);
            buffer.append("* colornum      = ").append(k).append('\n');
            buffer.append(c.toString());
            buffer.append("/*colornum      = ").append(k).append('\n');
            ++k;
        }
        buffer.append("[/PALETTE]\n");
        return buffer.toString();
    }

    protected void validateSid(short id) {
        if (id != 146) {
            throw new RecordFormatException("NOT An Palette RECORD");
        }
    }
}

