/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class PageBreakRecord
extends Record {
    private Map BreakMap;
    public static final short HORIZONTAL_SID = 27;
    public static final short VERTICAL_SID = 26;
    private List breaks;
    private short numBreaks;
    public short sid;

    public PageBreakRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
        this.sid = id;
    }

    public PageBreakRecord(short id, short size, byte[] data) {
        super(id, size, data);
        this.sid = id;
    }

    public PageBreakRecord(short sid) {
        this.sid = sid;
    }

    public PageBreakRecord() {
    }

    public void addBreak(short main, short subFrom, short subTo) {
        Integer key;
        Break region;
        if (this.breaks == null) {
            this.breaks = new ArrayList(this.getNumBreaks() + 10);
            this.BreakMap = new HashMap();
        }
        if ((region = (Break)this.BreakMap.get(key = new Integer(main))) != null) {
            region.main = main;
            region.subFrom = subFrom;
            region.subTo = subTo;
        } else {
            region = new Break(main, subFrom, subTo);
            this.breaks.add(region);
        }
        this.BreakMap.put(key, region);
    }

    public Object clone() {
        PageBreakRecord record = new PageBreakRecord(this.getSid());
        Iterator iterator = this.getBreaksIterator();
        while (iterator.hasNext()) {
            Break original = (Break)iterator.next();
            record.addBreak(original.main, original.subFrom, original.subTo);
        }
        return record;
    }

    protected void fillFields(byte[] data, short size, int offset) {
        int loadedBreaks = LittleEndian.getShort(data, 0 + offset);
        this.setNumBreaks((short)loadedBreaks);
        int pos = 2;
        int k = 0;
        while (k < loadedBreaks) {
            this.addBreak((short)(LittleEndian.getShort(data, pos + offset) - 1), LittleEndian.getShort(data, pos + 2 + offset), LittleEndian.getShort(data, pos + 4 + offset));
            pos += 6;
            ++k;
        }
    }

    public Break getBreak(short main) {
        Integer rowKey = new Integer(main);
        return (Break)this.BreakMap.get(rowKey);
    }

    public Iterator getBreaksIterator() {
        if (this.breaks == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.breaks.iterator();
    }

    public short getNumBreaks() {
        return this.breaks != null ? (short)this.breaks.size() : this.numBreaks;
    }

    public int getRecordSize() {
        return 6 + this.getNumBreaks() * 6;
    }

    public short getSid() {
        return this.sid;
    }

    public void removeBreak(short main) {
        Integer rowKey = new Integer(main);
        Break region = (Break)this.BreakMap.get(rowKey);
        this.breaks.remove(region);
        this.BreakMap.remove(rowKey);
    }

    public int serialize(int offset, byte[] data) {
        int recordsize = this.getRecordSize();
        int pos = 6;
        LittleEndian.putShort(data, offset + 0, this.getSid());
        LittleEndian.putShort(data, offset + 2, (short)(recordsize - 4));
        LittleEndian.putShort(data, offset + 4, this.getNumBreaks());
        Iterator iterator = this.getBreaksIterator();
        while (iterator.hasNext()) {
            Break Break2 = (Break)iterator.next();
            LittleEndian.putShort(data, offset + pos, (short)(Break2.main + 1));
            LittleEndian.putShort(data, offset + (pos += 2), Break2.subFrom);
            LittleEndian.putShort(data, offset + (pos += 2), Break2.subTo);
            pos += 2;
        }
        return recordsize;
    }

    public void setNumBreaks(short numBreaks) {
        this.numBreaks = numBreaks;
    }

    public String toString() {
        String subLabel;
        String mainLabel;
        String label;
        StringBuffer retval = new StringBuffer();
        if (this.getSid() != 27 && this.getSid() != 26) {
            return "[INVALIDPAGEBREAK]\n     .sid =" + this.getSid() + "[INVALIDPAGEBREAK]";
        }
        if (this.getSid() == 27) {
            label = "HORIZONTALPAGEBREAK";
            mainLabel = "row";
            subLabel = "col";
        } else {
            label = "VERTICALPAGEBREAK";
            mainLabel = "column";
            subLabel = "row";
        }
        retval.append("[" + label + "]").append("\n");
        retval.append("     .sid        =").append(this.getSid()).append("\n");
        retval.append("     .numbreaks =").append(this.getNumBreaks()).append("\n");
        Iterator iterator = this.getBreaksIterator();
        int k = 0;
        while (k < this.getNumBreaks()) {
            Break region = (Break)iterator.next();
            retval.append("     .").append(mainLabel).append(" (zero-based) =").append(region.main).append("\n");
            retval.append("     .").append(subLabel).append("From    =").append(region.subFrom).append("\n");
            retval.append("     .").append(subLabel).append("To      =").append(region.subTo).append("\n");
            ++k;
        }
        retval.append("[" + label + "]").append("\n");
        return retval.toString();
    }

    protected void validateSid(short id) {
        if (id != 27 && id != 26) {
            throw new RecordFormatException("NOT A HorizontalPageBreak or VerticalPageBreak RECORD!! " + id);
        }
    }

    public class Break {
        public short main;
        public short subFrom;
        public short subTo;

        public Break(short main, short subFrom, short subTo) {
            this.main = main;
            this.subFrom = subFrom;
            this.subTo = subTo;
        }
    }
}

