/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class NumberRecord
extends Record
implements CellValueRecordInterface,
Comparable {
    private int field_1_row;
    private short field_2_col;
    private short field_3_xf;
    private double field_4_value;
    public static final short sid = 515;

    public NumberRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    public NumberRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public NumberRecord() {
    }

    public Object clone() {
        NumberRecord rec = new NumberRecord();
        rec.field_1_row = this.field_1_row;
        rec.field_2_col = this.field_2_col;
        rec.field_3_xf = this.field_3_xf;
        rec.field_4_value = this.field_4_value;
        return rec;
    }

    public int compareTo(Object obj) {
        CellValueRecordInterface loc = (CellValueRecordInterface)obj;
        if (this.getRow() == loc.getRow() && this.getColumn() == loc.getColumn()) {
            return 0;
        }
        if (this.getRow() < loc.getRow()) {
            return -1;
        }
        if (this.getRow() > loc.getRow()) {
            return 1;
        }
        if (this.getColumn() < loc.getColumn()) {
            return -1;
        }
        if (this.getColumn() > loc.getColumn()) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CellValueRecordInterface)) {
            return false;
        }
        CellValueRecordInterface loc = (CellValueRecordInterface)obj;
        return this.getRow() == loc.getRow() && this.getColumn() == loc.getColumn();
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_row = LittleEndian.getUShort(data, 0 + offset);
        this.field_2_col = LittleEndian.getShort(data, 2 + offset);
        this.field_3_xf = LittleEndian.getShort(data, 4 + offset);
        this.field_4_value = LittleEndian.getDouble(data, 6 + offset);
    }

    public short getColumn() {
        return this.field_2_col;
    }

    public int getRecordSize() {
        return 18;
    }

    public int getRow() {
        return this.field_1_row;
    }

    public short getSid() {
        return 515;
    }

    public double getValue() {
        return this.field_4_value;
    }

    public short getXFIndex() {
        return this.field_3_xf;
    }

    public boolean isAfter(CellValueRecordInterface i) {
        if (this.getRow() < i.getRow()) {
            return false;
        }
        if (this.getRow() == i.getRow() && this.getColumn() < i.getColumn()) {
            return false;
        }
        return this.getRow() != i.getRow() || this.getColumn() != i.getColumn();
    }

    public boolean isBefore(CellValueRecordInterface i) {
        if (this.getRow() > i.getRow()) {
            return false;
        }
        if (this.getRow() == i.getRow() && this.getColumn() > i.getColumn()) {
            return false;
        }
        return this.getRow() != i.getRow() || this.getColumn() != i.getColumn();
    }

    public boolean isEqual(CellValueRecordInterface i) {
        return this.getRow() == i.getRow() && this.getColumn() == i.getColumn();
    }

    public boolean isInValueSection() {
        return true;
    }

    public boolean isValue() {
        return true;
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)515);
        LittleEndian.putShort(data, 2 + offset, (short)14);
        LittleEndian.putShort(data, 4 + offset, (short)this.getRow());
        LittleEndian.putShort(data, 6 + offset, this.getColumn());
        LittleEndian.putShort(data, 8 + offset, this.getXFIndex());
        LittleEndian.putDouble(data, 10 + offset, this.getValue());
        return this.getRecordSize();
    }

    public void setColumn(short col) {
        this.field_2_col = col;
    }

    public void setRow(int row) {
        this.field_1_row = row;
    }

    public void setValue(double value) {
        this.field_4_value = value;
    }

    public void setXFIndex(short xf) {
        this.field_3_xf = xf;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[NUMBER]\n");
        buffer.append("    .row            = ").append(Integer.toHexString(this.getRow())).append("\n");
        buffer.append("    .col            = ").append(Integer.toHexString(this.getColumn())).append("\n");
        buffer.append("    .xfindex        = ").append(Integer.toHexString(this.getXFIndex())).append("\n");
        buffer.append("    .value          = ").append(this.getValue()).append("\n");
        buffer.append("[/NUMBER]\n");
        return buffer.toString();
    }

    protected void validateSid(short id) {
        if (id != 515) {
            throw new RecordFormatException("NOT A Number RECORD");
        }
    }
}

