/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class InterfaceHdrRecord
extends Record {
    public static final short CODEPAGE = 1200;
    private short field_1_codepage;
    public static final short sid = 225;

    public InterfaceHdrRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    public InterfaceHdrRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public InterfaceHdrRecord() {
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_codepage = LittleEndian.getShort(data, 0 + offset);
    }

    public short getCodepage() {
        return this.field_1_codepage;
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 225;
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)225);
        LittleEndian.putShort(data, 2 + offset, (short)2);
        LittleEndian.putShort(data, 4 + offset, this.getCodepage());
        return this.getRecordSize();
    }

    public void setCodepage(short cp) {
        this.field_1_codepage = cp;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[INTERFACEHDR]\n");
        buffer.append("    .codepage        = ").append(Integer.toHexString(this.getCodepage())).append("\n");
        buffer.append("[/INTERFACEHDR]\n");
        return buffer.toString();
    }

    protected void validateSid(short id) {
        if (id != 225) {
            throw new RecordFormatException("NOT A INTERFACEHDR RECORD");
        }
    }
}

