/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.awt.Image;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.excel.ImdataBiffElement;

public class ImageRecord
extends Record {
    byte[] data1;
    public static final short sid = 127;

    public ImageRecord(Image image, int index, int top, int left, int bottom, int right) {
        ImdataBiffElement element = ImdataBiffElement.createImdataBiffElement(image);
        element.setIndex(index);
        element.setColLeft(left);
        element.setDxL(20);
        element.setRowTop(top);
        element.setDyT(20);
        element.setColRight(right + 1);
        element.setDxR(65534);
        element.setRowBottom(bottom + 1);
        element.setDyB(65532);
        try {
            this.data1 = element.toBinary();
        }
        catch (Exception e) {
            this.data1 = null;
        }
    }

    public ImageRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    public ImageRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public ImageRecord() {
    }

    protected void fillFields(byte[] data, short size, int offset) {
        if (data != null) {
            this.data1 = data;
        }
    }

    public int getRecordSize() {
        return this.data1 == null ? 0 : this.data1.length;
    }

    public short getSid() {
        return 127;
    }

    public int serialize(int offset, byte[] data) {
        if (this.data1 != null) {
            System.arraycopy(this.data1, 0, data, offset, this.data1.length);
        }
        return this.getRecordSize();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[IMAGE]\n");
        buffer.append("    .id         = ").append(Integer.toHexString(127)).append("\n");
        buffer.append("[/IMAGE]\n");
        return buffer.toString();
    }

    protected void validateSid(short id) {
        if (id != 127) {
            throw new RecordFormatException("NOT A IMAGE RECORD");
        }
    }
}

