/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class HideObjRecord
extends Record {
    public static final short HIDE_ALL = 2;
    public static final short SHOW_ALL = 0;
    public static final short SHOW_PLACEHOLDERS = 1;
    private short field_1_hide_obj;
    public static final short sid = 141;

    public HideObjRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    public HideObjRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public HideObjRecord() {
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_hide_obj = LittleEndian.getShort(data, 0 + offset);
    }

    public short getHideObj() {
        return this.field_1_hide_obj;
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 141;
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)141);
        LittleEndian.putShort(data, 2 + offset, (short)2);
        LittleEndian.putShort(data, 4 + offset, this.getHideObj());
        return this.getRecordSize();
    }

    public void setHideObj(short hide) {
        this.field_1_hide_obj = hide;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[HIDEOBJ]\n");
        buffer.append("    .hideobj         = ").append(Integer.toHexString(this.getHideObj())).append("\n");
        buffer.append("[/HIDEOBJ]\n");
        return buffer.toString();
    }

    protected void validateSid(short id) {
        if (id != 141) {
            throw new RecordFormatException("NOT A HIDEOBJ RECORD");
        }
    }
}

