/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class GridsetRecord
extends Record {
    public short field_1_gridset_flag;
    public static final short sid = 130;

    public GridsetRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    public GridsetRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public GridsetRecord() {
    }

    public Object clone() {
        GridsetRecord rec = new GridsetRecord();
        rec.field_1_gridset_flag = this.field_1_gridset_flag;
        return rec;
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_gridset_flag = LittleEndian.getShort(data, 0 + offset);
    }

    public boolean getGridset() {
        return this.field_1_gridset_flag == 1;
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 130;
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)130);
        LittleEndian.putShort(data, 2 + offset, (short)2);
        LittleEndian.putShort(data, 4 + offset, this.field_1_gridset_flag);
        return this.getRecordSize();
    }

    public void setGridset(boolean gridset) {
        this.field_1_gridset_flag = gridset ? (short)1 : 0;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[GRIDSET]\n");
        buffer.append("    .gridset        = ").append(this.getGridset()).append("\n");
        buffer.append("[/GRIDSET]\n");
        return buffer.toString();
    }

    protected void validateSid(short id) {
        if (id != 130) {
            throw new RecordFormatException("NOT A Gridset RECORD");
        }
    }
}

