/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class FontIndexRecord
extends Record {
    private short field_1_fontIndex;
    public static final short sid = 4134;

    public FontIndexRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    public FontIndexRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public FontIndexRecord() {
    }

    public Object clone() {
        FontIndexRecord rec = new FontIndexRecord();
        rec.field_1_fontIndex = this.field_1_fontIndex;
        return rec;
    }

    protected void fillFields(byte[] data, short size, int offset) {
        int pos = 0;
        this.field_1_fontIndex = LittleEndian.getShort(data, pos + 0 + offset);
    }

    public short getFontIndex() {
        return this.field_1_fontIndex;
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 4134;
    }

    public int serialize(int offset, byte[] data) {
        int pos = 0;
        LittleEndian.putShort(data, 0 + offset, (short)4134);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(data, 4 + offset + pos, this.field_1_fontIndex);
        return this.getRecordSize();
    }

    public void setFontIndex(short field_1_fontIndex) {
        this.field_1_fontIndex = field_1_fontIndex;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[FONTX]\n");
        buffer.append("    .fontIndex            = ").append("0x").append(HexDump.toHex(this.getFontIndex())).append(" (").append(this.getFontIndex()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("[/FONTX]\n");
        return buffer.toString();
    }

    protected void validateSid(short id) {
        if (id != 4134) {
            throw new RecordFormatException("Not a FontIndex record");
        }
    }
}

