/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.util.LittleEndian;

public class ExternSheetSubRecord
extends Record {
    private short field_1_index_to_supbook;
    private short field_2_index_to_first_supbook_sheet;
    private short field_3_index_to_last_supbook_sheet;
    public static final short sid = 4095;

    public ExternSheetSubRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    public ExternSheetSubRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public ExternSheetSubRecord() {
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_index_to_supbook = LittleEndian.getShort(data, 0 + offset);
        this.field_2_index_to_first_supbook_sheet = LittleEndian.getShort(data, 2 + offset);
        this.field_3_index_to_last_supbook_sheet = LittleEndian.getShort(data, 4 + offset);
    }

    public short getIndexToFirstSupBook() {
        return this.field_2_index_to_first_supbook_sheet;
    }

    public short getIndexToLastSupBook() {
        return this.field_3_index_to_last_supbook_sheet;
    }

    public short getIndexToSupBook() {
        return this.field_1_index_to_supbook;
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 4095;
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, this.getIndexToSupBook());
        LittleEndian.putShort(data, 2 + offset, this.getIndexToFirstSupBook());
        LittleEndian.putShort(data, 4 + offset, this.getIndexToLastSupBook());
        return this.getRecordSize();
    }

    public void setIndexToFirstSupBook(short index) {
        this.field_2_index_to_first_supbook_sheet = index;
    }

    public void setIndexToLastSupBook(short index) {
        this.field_3_index_to_last_supbook_sheet = index;
    }

    public void setIndexToSupBook(short index) {
        this.field_1_index_to_supbook = index;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("   supbookindex =").append(this.getIndexToSupBook()).append('\n');
        buffer.append("   1stsbindex   =").append(this.getIndexToFirstSupBook()).append('\n');
        buffer.append("   lastsbindex  =").append(this.getIndexToLastSupBook()).append('\n');
        return buffer.toString();
    }

    protected void validateSid(short id) {
    }
}

