/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.ArrayList;
import org.apache.poi.hssf.record.ExternSheetSubRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class ExternSheetRecord
extends Record {
    private short field_1_number_of_REF_sturcutres;
    private ArrayList field_2_REF_structures;
    public static final short sid = 23;

    public ExternSheetRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    public ExternSheetRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public ExternSheetRecord() {
        this.field_2_REF_structures = new ArrayList();
    }

    public void addREFRecord(ExternSheetSubRecord rec) {
        this.field_2_REF_structures.add(rec);
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_2_REF_structures = new ArrayList();
        this.field_1_number_of_REF_sturcutres = LittleEndian.getShort(data, 0 + offset);
        int pos = 2 + offset;
        int i = 0;
        while (i < this.field_1_number_of_REF_sturcutres) {
            ExternSheetSubRecord rec = new ExternSheetSubRecord(0, 6, data, pos);
            pos += 6;
            this.field_2_REF_structures.add(rec);
            ++i;
        }
    }

    public int getNumOfREFRecords() {
        return this.field_2_REF_structures.size();
    }

    public short getNumOfREFStructures() {
        return this.field_1_number_of_REF_sturcutres;
    }

    public ExternSheetSubRecord getREFRecordAt(int elem) {
        ExternSheetSubRecord result = (ExternSheetSubRecord)this.field_2_REF_structures.get(elem);
        return result;
    }

    public int getRecordSize() {
        return 6 + this.getNumOfREFRecords() * 6;
    }

    public short getSid() {
        return 23;
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)23);
        LittleEndian.putShort(data, 2 + offset, (short)(2 + this.getNumOfREFRecords() * 6));
        LittleEndian.putShort(data, 4 + offset, this.getNumOfREFStructures());
        int pos = 6;
        int k = 0;
        while (k < this.getNumOfREFRecords()) {
            ExternSheetSubRecord record = this.getREFRecordAt(k);
            System.arraycopy(record.serialize(), 0, data, pos + offset, 6);
            pos += 6;
            ++k;
        }
        return this.getRecordSize();
    }

    public void setNumOfREFStructures(short numStruct) {
        this.field_1_number_of_REF_sturcutres = numStruct;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[EXTERNSHEET]\n");
        buffer.append("   numOfRefs     = ").append(this.getNumOfREFStructures()).append("\n");
        int k = 0;
        while (k < this.getNumOfREFRecords()) {
            buffer.append("refrec         #").append(k).append('\n');
            buffer.append(this.getREFRecordAt(k).toString());
            buffer.append("----refrec     #").append(k).append('\n');
            ++k;
        }
        buffer.append("[/EXTERNSHEET]\n");
        return buffer.toString();
    }

    protected void validateSid(short id) {
        if (id != 23) {
            throw new RecordFormatException("NOT An ExternSheet RECORD");
        }
    }
}

