/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.ArrayList;
import org.apache.poi.hssf.record.ExtSSTInfoSubRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class ExtSSTRecord
extends Record {
    public static final int DEFAULT_BUCKET_SIZE = 8;
    public static final int MAX_BUCKETS = 128;
    private short field_1_strings_per_bucket = (short)8;
    private ArrayList field_2_sst_info;
    public static final short sid = 255;

    public ExtSSTRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    public ExtSSTRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public ExtSSTRecord() {
        this.field_2_sst_info = new ArrayList();
    }

    public void addInfoRecord(ExtSSTInfoSubRecord rec) {
        this.field_2_sst_info.add(rec);
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_2_sst_info = new ArrayList();
        this.field_1_strings_per_bucket = LittleEndian.getShort(data, 0 + offset);
        int k = 2;
        while (k < size - offset) {
            byte[] tempdata = new byte[8 + offset];
            System.arraycopy(data, k, tempdata, 0, 8);
            ExtSSTInfoSubRecord rec = new ExtSSTInfoSubRecord(0, 8, tempdata);
            this.field_2_sst_info.add(rec);
            k += 8;
        }
    }

    public ExtSSTInfoSubRecord getInfoRecordAt(int elem) {
        return (ExtSSTInfoSubRecord)this.field_2_sst_info.get(elem);
    }

    public int getNumInfoRecords() {
        return this.field_2_sst_info.size();
    }

    public short getNumStringsPerBucket() {
        return this.field_1_strings_per_bucket;
    }

    public static final int getNumberOfInfoRecsForStrings(int numStrings) {
        int infoRecs = numStrings / 8;
        if (numStrings % 8 != 0) {
            ++infoRecs;
        }
        if (infoRecs > 128) {
            infoRecs = 128;
        }
        return infoRecs;
    }

    public int getRecordSize() {
        return 6 + 8 * this.getNumInfoRecords();
    }

    public static final int getRecordSizeForStrings(int numStrings) {
        return 6 + ExtSSTRecord.getNumberOfInfoRecsForStrings(numStrings) * 8;
    }

    public short getSid() {
        return 255;
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)255);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(data, 4 + offset, this.field_1_strings_per_bucket);
        int pos = 6;
        int k = 0;
        while (k < this.getNumInfoRecords()) {
            ExtSSTInfoSubRecord rec = this.getInfoRecordAt(k);
            pos += rec.serialize(pos + offset, data);
            ++k;
        }
        return pos;
    }

    public void setBucketOffsets(int[] bucketAbsoluteOffsets, int[] bucketRelativeOffsets) {
        this.field_2_sst_info = new ArrayList(bucketAbsoluteOffsets.length);
        int i = 0;
        while (i < bucketAbsoluteOffsets.length) {
            ExtSSTInfoSubRecord r = new ExtSSTInfoSubRecord();
            r.setBucketRecordOffset((short)bucketRelativeOffsets[i]);
            r.setStreamPos(bucketAbsoluteOffsets[i]);
            this.field_2_sst_info.add(r);
            ++i;
        }
    }

    public void setNumStringsPerBucket(short numStrings) {
        this.field_1_strings_per_bucket = numStrings;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[EXTSST]\n");
        buffer.append("    .dsst           = ").append(Integer.toHexString(this.getNumStringsPerBucket())).append("\n");
        buffer.append("    .numInfoRecords = ").append(this.getNumInfoRecords()).append("\n");
        int k = 0;
        while (k < this.getNumInfoRecords()) {
            buffer.append("    .inforecord     = ").append(k).append("\n");
            buffer.append("    .streampos      = ").append(Integer.toHexString(this.getInfoRecordAt(k).getStreamPos())).append("\n");
            buffer.append("    .sstoffset      = ").append(Integer.toHexString(this.getInfoRecordAt(k).getBucketSSTOffset())).append("\n");
            ++k;
        }
        buffer.append("[/EXTSST]\n");
        return buffer.toString();
    }

    protected void validateSid(short id) {
        if (id != 255) {
            throw new RecordFormatException("NOT An EXTSST RECORD");
        }
    }
}

