/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class DrawingRecord
extends Record {
    private byte[] recordData;
    public static final short sid = 236;

    public DrawingRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    public DrawingRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public DrawingRecord() {
    }

    protected void fillFields(byte[] data, short size) {
        this.recordData = data;
    }

    protected void fillFields(byte[] data, short size, int offset) {
        if (offset == 0 && size == data.length) {
            this.recordData = data;
        } else {
            this.recordData = new byte[size];
            System.arraycopy(data, offset, this.recordData, 0, size);
        }
    }

    public byte[] getData() {
        return this.recordData;
    }

    public int getRecordSize() {
        int retval = 4;
        if (this.recordData != null) {
            retval += this.recordData.length;
        }
        return retval;
    }

    public short getSid() {
        return 236;
    }

    public int serialize(int offset, byte[] data) {
        if (this.recordData == null) {
            this.recordData = new byte[0];
        }
        LittleEndian.putShort(data, 0 + offset, (short)236);
        LittleEndian.putShort(data, 2 + offset, (short)this.recordData.length);
        if (this.recordData.length > 0) {
            System.arraycopy(this.recordData, 0, data, 4 + offset, this.recordData.length);
        }
        return this.getRecordSize();
    }

    public void setData(byte[] thedata) {
        this.recordData = thedata;
    }

    protected void validateSid(short id) {
        if (id != 236) {
            throw new RecordFormatException("Not a MSODRAWING record");
        }
    }
}

