/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class DeltaRecord
extends Record {
    public static final double DEFAULT_VALUE = 0.001;
    private double field_1_max_change;
    public static final short sid = 16;

    public DeltaRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    public DeltaRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public DeltaRecord() {
    }

    public Object clone() {
        DeltaRecord rec = new DeltaRecord();
        rec.field_1_max_change = this.field_1_max_change;
        return rec;
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_max_change = LittleEndian.getDouble(data, 0 + offset);
    }

    public double getMaxChange() {
        return this.field_1_max_change;
    }

    public int getRecordSize() {
        return 12;
    }

    public short getSid() {
        return 16;
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)16);
        LittleEndian.putShort(data, 2 + offset, (short)8);
        LittleEndian.putDouble(data, 4 + offset, this.getMaxChange());
        return this.getRecordSize();
    }

    public void setMaxChange(double maxChange) {
        this.field_1_max_change = maxChange;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[DELTA]\n");
        buffer.append("    .maxchange      = ").append(this.getMaxChange()).append("\n");
        buffer.append("[/DELTA]\n");
        return buffer.toString();
    }

    protected void validateSid(short id) {
        if (id != 16) {
            throw new RecordFormatException("NOT A DELTA RECORD");
        }
    }
}

