/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class DateWindow1904Record
extends Record {
    private short field_1_window;
    public static final short sid = 34;

    public DateWindow1904Record(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    public DateWindow1904Record(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public DateWindow1904Record() {
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_window = LittleEndian.getShort(data, 0 + offset);
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 34;
    }

    public short getWindowing() {
        return this.field_1_window;
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)34);
        LittleEndian.putShort(data, 2 + offset, (short)2);
        LittleEndian.putShort(data, 4 + offset, this.getWindowing());
        return this.getRecordSize();
    }

    public void setWindowing(short window) {
        this.field_1_window = window;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[1904]\n");
        buffer.append("    .is1904          = ").append(Integer.toHexString(this.getWindowing())).append("\n");
        buffer.append("[/1904]\n");
        return buffer.toString();
    }

    protected void validateSid(short id) {
        if (id != 34) {
            throw new RecordFormatException("NOT A 1904 RECORD");
        }
    }
}

