/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.BitField;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class DataFormatRecord
extends Record {
    private short field_1_pointNumber;
    private short field_2_seriesIndex;
    private short field_3_seriesNumber;
    private short field_4_formatFlags;
    public static final short sid = 4102;
    private BitField useExcel4Colors = new BitField(1);

    public DataFormatRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    public DataFormatRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public DataFormatRecord() {
    }

    public Object clone() {
        DataFormatRecord rec = new DataFormatRecord();
        rec.field_1_pointNumber = this.field_1_pointNumber;
        rec.field_2_seriesIndex = this.field_2_seriesIndex;
        rec.field_3_seriesNumber = this.field_3_seriesNumber;
        rec.field_4_formatFlags = this.field_4_formatFlags;
        return rec;
    }

    protected void fillFields(byte[] data, short size, int offset) {
        int pos = 0;
        this.field_1_pointNumber = LittleEndian.getShort(data, pos + 0 + offset);
        this.field_2_seriesIndex = LittleEndian.getShort(data, pos + 2 + offset);
        this.field_3_seriesNumber = LittleEndian.getShort(data, pos + 4 + offset);
        this.field_4_formatFlags = LittleEndian.getShort(data, pos + 6 + offset);
    }

    public short getFormatFlags() {
        return this.field_4_formatFlags;
    }

    public short getPointNumber() {
        return this.field_1_pointNumber;
    }

    public int getRecordSize() {
        return 12;
    }

    public short getSeriesIndex() {
        return this.field_2_seriesIndex;
    }

    public short getSeriesNumber() {
        return this.field_3_seriesNumber;
    }

    public short getSid() {
        return 4102;
    }

    public boolean isUseExcel4Colors() {
        return this.useExcel4Colors.isSet(this.field_4_formatFlags);
    }

    public int serialize(int offset, byte[] data) {
        int pos = 0;
        LittleEndian.putShort(data, 0 + offset, (short)4102);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(data, 4 + offset + pos, this.field_1_pointNumber);
        LittleEndian.putShort(data, 6 + offset + pos, this.field_2_seriesIndex);
        LittleEndian.putShort(data, 8 + offset + pos, this.field_3_seriesNumber);
        LittleEndian.putShort(data, 10 + offset + pos, this.field_4_formatFlags);
        return this.getRecordSize();
    }

    public void setFormatFlags(short field_4_formatFlags) {
        this.field_4_formatFlags = field_4_formatFlags;
    }

    public void setPointNumber(short field_1_pointNumber) {
        this.field_1_pointNumber = field_1_pointNumber;
    }

    public void setSeriesIndex(short field_2_seriesIndex) {
        this.field_2_seriesIndex = field_2_seriesIndex;
    }

    public void setSeriesNumber(short field_3_seriesNumber) {
        this.field_3_seriesNumber = field_3_seriesNumber;
    }

    public void setUseExcel4Colors(boolean value) {
        this.field_4_formatFlags = this.useExcel4Colors.setShortBoolean(this.field_4_formatFlags, value);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[DATAFORMAT]\n");
        buffer.append("    .pointNumber          = ").append("0x").append(HexDump.toHex(this.getPointNumber())).append(" (").append(this.getPointNumber()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .seriesIndex          = ").append("0x").append(HexDump.toHex(this.getSeriesIndex())).append(" (").append(this.getSeriesIndex()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .seriesNumber         = ").append("0x").append(HexDump.toHex(this.getSeriesNumber())).append(" (").append(this.getSeriesNumber()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .formatFlags          = ").append("0x").append(HexDump.toHex(this.getFormatFlags())).append(" (").append(this.getFormatFlags()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("         .useExcel4Colors          = ").append(this.isUseExcel4Colors()).append('\n');
        buffer.append("[/DATAFORMAT]\n");
        return buffer.toString();
    }

    protected void validateSid(short id) {
        if (id != 4102) {
            throw new RecordFormatException("Not a DataFormat record");
        }
    }
}

