/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class CountryRecord
extends Record {
    private short field_1_default_country;
    private short field_2_current_country;
    public static final short sid = 140;

    public CountryRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    public CountryRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public CountryRecord() {
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_default_country = LittleEndian.getShort(data, 0 + offset);
        this.field_2_current_country = LittleEndian.getShort(data, 2 + offset);
    }

    public short getCurrentCountry() {
        return this.field_2_current_country;
    }

    public short getDefaultCountry() {
        return this.field_1_default_country;
    }

    public int getRecordSize() {
        return 8;
    }

    public short getSid() {
        return 140;
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)140);
        LittleEndian.putShort(data, 2 + offset, (short)4);
        LittleEndian.putShort(data, 4 + offset, this.getDefaultCountry());
        LittleEndian.putShort(data, 6 + offset, this.getCurrentCountry());
        return this.getRecordSize();
    }

    public void setCurrentCountry(short country) {
        this.field_2_current_country = country;
    }

    public void setDefaultCountry(short country) {
        this.field_1_default_country = country;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[COUNTRY]\n");
        buffer.append("    .defaultcountry  = ").append(Integer.toHexString(this.getDefaultCountry())).append("\n");
        buffer.append("    .currentcountry  = ").append(Integer.toHexString(this.getCurrentCountry())).append("\n");
        buffer.append("[/COUNTRY]\n");
        return buffer.toString();
    }

    protected void validateSid(short id) {
        if (id != 140) {
            throw new RecordFormatException("NOT A Country RECORD");
        }
    }
}

