/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.BitField;
import org.apache.poi.util.LittleEndian;

public class ChartFormatRecord
extends Record {
    private int field1_x_position;
    private int field2_y_position;
    private int field3_width;
    private int field4_height;
    private short field5_grbit;
    public static final short sid = 4116;
    private BitField varyDisplayPattern = new BitField(1);

    public ChartFormatRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    public ChartFormatRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public ChartFormatRecord() {
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field1_x_position = LittleEndian.getInt(data, 0 + offset);
        this.field2_y_position = LittleEndian.getInt(data, 4 + offset);
        this.field3_width = LittleEndian.getInt(data, 8 + offset);
        this.field4_height = LittleEndian.getInt(data, 12 + offset);
        this.field5_grbit = LittleEndian.getShort(data, 16 + offset);
    }

    public int getHeight() {
        return this.field4_height;
    }

    public int getRecordSize() {
        return 22;
    }

    public short getSid() {
        return 4116;
    }

    public boolean getVaryDisplayPattern() {
        return this.varyDisplayPattern.isSet(this.field5_grbit);
    }

    public int getWidth() {
        return this.field3_width;
    }

    public int getXPosition() {
        return this.field1_x_position;
    }

    public int getYPosition() {
        return this.field2_y_position;
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)4116);
        LittleEndian.putShort(data, 2 + offset, (short)22);
        LittleEndian.putInt(data, 4 + offset, this.getXPosition());
        LittleEndian.putInt(data, 8 + offset, this.getYPosition());
        LittleEndian.putInt(data, 12 + offset, this.getWidth());
        LittleEndian.putInt(data, 16 + offset, this.getHeight());
        LittleEndian.putShort(data, 20 + offset, this.field5_grbit);
        return this.getRecordSize();
    }

    public void setHeight(int height) {
        this.field4_height = height;
    }

    public void setVaryDisplayPattern(boolean value) {
        this.field5_grbit = this.varyDisplayPattern.setShortBoolean(this.field5_grbit, value);
    }

    public void setWidth(int width) {
        this.field3_width = width;
    }

    public void setXPosition(int xPosition) {
        this.field1_x_position = xPosition;
    }

    public void setYPosition(int yPosition) {
        this.field2_y_position = yPosition;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[CHARTFORMAT]\n");
        buffer.append("    .xPosition       = ").append(this.getXPosition()).append("\n");
        buffer.append("    .yPosition       = ").append(this.getYPosition()).append("\n");
        buffer.append("    .width           = ").append(this.getWidth()).append("\n");
        buffer.append("    .height          = ").append(this.getHeight()).append("\n");
        buffer.append("    .grBit           = ").append(Integer.toHexString(this.field5_grbit)).append("\n");
        buffer.append("[/CHARTFORMAT]\n");
        return buffer.toString();
    }

    protected void validateSid(short id) {
        if (id != 4116) {
            throw new RecordFormatException("NOT A CHARTFORMAT RECORD");
        }
    }
}

