/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ddf.DefaultEscherRecordFactory;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.NullEscherSerializationListener;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public abstract class AbstractEscherHolderRecord
extends Record {
    private static final boolean DESERIALISE = System.getProperty("poi.deserialize.escher") != null;
    private List escherRecords;
    private byte[] rawData;

    public AbstractEscherHolderRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    public AbstractEscherHolderRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public AbstractEscherHolderRecord() {
        this.escherRecords = new ArrayList();
    }

    public boolean addEscherRecord(EscherRecord element) {
        return this.escherRecords.add(element);
    }

    public void addEscherRecord(int index, EscherRecord element) {
        this.escherRecords.add(index, element);
    }

    public void clearEscherRecords() {
        this.escherRecords.clear();
    }

    public Object clone() {
        throw new IllegalStateException("Not implemented yet.");
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.escherRecords = new ArrayList();
        if (!DESERIALISE) {
            this.rawData = new byte[size];
            System.arraycopy(data, offset, this.rawData, 0, size);
        } else {
            DefaultEscherRecordFactory recordFactory = new DefaultEscherRecordFactory();
            int pos = offset;
            while (pos < offset + size) {
                EscherRecord r = recordFactory.createRecord(data, pos);
                int bytesRead = r.fillFields(data, pos, recordFactory);
                this.escherRecords.add(r);
                pos += bytesRead;
            }
        }
    }

    public EscherRecord getEscherRecord(int index) {
        return (EscherRecord)this.escherRecords.get(index);
    }

    public List getEscherRecords() {
        return this.escherRecords;
    }

    protected abstract String getRecordName();

    public int getRecordSize() {
        if (this.escherRecords.size() == 0 && this.rawData != null) {
            return this.rawData.length + 4;
        }
        int size = 4;
        Iterator iterator = this.escherRecords.iterator();
        while (iterator.hasNext()) {
            EscherRecord r = (EscherRecord)iterator.next();
            size += r.getRecordSize();
        }
        return size;
    }

    public abstract short getSid();

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, this.getSid());
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        if (this.escherRecords.size() == 0 && this.rawData != null) {
            System.arraycopy(this.rawData, 0, data, offset + 4, this.rawData.length);
        } else {
            int pos = offset + 4;
            Iterator iterator = this.escherRecords.iterator();
            while (iterator.hasNext()) {
                EscherRecord r = (EscherRecord)iterator.next();
                pos += r.serialize(pos, data, new NullEscherSerializationListener());
            }
        }
        return this.getRecordSize();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        String nl = System.getProperty("line.separator");
        buffer.append('[' + this.getRecordName() + ']' + nl);
        Iterator iterator = this.escherRecords.iterator();
        while (iterator.hasNext()) {
            EscherRecord r = (EscherRecord)iterator.next();
            buffer.append(r.toString());
        }
        buffer.append("[/" + this.getRecordName() + ']' + nl);
        return buffer.toString();
    }

    protected void validateSid(short id) {
        if (id != this.getSid()) {
            throw new RecordFormatException("Not a Bar record");
        }
    }
}

