/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.hssf.model.DrawingManager;
import org.apache.poi.hssf.model.FormulaParser;
import org.apache.poi.hssf.model.Model;
import org.apache.poi.hssf.model.Workbook;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BlankRecord;
import org.apache.poi.hssf.record.BottomMarginRecord;
import org.apache.poi.hssf.record.CalcCountRecord;
import org.apache.poi.hssf.record.CalcModeRecord;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.ColumnInfoRecord;
import org.apache.poi.hssf.record.DBCellRecord;
import org.apache.poi.hssf.record.DefaultColWidthRecord;
import org.apache.poi.hssf.record.DefaultRowHeightRecord;
import org.apache.poi.hssf.record.DeltaRecord;
import org.apache.poi.hssf.record.DimensionsRecord;
import org.apache.poi.hssf.record.DrawingRecord;
import org.apache.poi.hssf.record.EOFRecord;
import org.apache.poi.hssf.record.EscherAggregate;
import org.apache.poi.hssf.record.FooterRecord;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.GridsetRecord;
import org.apache.poi.hssf.record.GutsRecord;
import org.apache.poi.hssf.record.HCenterRecord;
import org.apache.poi.hssf.record.HeaderRecord;
import org.apache.poi.hssf.record.IndexRecord;
import org.apache.poi.hssf.record.IterationRecord;
import org.apache.poi.hssf.record.LabelRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.LeftMarginRecord;
import org.apache.poi.hssf.record.Margin;
import org.apache.poi.hssf.record.MergeCellsRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.ObjRecord;
import org.apache.poi.hssf.record.PageBreakRecord;
import org.apache.poi.hssf.record.PaneRecord;
import org.apache.poi.hssf.record.PasswordRecord;
import org.apache.poi.hssf.record.PrintGridlinesRecord;
import org.apache.poi.hssf.record.PrintHeadersRecord;
import org.apache.poi.hssf.record.PrintSetupRecord;
import org.apache.poi.hssf.record.ProtectRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RefModeRecord;
import org.apache.poi.hssf.record.RightMarginRecord;
import org.apache.poi.hssf.record.RowRecord;
import org.apache.poi.hssf.record.SCLRecord;
import org.apache.poi.hssf.record.SaveRecalcRecord;
import org.apache.poi.hssf.record.SelectionRecord;
import org.apache.poi.hssf.record.TopMarginRecord;
import org.apache.poi.hssf.record.VCenterRecord;
import org.apache.poi.hssf.record.WSBoolRecord;
import org.apache.poi.hssf.record.WindowTwoRecord;
import org.apache.poi.hssf.record.aggregates.ColumnInfoRecordsAggregate;
import org.apache.poi.hssf.record.aggregates.FormulaRecordAggregate;
import org.apache.poi.hssf.record.aggregates.RowRecordsAggregate;
import org.apache.poi.hssf.record.aggregates.ValueRecordsAggregate;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.util.IntList;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public class Sheet
implements Model {
    public static final short BottomMargin = 3;
    public static final short LeftMargin = 0;
    public static final byte PANE_LOWER_LEFT = 2;
    public static final byte PANE_LOWER_RIGHT = 0;
    public static final byte PANE_UPPER_LEFT = 3;
    public static final byte PANE_UPPER_RIGHT = 1;
    public static final short RightMargin = 1;
    public static final short TopMargin = 2;
    protected ValueRecordsAggregate cells = null;
    static /* synthetic */ Class class$org$apache$poi$hssf$model$Sheet;
    protected PageBreakRecord colBreaks = null;
    protected ColumnInfoRecordsAggregate columns = null;
    protected boolean containsLabels = false;
    protected DefaultColWidthRecord defaultcolwidth = null;
    protected DefaultRowHeightRecord defaultrowheight = null;
    protected DimensionsRecord dims;
    protected int dimsloc = 0;
    protected int eofLoc = 0;
    protected FooterRecord footer = null;
    protected GridsetRecord gridset = null;
    protected HeaderRecord header = null;
    int loc = 0;
    private static POILogger log = POILogFactory.getLogger(class$org$apache$poi$hssf$model$Sheet == null ? (class$org$apache$poi$hssf$model$Sheet = Sheet.class$("org.apache.poi.hssf.model.Sheet")) : class$org$apache$poi$hssf$model$Sheet);
    protected Margin[] margins = null;
    protected MergeCellsRecord merged = null;
    protected List mergedRecords = new ArrayList();
    protected int numMergedRegions = 0;
    protected PasswordRecord password = null;
    int preoffset = 0;
    protected PrintGridlinesRecord printGridlines = null;
    protected PrintSetupRecord printSetup = null;
    protected ProtectRecord protect = null;
    protected ArrayList records = null;
    protected PageBreakRecord rowBreaks = null;
    private Iterator rowRecIterator = null;
    protected RowRecordsAggregate rows = null;
    protected SelectionRecord selection = null;
    private Iterator valueRecIterator = null;
    protected WindowTwoRecord windowTwo = null;

    public void addDBCellRecords() {
        Record rec;
        int offset = 0;
        int recnum = 0;
        int rownum = 0;
        IndexRecord index = null;
        IntList rowOffsets = new IntList();
        recnum = 0;
        while (recnum < this.records.size()) {
            rec = (Record)this.records.get(recnum);
            if (rec.getSid() == 523) {
                index = (IndexRecord)rec;
            }
            if (rec.getSid() == 520) break;
            offset += rec.serialize().length;
            ++recnum;
        }
        while (recnum < this.records.size()) {
            rec = (Record)this.records.get(recnum);
            if (rec.getSid() == 520) {
                rowOffsets.add(offset);
                if (++rownum % 32 == 0) {
                    int rn = recnum;
                    while (rn < this.records.size()) {
                        rec = (Record)this.records.get(rn);
                        if (!rec.isInValueSection() || rec.getSid() == 520) {
                            this.records.add(rn, this.createDBCell(offset, rowOffsets, index));
                            recnum = rn;
                            break;
                        }
                        ++rn;
                    }
                }
            }
            if (!rec.isInValueSection()) {
                this.records.add(recnum, this.createDBCell(offset, rowOffsets, index));
                break;
            }
            offset += rec.serialize().length;
            ++recnum;
        }
    }

    private void addDbCellToIndex(int offset, IndexRecord index) {
        int numdbcells = index.getNumDbcells() + 1;
        index.addDbcell(offset + this.preoffset);
        int k = 0;
        while (k < numdbcells) {
            int dbval = index.getDbcellAt(k);
            index.setDbcell(k, dbval + 4);
            ++k;
        }
    }

    public int addMergedRegion(int rowFrom, short colFrom, int rowTo, short colTo) {
        if (this.merged == null || this.merged.getNumAreas() == 1027) {
            this.merged = (MergeCellsRecord)this.createMergedCells();
            this.mergedRecords.add(this.merged);
            this.records.add(this.records.size() - 1, this.merged);
        }
        this.merged.addArea(rowFrom, colFrom, rowTo, colTo);
        return this.numMergedRegions++;
    }

    public void addRow(RowRecord row) {
        RowRecord existingRow;
        this.checkRows();
        if (log.check(1)) {
            log.log(1, "addRow ");
        }
        DimensionsRecord d = (DimensionsRecord)this.records.get(this.getDimsLoc());
        if (row.getRowNumber() >= d.getLastRow()) {
            d.setLastRow(row.getRowNumber() + 1);
        }
        if (row.getRowNumber() < d.getFirstRow()) {
            d.setFirstRow(row.getRowNumber());
        }
        if ((existingRow = this.rows.getRow(row.getRowNumber())) != null) {
            this.rows.removeRow(existingRow);
        }
        this.rows.insertRow(row);
        if (log.check(1)) {
            log.log(1, "exit addRow");
        }
    }

    public void addValueRecord(int row, CellValueRecordInterface col) {
        this.checkCells();
        log.logFormatted(1, "add value record  row,loc %,%", new int[]{row, this.loc});
        DimensionsRecord d = (DimensionsRecord)this.records.get(this.getDimsLoc());
        if (col.getColumn() > d.getLastCol()) {
            d.setLastCol((short)(col.getColumn() + 1));
        }
        if (col.getColumn() < d.getFirstCol()) {
            d.setFirstCol(col.getColumn());
        }
        this.cells.insertCell(col);
    }

    public int aggregateDrawingRecords(DrawingManager drawingManager) {
        boolean noDrawingRecordsFound;
        int loc = this.findFirstRecordLocBySid((short)236);
        boolean bl = noDrawingRecordsFound = loc == -1;
        if (noDrawingRecordsFound) {
            EscherAggregate aggregate = new EscherAggregate(drawingManager);
            loc = this.findFirstRecordLocBySid((short)9876);
            if (loc == -1) {
                loc = this.findFirstRecordLocBySid((short)574);
            } else {
                this.getRecords().remove(loc);
            }
            this.getRecords().add(loc, aggregate);
            return loc;
        }
        List records = this.getRecords();
        EscherAggregate r = EscherAggregate.createAggregate(records, loc, drawingManager);
        int startloc = loc;
        while (loc + 1 < records.size() && records.get(loc) instanceof DrawingRecord && records.get(loc + 1) instanceof ObjRecord) {
            loc += 2;
        }
        int endloc = loc - 1;
        int i = 0;
        while (i < endloc - startloc + 1) {
            records.remove(startloc);
            ++i;
        }
        records.add(startloc, r);
        return startloc;
    }

    private void checkCells() {
        if (this.cells == null) {
            this.cells = new ValueRecordsAggregate();
            this.records.add(this.getDimsLoc() + 1, this.cells);
        }
    }

    public void checkDimsLoc(Record rec, int recloc) {
        if (rec.getSid() == 512) {
            this.loc = recloc;
            this.dimsloc = recloc;
        }
    }

    private void checkRows() {
        if (this.rows == null) {
            this.rows = new RowRecordsAggregate();
            this.records.add(this.getDimsLoc() + 1, this.rows);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public Sheet cloneSheet() {
        ArrayList<Record> clonedRecords = new ArrayList<Record>(this.records.size());
        int i = 0;
        while (i < this.records.size()) {
            Record rec = (Record)((Record)this.records.get(i)).clone();
            if (rec instanceof RowRecordsAggregate) {
                RowRecordsAggregate rrAgg = (RowRecordsAggregate)rec;
                Iterator rowIter = rrAgg.getIterator();
                while (rowIter.hasNext()) {
                    Record rowRec = (Record)rowIter.next();
                    clonedRecords.add(rowRec);
                }
            } else if (rec instanceof ValueRecordsAggregate) {
                ValueRecordsAggregate vrAgg = (ValueRecordsAggregate)rec;
                Iterator cellIter = vrAgg.getIterator();
                while (cellIter.hasNext()) {
                    Record valRec = (Record)cellIter.next();
                    clonedRecords.add(valRec);
                }
            } else if (rec instanceof FormulaRecordAggregate) {
                FormulaRecordAggregate fmAgg = (FormulaRecordAggregate)rec;
                Record fmAggRec = fmAgg.getFormulaRecord();
                if (fmAggRec != null) {
                    clonedRecords.add(fmAggRec);
                }
                if ((fmAggRec = fmAgg.getStringRecord()) != null) {
                    clonedRecords.add(fmAggRec);
                }
            } else {
                clonedRecords.add(rec);
            }
            ++i;
        }
        return Sheet.createSheet(clonedRecords, 0, 0);
    }

    public void convertLabelRecords(Workbook wb) {
        if (log.check(1)) {
            log.log(1, "convertLabelRecords called");
        }
        if (this.containsLabels) {
            int k = 0;
            while (k < this.records.size()) {
                Record rec = (Record)this.records.get(k);
                if (rec.getSid() == 516) {
                    LabelRecord oldrec = (LabelRecord)rec;
                    this.records.remove(k);
                    LabelSSTRecord newrec = new LabelSSTRecord();
                    int stringid = wb.addSSTString(oldrec.getValue());
                    newrec.setRow(oldrec.getRow());
                    newrec.setColumn(oldrec.getColumn());
                    newrec.setXFIndex(oldrec.getXFIndex());
                    newrec.setSSTIndex(stringid);
                    this.records.add(k, newrec);
                }
                ++k;
            }
        }
        if (log.check(1)) {
            log.log(1, "convertLabelRecords exit");
        }
    }

    protected Record createBOF() {
        BOFRecord retval = new BOFRecord();
        retval.setVersion((short)1536);
        retval.setType((short)16);
        retval.setBuild((short)3515);
        retval.setBuildYear((short)1996);
        retval.setHistoryBitMask(193);
        retval.setRequiredVersion(6);
        return retval;
    }

    public BlankRecord createBlank(int row, short col) {
        log.logFormatted(1, "create blank row,col %,%", new int[]{row, col});
        BlankRecord rec = new BlankRecord();
        rec.setRow(row);
        rec.setColumn(col);
        rec.setXFIndex((short)15);
        return rec;
    }

    protected Record createCalcCount() {
        CalcCountRecord retval = new CalcCountRecord();
        retval.setIterations((short)100);
        return retval;
    }

    protected Record createCalcMode() {
        CalcModeRecord retval = new CalcModeRecord();
        retval.setCalcMode((short)1);
        return retval;
    }

    protected Record createColInfo() {
        return ColumnInfoRecordsAggregate.createColInfo();
    }

    private DBCellRecord createDBCell(int offset, IntList rowoffsets, IndexRecord index) {
        DBCellRecord rec = new DBCellRecord();
        rec.setRowOffset(offset - rowoffsets.get(0));
        rec.addCellOffset((short)0);
        this.addDbCellToIndex(offset, index);
        return rec;
    }

    protected Record createDefaultColWidth() {
        DefaultColWidthRecord retval = new DefaultColWidthRecord();
        retval.setColWidth((short)8);
        return retval;
    }

    protected Record createDefaultRowHeight() {
        DefaultRowHeightRecord retval = new DefaultRowHeightRecord();
        retval.setOptionFlags((short)0);
        retval.setRowHeight((short)255);
        return retval;
    }

    protected Record createDelta() {
        DeltaRecord retval = new DeltaRecord();
        retval.setMaxChange(0.001);
        return retval;
    }

    protected Record createDimensions() {
        DimensionsRecord retval = new DimensionsRecord();
        retval.setFirstCol((short)0);
        retval.setLastRow(1);
        retval.setFirstRow(0);
        retval.setLastCol((short)1);
        return retval;
    }

    protected Record createEOF() {
        return new EOFRecord();
    }

    protected Record createFooter() {
        FooterRecord retval = new FooterRecord();
        retval.setFooterLength((byte)0);
        retval.setFooter(null);
        return retval;
    }

    public FormulaRecord createFormula(int row, short col, String formula) {
        log.logFormatted(1, "create formula row,col,formula %,%,%", new int[]{row, col}, formula);
        FormulaRecord rec = new FormulaRecord();
        rec.setRow(row);
        rec.setColumn(col);
        rec.setOptions((short)2);
        rec.setValue(0.0);
        rec.setXFIndex((short)15);
        FormulaParser fp = new FormulaParser(formula, null);
        fp.parse();
        Ptg[] ptg = fp.getRPNPtg();
        int size = 0;
        int k = 0;
        while (k < ptg.length) {
            size += ptg[k].getSize();
            rec.pushExpressionToken(ptg[k]);
            ++k;
        }
        rec.setExpressionLength((short)size);
        return rec;
    }

    public void createFreezePane(int colSplit, int rowSplit, int topRow, int leftmostColumn) {
        int loc = this.findFirstRecordLocBySid((short)574);
        PaneRecord pane = new PaneRecord();
        pane.setX((short)colSplit);
        pane.setY((short)rowSplit);
        pane.setTopRow((short)topRow);
        pane.setLeftColumn((short)leftmostColumn);
        if (rowSplit == 0) {
            pane.setTopRow((short)0);
            pane.setActivePane((short)1);
        } else if (colSplit == 0) {
            pane.setLeftColumn((short)64);
            pane.setActivePane((short)2);
        } else {
            pane.setActivePane((short)0);
        }
        this.records.add(loc + 1, pane);
        this.windowTwo.setFreezePanes(true);
        this.windowTwo.setFreezePanesNoSplit(true);
        SelectionRecord sel = (SelectionRecord)this.findFirstRecordBySid((short)29);
        sel.setPane((byte)pane.getActivePane());
    }

    protected Record createGridset() {
        GridsetRecord retval = new GridsetRecord();
        retval.setGridset(true);
        return retval;
    }

    protected Record createGuts() {
        GutsRecord retval = new GutsRecord();
        retval.setLeftRowGutter((short)0);
        retval.setTopColGutter((short)0);
        retval.setRowLevelMax((short)0);
        retval.setColLevelMax((short)0);
        return retval;
    }

    protected Record createHCenter() {
        HCenterRecord retval = new HCenterRecord();
        retval.setHCenter(false);
        return retval;
    }

    protected Record createHeader() {
        HeaderRecord retval = new HeaderRecord();
        retval.setHeaderLength((byte)0);
        retval.setHeader(null);
        return retval;
    }

    protected Record createIndex() {
        IndexRecord retval = new IndexRecord();
        retval.setFirstRow(0);
        retval.setLastRowAdd1(0);
        return retval;
    }

    protected Record createIteration() {
        IterationRecord retval = new IterationRecord();
        retval.setIteration(false);
        return retval;
    }

    public LabelSSTRecord createLabelSST(int row, short col, int index) {
        log.logFormatted(1, "create labelsst row,col,index %,%,%", new int[]{row, col, index});
        LabelSSTRecord rec = new LabelSSTRecord();
        rec.setRow(row);
        rec.setColumn(col);
        rec.setSSTIndex(index);
        rec.setXFIndex((short)15);
        return rec;
    }

    protected Record createMergedCells() {
        MergeCellsRecord retval = new MergeCellsRecord();
        retval.setNumAreas((short)0);
        return retval;
    }

    public NumberRecord createNumber(int row, short col, double value) {
        log.logFormatted(1, "create number row,col,value %,%,%", new double[]{row, col, value});
        NumberRecord rec = new NumberRecord();
        rec.setRow(row);
        rec.setColumn(col);
        rec.setValue(value);
        rec.setXFIndex((short)15);
        return rec;
    }

    protected Record createPassword() {
        if (log.check(1)) {
            log.log(1, "create password record");
        }
        PasswordRecord retval = new PasswordRecord();
        return retval;
    }

    protected Record createPrintGridlines() {
        PrintGridlinesRecord retval = new PrintGridlinesRecord();
        retval.setPrintGridlines(false);
        return retval;
    }

    protected Record createPrintHeaders() {
        PrintHeadersRecord retval = new PrintHeadersRecord();
        retval.setPrintHeaders(false);
        return retval;
    }

    protected Record createPrintSetup() {
        PrintSetupRecord retval = new PrintSetupRecord();
        retval.setPaperSize((short)1);
        retval.setScale((short)100);
        retval.setPageStart((short)1);
        retval.setFitWidth((short)1);
        retval.setFitHeight((short)1);
        retval.setOptions((short)2);
        retval.setHResolution((short)300);
        retval.setVResolution((short)300);
        retval.setHeaderMargin(0.5);
        retval.setFooterMargin(0.5);
        retval.setCopies((short)0);
        return retval;
    }

    protected Record createProtect() {
        if (log.check(1)) {
            log.log(1, "create protect record with protection disabled");
        }
        ProtectRecord retval = new ProtectRecord();
        retval.setProtect(false);
        return retval;
    }

    protected Record createRefMode() {
        RefModeRecord retval = new RefModeRecord();
        retval.setMode((short)1);
        return retval;
    }

    public RowRecord createRow(int row) {
        return RowRecordsAggregate.createRow(row);
    }

    protected Record createSaveRecalc() {
        SaveRecalcRecord retval = new SaveRecalcRecord();
        retval.setRecalc(true);
        return retval;
    }

    protected Record createSelection() {
        SelectionRecord retval = new SelectionRecord();
        retval.setPane((byte)3);
        retval.setActiveCellCol((short)0);
        retval.setActiveCellRow(0);
        retval.setNumRefs((short)0);
        return retval;
    }

    public static Sheet createSheet() {
        if (log.check(1)) {
            log.log(1, "Sheet createsheet from scratch called");
        }
        Sheet retval = new Sheet();
        ArrayList<Record> records = new ArrayList<Record>(30);
        records.add(retval.createBOF());
        records.add(retval.createCalcMode());
        records.add(retval.createCalcCount());
        records.add(retval.createRefMode());
        records.add(retval.createIteration());
        records.add(retval.createDelta());
        records.add(retval.createSaveRecalc());
        records.add(retval.createPrintHeaders());
        retval.printGridlines = (PrintGridlinesRecord)retval.createPrintGridlines();
        records.add(retval.printGridlines);
        retval.gridset = (GridsetRecord)retval.createGridset();
        records.add(retval.gridset);
        records.add(retval.createGuts());
        retval.defaultrowheight = (DefaultRowHeightRecord)retval.createDefaultRowHeight();
        records.add(retval.defaultrowheight);
        records.add(retval.createWSBool());
        retval.rowBreaks = new PageBreakRecord(27);
        records.add(retval.rowBreaks);
        retval.colBreaks = new PageBreakRecord(26);
        records.add(retval.colBreaks);
        retval.header = (HeaderRecord)retval.createHeader();
        records.add(retval.header);
        retval.footer = (FooterRecord)retval.createFooter();
        records.add(retval.footer);
        records.add(retval.createHCenter());
        records.add(retval.createVCenter());
        retval.printSetup = (PrintSetupRecord)retval.createPrintSetup();
        records.add(retval.printSetup);
        retval.defaultcolwidth = (DefaultColWidthRecord)retval.createDefaultColWidth();
        records.add(retval.defaultcolwidth);
        ColumnInfoRecordsAggregate columns = new ColumnInfoRecordsAggregate();
        records.add(columns);
        retval.columns = columns;
        retval.dims = (DimensionsRecord)retval.createDimensions();
        records.add(retval.dims);
        retval.dimsloc = records.size() - 1;
        retval.windowTwo = retval.createWindowTwo();
        records.add(retval.windowTwo);
        retval.setLoc(records.size() - 1);
        retval.selection = (SelectionRecord)retval.createSelection();
        records.add(retval.selection);
        retval.protect = (ProtectRecord)retval.createProtect();
        records.add(retval.protect);
        retval.password = (PasswordRecord)retval.createPassword();
        records.add(retval.password);
        records.add(retval.createEOF());
        retval.records = records;
        if (log.check(1)) {
            log.log(1, "Sheet createsheet from scratch exit");
        }
        return retval;
    }

    public static Sheet createSheet(List records, int sheetnum) {
        if (log.check(1)) {
            log.log(1, "Sheet createSheet (exisiting file) assumed offset 0");
        }
        return Sheet.createSheet(records, sheetnum, 0);
    }

    public static Sheet createSheet(List recs, int sheetnum, int offset) {
        if (log.check(1)) {
            log.logFormatted(1, "Sheet createSheet (existing file) with %", new Integer(recs.size()));
        }
        Sheet retval = new Sheet();
        ArrayList<Record> records = new ArrayList<Record>(recs.size() / 5);
        boolean isfirstcell = true;
        boolean isfirstrow = true;
        int bofEofNestingLevel = 0;
        int k = offset;
        while (k < recs.size()) {
            Record rec = (Record)recs.get(k);
            if (rec.getSid() == 516) {
                if (log.check(1)) {
                    log.log(1, "Hit label record.");
                }
                retval.containsLabels = true;
            } else if (rec.getSid() == 2057) {
                ++bofEofNestingLevel;
                if (log.check(1)) {
                    log.log(1, "Hit BOF record. Nesting increased to " + bofEofNestingLevel);
                }
            } else if (rec.getSid() == 10) {
                --bofEofNestingLevel;
                if (log.check(1)) {
                    log.log(1, "Hit EOF record. Nesting decreased to " + bofEofNestingLevel);
                }
                if (bofEofNestingLevel == 0) {
                    records.add(rec);
                    retval.eofLoc = k;
                    break;
                }
            } else if (rec.getSid() == 512) {
                if (retval.columns == null) {
                    retval.columns = new ColumnInfoRecordsAggregate();
                    records.add(retval.columns);
                }
                retval.dims = (DimensionsRecord)rec;
                retval.dimsloc = records.size();
            } else if (rec.getSid() == 229) {
                retval.mergedRecords.add(rec);
                retval.merged = (MergeCellsRecord)rec;
                retval.numMergedRegions += retval.merged.getNumAreas();
            } else if (rec.getSid() == 125) {
                ColumnInfoRecord col = (ColumnInfoRecord)rec;
                if (retval.columns != null) {
                    rec = null;
                } else {
                    retval.columns = new ColumnInfoRecordsAggregate();
                    rec = retval.columns;
                }
                retval.columns.insertColumn(col);
            } else if (rec.getSid() == 85) {
                retval.defaultcolwidth = (DefaultColWidthRecord)rec;
            } else if (rec.getSid() == 549) {
                retval.defaultrowheight = (DefaultRowHeightRecord)rec;
            } else if (rec.isValue() && bofEofNestingLevel == 1) {
                if (isfirstcell) {
                    retval.cells = new ValueRecordsAggregate();
                    rec = retval.cells;
                    retval.cells.construct(k, recs);
                    isfirstcell = false;
                } else {
                    rec = null;
                }
            } else if (rec.getSid() == 519) {
                rec = null;
            } else if (rec.getSid() == 520) {
                RowRecord row = (RowRecord)rec;
                if (!isfirstrow) {
                    rec = null;
                }
                if (isfirstrow) {
                    retval.rows = new RowRecordsAggregate();
                    rec = retval.rows;
                    isfirstrow = false;
                }
                retval.rows.insertRow(row);
            } else if (rec.getSid() == 43) {
                retval.printGridlines = (PrintGridlinesRecord)rec;
            } else if (rec.getSid() == 20 && bofEofNestingLevel == 1) {
                retval.header = (HeaderRecord)rec;
            } else if (rec.getSid() == 21 && bofEofNestingLevel == 1) {
                retval.footer = (FooterRecord)rec;
            } else if (rec.getSid() == 161 && bofEofNestingLevel == 1) {
                retval.printSetup = (PrintSetupRecord)rec;
            } else if (rec.getSid() == 38) {
                retval.getMargins()[0] = (LeftMarginRecord)rec;
            } else if (rec.getSid() == 39) {
                retval.getMargins()[1] = (RightMarginRecord)rec;
            } else if (rec.getSid() == 40) {
                retval.getMargins()[2] = (TopMarginRecord)rec;
            } else if (rec.getSid() == 41) {
                retval.getMargins()[3] = (BottomMarginRecord)rec;
            } else if (rec.getSid() == 29) {
                retval.selection = (SelectionRecord)rec;
            } else if (rec.getSid() == 574) {
                retval.windowTwo = (WindowTwoRecord)rec;
            } else if (rec.getSid() == 18) {
                retval.protect = (ProtectRecord)rec;
            } else if (rec.getSid() == 27) {
                retval.rowBreaks = (PageBreakRecord)rec;
            } else if (rec.getSid() == 26) {
                retval.colBreaks = (PageBreakRecord)rec;
            } else if (rec.getSid() == 19) {
                retval.password = (PasswordRecord)rec;
            }
            if (rec != null) {
                records.add(rec);
            }
            ++k;
        }
        retval.records = records;
        retval.checkCells();
        retval.checkRows();
        if (log.check(1)) {
            log.log(1, "sheet createSheet (existing file) exited");
        }
        return retval;
    }

    public void createSplitPane(int xSplitPos, int ySplitPos, int topRow, int leftmostColumn, int activePane) {
        int loc = this.findFirstRecordLocBySid((short)574);
        PaneRecord r = new PaneRecord();
        r.setX((short)xSplitPos);
        r.setY((short)ySplitPos);
        r.setTopRow((short)topRow);
        r.setLeftColumn((short)leftmostColumn);
        r.setActivePane((short)activePane);
        this.records.add(loc + 1, r);
        this.windowTwo.setFreezePanes(false);
        this.windowTwo.setFreezePanesNoSplit(false);
        SelectionRecord sel = (SelectionRecord)this.findFirstRecordBySid((short)29);
        sel.setPane((byte)0);
    }

    protected Record createVCenter() {
        VCenterRecord retval = new VCenterRecord();
        retval.setVCenter(false);
        return retval;
    }

    protected Record createWSBool() {
        WSBoolRecord retval = new WSBoolRecord();
        retval.setWSBool1((byte)4);
        retval.setWSBool2((byte)-63);
        return retval;
    }

    protected WindowTwoRecord createWindowTwo() {
        WindowTwoRecord retval = new WindowTwoRecord();
        retval.setOptions((short)1718);
        retval.setTopRow((short)0);
        retval.setLeftCol((short)0);
        retval.setHeaderColor(64);
        retval.setPageBreakZoom((short)0);
        retval.setNormalZoom((short)0);
        return retval;
    }

    public Record findFirstRecordBySid(short sid) {
        Iterator iterator = this.records.iterator();
        while (iterator.hasNext()) {
            Record record = (Record)iterator.next();
            if (record.getSid() != sid) continue;
            return record;
        }
        return null;
    }

    public int findFirstRecordLocBySid(short sid) {
        int index = 0;
        Iterator iterator = this.records.iterator();
        while (iterator.hasNext()) {
            Record record = (Record)iterator.next();
            if (record.getSid() == sid) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public short getActiveCellCol() {
        if (this.selection == null) {
            return 0;
        }
        return this.selection.getActiveCellCol();
    }

    public int getActiveCellRow() {
        if (this.selection == null) {
            return 0;
        }
        return this.selection.getActiveCellRow();
    }

    public Iterator getColumnBreaks() {
        return this.colBreaks.getBreaksIterator();
    }

    public short getColumnWidth(short column) {
        short retval = 0;
        ColumnInfoRecord ci = null;
        if (this.columns != null) {
            Iterator iterator = this.columns.getIterator();
            while (iterator.hasNext()) {
                ci = (ColumnInfoRecord)iterator.next();
                if (ci.getFirstColumn() <= column && column <= ci.getLastColumn()) break;
                ci = null;
            }
        }
        retval = ci != null ? ci.getColumnWidth() : this.defaultcolwidth.getColWidth();
        return retval;
    }

    public short getDefaultColumnWidth() {
        return this.defaultcolwidth.getColWidth();
    }

    public short getDefaultRowHeight() {
        return this.defaultrowheight.getRowHeight();
    }

    public int getDimsLoc() {
        if (log.check(1)) {
            log.log(1, "getDimsLoc dimsloc= " + this.dimsloc);
        }
        return this.dimsloc;
    }

    public int getEofLoc() {
        return this.eofLoc;
    }

    public FooterRecord getFooter() {
        return this.footer;
    }

    public GridsetRecord getGridsetRecord() {
        return this.gridset;
    }

    public HeaderRecord getHeader() {
        return this.header;
    }

    public int getLoc() {
        if (log.check(1)) {
            log.log(1, "sheet.getLoc():" + this.loc);
        }
        return this.loc;
    }

    public double getMargin(short margin) {
        if (this.getMargins()[margin] != null) {
            return this.margins[margin].getMargin();
        }
        switch (margin) {
            case 0: {
                return 0.75;
            }
            case 1: {
                return 0.75;
            }
            case 2: {
                return 1.0;
            }
            case 3: {
                return 1.0;
            }
        }
        throw new RuntimeException("Unknown margin constant:  " + margin);
    }

    protected Margin[] getMargins() {
        if (this.margins == null) {
            this.margins = new Margin[4];
        }
        return this.margins;
    }

    public MergeCellsRecord.MergedRegion getMergedRegionAt(int index) {
        if (index >= this.numMergedRegions || this.mergedRecords.size() == 0) {
            return null;
        }
        int pos = 0;
        int startNumRegions = 0;
        if (this.numMergedRegions - index < this.merged.getNumAreas()) {
            pos = this.mergedRecords.size() - 1;
            startNumRegions = this.numMergedRegions - this.merged.getNumAreas();
        } else {
            int n = 0;
            while (n < this.mergedRecords.size()) {
                MergeCellsRecord record = (MergeCellsRecord)this.mergedRecords.get(n);
                if (startNumRegions + record.getNumAreas() > index) {
                    pos = n;
                    break;
                }
                startNumRegions += record.getNumAreas();
                ++n;
            }
        }
        return ((MergeCellsRecord)this.mergedRecords.get(pos)).getAreaAt(index - startNumRegions);
    }

    public RowRecord getNextRow() {
        if (log.check(1)) {
            log.log(1, "getNextRow loc= " + this.loc);
        }
        if (this.rowRecIterator == null) {
            this.rowRecIterator = this.rows.getIterator();
        }
        if (!this.rowRecIterator.hasNext()) {
            return null;
        }
        return (RowRecord)this.rowRecIterator.next();
    }

    public CellValueRecordInterface getNextValueRecord() {
        if (log.check(1)) {
            log.log(1, "getNextValue loc= " + this.loc);
        }
        if (this.valueRecIterator == null) {
            this.valueRecIterator = this.cells.getIterator();
        }
        if (!this.valueRecIterator.hasNext()) {
            return null;
        }
        return (CellValueRecordInterface)this.valueRecIterator.next();
    }

    public int getNumColumnBreaks() {
        return this.colBreaks.getNumBreaks();
    }

    public int getNumMergedRegions() {
        return this.numMergedRegions;
    }

    public int getNumRecords() {
        this.checkCells();
        this.checkRows();
        if (log.check(1)) {
            log.log(1, "Sheet.getNumRecords");
            log.logFormatted(1, "returning % + % + % - 2 = %", new int[]{this.records.size(), this.cells.getPhysicalNumberOfCells(), this.rows.getPhysicalNumberOfRows(), this.records.size() + this.cells.getPhysicalNumberOfCells() + this.rows.getPhysicalNumberOfRows() - 2});
        }
        return this.records.size() + this.cells.getPhysicalNumberOfCells() + this.rows.getPhysicalNumberOfRows() - 2;
    }

    public int getNumRowBreaks() {
        return this.rowBreaks.getNumBreaks();
    }

    public PasswordRecord getPassword() {
        return this.password;
    }

    public int getPreOffset() {
        return this.preoffset;
    }

    public PrintGridlinesRecord getPrintGridlines() {
        return this.printGridlines;
    }

    public PrintSetupRecord getPrintSetup() {
        return this.printSetup;
    }

    public ProtectRecord getProtect() {
        return this.protect;
    }

    public List getRecords() {
        return this.records;
    }

    public RowRecord getRow(int rownum) {
        if (log.check(1)) {
            log.log(1, "getNextRow loc= " + this.loc);
        }
        return this.rows.getRow(rownum);
    }

    public Iterator getRowBreaks() {
        return this.rowBreaks.getBreaksIterator();
    }

    public SelectionRecord getSelection() {
        return this.selection;
    }

    public int getSize() {
        int retval = 0;
        int k = 0;
        while (k < this.records.size()) {
            retval += ((Record)this.records.get(k)).getRecordSize();
            ++k;
        }
        return retval;
    }

    public void groupColumnRange(short fromColumn, short toColumn, boolean indent) {
        this.columns.groupColumnRange(fromColumn, toColumn, indent);
        int maxLevel = 0;
        Iterator iterator = this.columns.getIterator();
        while (iterator.hasNext()) {
            ColumnInfoRecord columnInfoRecord = (ColumnInfoRecord)iterator.next();
            maxLevel = Math.max(columnInfoRecord.getOutlineLevel(), maxLevel);
        }
        GutsRecord guts = (GutsRecord)this.findFirstRecordBySid((short)128);
        guts.setColLevelMax((short)(maxLevel + 1));
        if (maxLevel == 0) {
            guts.setTopColGutter((short)0);
        } else {
            guts.setTopColGutter((short)(29 + 12 * (maxLevel - 1)));
        }
    }

    public void groupRowRange(int fromRow, int toRow, boolean indent) {
        this.checkRows();
        int rowNum = fromRow;
        while (rowNum <= toRow) {
            RowRecord row = this.getRow(rowNum);
            if (row == null) {
                row = this.createRow(rowNum);
                this.addRow(row);
            }
            int level = row.getOutlineLevel();
            level = indent ? ++level : --level;
            level = Math.max(0, level);
            level = Math.min(7, level);
            row.setOutlineLevel((short)level);
            ++rowNum;
        }
        this.recalcRowGutter();
    }

    public boolean isColumnBroken(short column) {
        return this.colBreaks.getBreak(column) != null;
    }

    public boolean isDisplayFormulas() {
        return this.windowTwo.getDisplayFormulas();
    }

    public boolean isDisplayGridlines() {
        return this.windowTwo.getDisplayGridlines();
    }

    public boolean isDisplayRowColHeadings() {
        return this.windowTwo.getDisplayRowColHeadings();
    }

    public boolean isGridsPrinted() {
        return !this.gridset.getGridset();
    }

    public boolean isRowBroken(int row) {
        return this.rowBreaks.getBreak((short)row) != null;
    }

    public void preSerialize() {
        Iterator iterator = this.getRecords().iterator();
        while (iterator.hasNext()) {
            Record r = (Record)iterator.next();
            if (!(r instanceof EscherAggregate)) continue;
            r.getRecordSize();
        }
    }

    private void recalcRowGutter() {
        int maxLevel = 0;
        Iterator iterator = this.rows.getIterator();
        while (iterator.hasNext()) {
            RowRecord rowRecord = (RowRecord)iterator.next();
            maxLevel = Math.max(rowRecord.getOutlineLevel(), maxLevel);
        }
        GutsRecord guts = (GutsRecord)this.findFirstRecordBySid((short)128);
        guts.setRowLevelMax((short)(maxLevel + 1));
        guts.setLeftRowGutter((short)(29 + 12 * maxLevel));
    }

    public void removeColumnBreak(short column) {
        this.colBreaks.removeBreak(column);
    }

    public void removeMergedRegion(int index) {
        if (index >= this.numMergedRegions || this.mergedRecords.size() == 0) {
            return;
        }
        int pos = 0;
        int startNumRegions = 0;
        if (this.numMergedRegions - index < this.merged.getNumAreas()) {
            pos = this.mergedRecords.size() - 1;
            startNumRegions = this.numMergedRegions - this.merged.getNumAreas();
        } else {
            int n = 0;
            while (n < this.mergedRecords.size()) {
                MergeCellsRecord record = (MergeCellsRecord)this.mergedRecords.get(n);
                if (startNumRegions + record.getNumAreas() > index) {
                    pos = n;
                    break;
                }
                startNumRegions += record.getNumAreas();
                ++n;
            }
        }
        MergeCellsRecord rec = (MergeCellsRecord)this.mergedRecords.get(pos);
        rec.removeAreaAt(index - startNumRegions);
        --this.numMergedRegions;
        if (rec.getNumAreas() == 0) {
            this.mergedRecords.remove(pos);
            this.records.remove(this.merged);
            if (this.merged == rec) {
                this.merged = this.mergedRecords.size() > 0 ? (MergeCellsRecord)this.mergedRecords.get(this.mergedRecords.size() - 1) : null;
            }
        }
    }

    public void removeRow(RowRecord row) {
        this.checkRows();
        this.setLoc(this.getDimsLoc());
        this.rows.removeRow(row);
    }

    public void removeRowBreak(int row) {
        this.rowBreaks.removeBreak((short)row);
    }

    public void removeValueRecord(int row, CellValueRecordInterface col) {
        this.checkCells();
        log.logFormatted(1, "remove value record row,dimsloc %,%", new int[]{row, this.dimsloc});
        this.loc = this.dimsloc;
        this.cells.removeCell(col);
    }

    public void replaceValueRecord(CellValueRecordInterface newval) {
        this.checkCells();
        this.setLoc(this.dimsloc);
        if (log.check(1)) {
            log.log(1, "replaceValueRecord ");
        }
        this.cells.insertCell(newval);
    }

    public int serialize(int offset, byte[] data) {
        if (log.check(1)) {
            log.log(1, "Sheet.serialize using offsets");
        }
        int pos = 0;
        int k = 0;
        while (k < this.records.size()) {
            Record record = (Record)this.records.get(k);
            pos += record.serialize(pos + offset, data);
            ++k;
        }
        if (log.check(1)) {
            log.log(1, "Sheet.serialize returning ");
        }
        return pos;
    }

    public byte[] serialize() {
        if (log.check(1)) {
            log.log(1, "Sheet.serialize");
        }
        byte[] retval = null;
        int arraysize = this.getSize();
        int pos = 0;
        retval = new byte[arraysize];
        int k = 0;
        while (k < this.records.size()) {
            pos += ((Record)this.records.get(k)).serialize(pos, retval);
            ++k;
        }
        if (log.check(1)) {
            log.log(1, "Sheet.serialize returning " + retval);
        }
        return retval;
    }

    public void setActiveCellCol(short col) {
        if (this.selection != null) {
            this.selection.setActiveCellCol(col);
        }
    }

    public void setActiveCellRow(int row) {
        if (this.selection != null) {
            this.selection.setActiveCellRow(row);
        }
    }

    public void setColumn(short column, Short width, Integer level, Boolean hidden, Boolean collapsed) {
        if (this.columns == null) {
            this.columns = new ColumnInfoRecordsAggregate();
        }
        this.columns.setColumn(column, width, level, hidden, collapsed);
    }

    public void setColumnBreak(short column, short fromRow, short toRow) {
        this.colBreaks.addBreak(column, fromRow, toRow);
    }

    public void setColumnGroupCollapsed(short columnNumber, boolean collapsed) {
        if (collapsed) {
            this.columns.collapseColumn(columnNumber);
        } else {
            this.columns.expandColumn(columnNumber);
        }
    }

    public void setColumnWidth(short column, short width) {
        this.setColumn(column, new Short(width), null, null, null);
    }

    public void setDefaultColumnWidth(short dcw) {
        this.defaultcolwidth.setColWidth(dcw);
    }

    public void setDefaultRowHeight(short dch) {
        this.defaultrowheight.setRowHeight(dch);
    }

    public void setDimensions(int firstrow, short firstcol, int lastrow, short lastcol) {
        if (log.check(1)) {
            log.log(1, "Sheet.setDimensions");
            log.log(1, "firstrow" + firstrow + "firstcol" + firstcol + "lastrow" + lastrow + "lastcol" + lastcol);
        }
        this.dims.setFirstCol(firstcol);
        this.dims.setFirstRow(firstrow);
        this.dims.setLastCol(lastcol);
        this.dims.setLastRow(lastrow);
        if (log.check(1)) {
            log.log(1, "Sheet.setDimensions exiting");
        }
    }

    public void setDisplayFormulas(boolean show) {
        this.windowTwo.setDisplayFormulas(show);
    }

    public void setDisplayGridlines(boolean show) {
        this.windowTwo.setDisplayGridlines(show);
    }

    public void setDisplayRowColHeadings(boolean show) {
        this.windowTwo.setDisplayRowColHeadings(show);
    }

    public void setFooter(FooterRecord newFooter) {
        this.footer = newFooter;
    }

    public void setGridsPrinted(boolean value) {
        this.gridset.setGridset(!value);
    }

    public void setHeader(HeaderRecord newHeader) {
        this.header = newHeader;
    }

    public void setLoc(int loc) {
        this.valueRecIterator = null;
        if (log.check(1)) {
            log.log(1, "sheet.setLoc(): " + loc);
        }
        this.loc = loc;
    }

    public void setMargin(short margin, double size) {
        Margin m = this.getMargins()[margin];
        if (m == null) {
            switch (margin) {
                case 0: {
                    m = new LeftMarginRecord();
                    this.records.add(this.getDimsLoc() + 1, m);
                    break;
                }
                case 1: {
                    m = new RightMarginRecord();
                    this.records.add(this.getDimsLoc() + 1, m);
                    break;
                }
                case 2: {
                    m = new TopMarginRecord();
                    this.records.add(this.getDimsLoc() + 1, m);
                    break;
                }
                case 3: {
                    m = new BottomMarginRecord();
                    this.records.add(this.getDimsLoc() + 1, m);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown margin constant:  " + margin);
                }
            }
            this.margins[margin] = m;
        }
        m.setMargin(size);
    }

    public void setPassword(String pwdString) {
        if (pwdString == null) {
            return;
        }
        this.password.setPassword(pwdString);
    }

    public void setPreOffset(int offset) {
        this.preoffset = offset;
    }

    public void setPrintGridlines(PrintGridlinesRecord newPrintGridlines) {
        this.printGridlines = newPrintGridlines;
    }

    public void setPrintSetup(PrintSetupRecord newPrintSetup) {
        this.printSetup = newPrintSetup;
    }

    public void setRowBreak(int row, short fromCol, short toCol) {
        this.rowBreaks.addBreak((short)row, fromCol, toCol);
    }

    public void setRowGroupCollapsed(int row, boolean collapse) {
        if (collapse) {
            this.rows.collapseRow(row);
        } else {
            this.rows.expandRow(row);
        }
    }

    public void setSCLRecord(SCLRecord sclRecord) {
        int oldRecordLoc = this.findFirstRecordLocBySid((short)160);
        if (oldRecordLoc == -1) {
            int windowRecordLoc = this.findFirstRecordLocBySid((short)574);
            this.records.add(windowRecordLoc + 1, sclRecord);
        } else {
            this.records.set(oldRecordLoc, sclRecord);
        }
    }

    public void setSelected(boolean sel) {
        this.windowTwo.setSelected(sel);
    }

    public void setSelection(SelectionRecord selection) {
        this.selection = selection;
    }

    public void shiftBreaks(PageBreakRecord breaks, short start, short stop, int count) {
        PageBreakRecord.Break breakItem;
        if (this.rowBreaks == null) {
            return;
        }
        Iterator iterator = breaks.getBreaksIterator();
        ArrayList<PageBreakRecord.Break> shiftedBreak = new ArrayList<PageBreakRecord.Break>();
        while (iterator.hasNext()) {
            boolean inEnd;
            breakItem = (PageBreakRecord.Break)iterator.next();
            short breakLocation = breakItem.main;
            boolean inStart = breakLocation >= start;
            boolean bl = inEnd = breakLocation <= stop;
            if (!inStart || !inEnd) continue;
            shiftedBreak.add(breakItem);
        }
        iterator = shiftedBreak.iterator();
        while (iterator.hasNext()) {
            breakItem = (PageBreakRecord.Break)iterator.next();
            breaks.removeBreak(breakItem.main);
            breaks.addBreak((short)(breakItem.main + count), breakItem.subFrom, breakItem.subTo);
        }
    }

    public void shiftColumnBreaks(short startingCol, short endingCol, short count) {
        this.shiftBreaks(this.colBreaks, startingCol, endingCol, count);
    }

    public void shiftRowBreaks(int startingRow, int endingRow, int count) {
        this.shiftBreaks(this.rowBreaks, (short)startingRow, (short)endingRow, (short)count);
    }
}

