/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.dev;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.hssf.dev.EFHSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RowRecord;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class EFHSSF {
    HSSFSheet cursheet = null;
    String infile;
    String outfile;
    HSSFWorkbook workbook = null;

    public static void main(String[] args) {
        if (args.length < 2 || !args[0].equals("--help")) {
            try {
                EFHSSF viewer = new EFHSSF();
                viewer.setInputFile(args[0]);
                viewer.setOutputFile(args[1]);
                viewer.run();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("EFHSSF");
            System.out.println("General testbed for HSSFEventFactory based testing and Code examples");
            System.out.println("Usage: java org.apache.poi.hssf.dev.EFHSSF file1 file2");
            System.out.println("   --will rewrite the file reading with the event api");
            System.out.println("and writing with the standard API");
        }
    }

    public void recordHandler(Record record) {
        HSSFRow row = null;
        HSSFCell cell = null;
        int sheetnum = -1;
        switch (record.getSid()) {
            case 2057: {
                BOFRecord bof = (BOFRecord)record;
                if (bof.getType() == 5) {
                    this.workbook = new HSSFWorkbook();
                    break;
                }
                if (bof.getType() != 16) break;
                this.cursheet = this.workbook.getSheetAt(++sheetnum);
                break;
            }
            case 133: {
                BoundSheetRecord bsr = (BoundSheetRecord)record;
                this.workbook.createSheet(bsr.getSheetname());
                break;
            }
            case 520: {
                RowRecord rowrec = (RowRecord)record;
                this.cursheet.createRow(rowrec.getRowNumber());
                break;
            }
            case 515: {
                NumberRecord numrec = (NumberRecord)record;
                row = this.cursheet.getRow(numrec.getRow());
                cell = row.createCell(numrec.getColumn(), 0);
                cell.setCellValue(numrec.getValue());
                break;
            }
            case 252: {
                SSTRecord sstrec = (SSTRecord)record;
                int k = 0;
                while (k < sstrec.getNumUniqueStrings()) {
                    this.workbook.addSSTString(sstrec.getString(k));
                    ++k;
                }
                break;
            }
            case 253: {
                LabelSSTRecord lrec = (LabelSSTRecord)record;
                row = this.cursheet.getRow(lrec.getRow());
                cell = row.createCell(lrec.getColumn(), 1);
                cell.setCellValue(this.workbook.getSSTString(lrec.getSSTIndex()));
            }
        }
    }

    public void run() throws IOException {
        FileInputStream fin = new FileInputStream(this.infile);
        POIFSFileSystem poifs = new POIFSFileSystem(fin);
        DocumentInputStream din = poifs.createDocumentInputStream("Workbook");
        HSSFRequest req = new HSSFRequest();
        req.addListenerForAllRecords(new EFHSSFListener(this));
        HSSFEventFactory factory = new HSSFEventFactory();
        factory.processEvents(req, din);
        fin.close();
        ((InputStream)din).close();
        FileOutputStream fout = new FileOutputStream(this.outfile);
        this.workbook.write(fout);
        fout.close();
        System.out.println("done.");
    }

    public void setInputFile(String infile) {
        this.infile = infile;
    }

    public void setOutputFile(String outfile) {
        this.outfile = outfile;
    }
}

