/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import java.util.Map;
import org.apache.poi.hpsf.ClassID;
import org.apache.poi.hpsf.HPSFRuntimeException;
import org.apache.poi.hpsf.Property;
import org.apache.poi.hpsf.wellknown.SectionIDMap;
import org.apache.poi.util.LittleEndian;

public class Section {
    protected Map dictionary;
    protected ClassID formatID;
    protected long offset;
    protected Property[] properties;
    protected int propertyCount;
    protected int size;
    private boolean wasNull;

    public Section(byte[] src, int offset) {
        this.formatID = new ClassID(src, offset);
        this.offset = LittleEndian.getUInt(src, offset += 16);
        offset = (int)this.offset;
        this.size = (int)LittleEndian.getUInt(src, offset);
        this.propertyCount = (int)LittleEndian.getUInt(src, offset += 4);
        this.properties = new Property[this.propertyCount];
        int codepage = -1;
        int pass1Offset = offset += 4;
        int i = 0;
        while (i < this.properties.length) {
            int id = (int)LittleEndian.getUInt(src, pass1Offset);
            int sOffset = (int)LittleEndian.getUInt(src, pass1Offset += 4);
            int length = i == this.properties.length - 1 ? (int)((long)src.length - this.offset - (long)sOffset) : (int)LittleEndian.getUInt(src, (pass1Offset += 4) + 4) - sOffset;
            if (id == 1) {
                int o = (int)(this.offset + (long)sOffset);
                long type = LittleEndian.getUInt(src, o);
                o += 4;
                if (type != 2L) {
                    throw new HPSFRuntimeException("Value type of property ID 1 is not VT_I2 but " + type + ".");
                }
                codepage = LittleEndian.getUShort(src, o);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.properties.length) {
            int id = (int)LittleEndian.getUInt(src, offset);
            int sOffset = (int)LittleEndian.getUInt(src, offset += 4);
            int length = i2 == this.properties.length - 1 ? (int)((long)src.length - this.offset - (long)sOffset) : (int)LittleEndian.getUInt(src, (offset += 4) + 4) - sOffset;
            this.properties[i2] = new Property(id, src, this.offset + (long)sOffset, length, codepage);
            ++i2;
        }
        this.dictionary = (Map)this.getProperty(0);
    }

    protected Section() {
    }

    public ClassID getFormatID() {
        return this.formatID;
    }

    public long getOffset() {
        return this.offset;
    }

    public String getPIDString(int pid) {
        String s = null;
        if (this.dictionary != null) {
            s = (String)this.dictionary.get(new Integer(pid));
        }
        if (s == null) {
            s = SectionIDMap.getPIDString(this.getFormatID().getBytes(), pid);
        }
        if (s == null) {
            s = "[undefined]";
        }
        return s;
    }

    public Property[] getProperties() {
        return this.properties;
    }

    public Object getProperty(int id) {
        this.wasNull = false;
        int i = 0;
        while (i < this.properties.length) {
            if (id == this.properties[i].getID()) {
                return this.properties[i].getValue();
            }
            ++i;
        }
        this.wasNull = true;
        return null;
    }

    protected boolean getPropertyBooleanValue(int id) {
        Boolean b = (Boolean)this.getProperty(id);
        if (b != null) {
            return b;
        }
        return false;
    }

    public int getPropertyCount() {
        return this.propertyCount;
    }

    protected int getPropertyIntValue(int id) {
        Long i = (Long)this.getProperty(id);
        if (i != null) {
            return i.intValue();
        }
        return 0;
    }

    public int getSize() {
        return this.size;
    }

    public boolean wasNull() {
        return this.wasNull;
    }
}

