/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import org.apache.poi.util.HexDump;

public class ClassID {
    public static final int LENGTH = 16;
    protected byte[] bytes;

    public ClassID() {
        this.bytes = new byte[16];
        int i = 0;
        while (i < 16) {
            this.bytes[i] = 0;
            ++i;
        }
    }

    public ClassID(byte[] src, int offset) {
        this.read(src, offset);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ClassID)) {
            return false;
        }
        ClassID cid = (ClassID)o;
        if (this.bytes.length != cid.bytes.length) {
            return false;
        }
        int i = 0;
        while (i < this.bytes.length) {
            if (this.bytes[i] != cid.bytes[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int length() {
        return 16;
    }

    public byte[] read(byte[] src, int offset) {
        this.bytes = new byte[16];
        this.bytes[0] = src[3 + offset];
        this.bytes[1] = src[2 + offset];
        this.bytes[2] = src[1 + offset];
        this.bytes[3] = src[0 + offset];
        this.bytes[4] = src[5 + offset];
        this.bytes[5] = src[4 + offset];
        this.bytes[6] = src[7 + offset];
        this.bytes[7] = src[6 + offset];
        int i = 8;
        while (i < 16) {
            this.bytes[i] = src[i + offset];
            ++i;
        }
        return this.bytes;
    }

    public String toString() {
        StringBuffer sbClassId = new StringBuffer(38);
        sbClassId.append('{');
        int i = 0;
        while (i < 16) {
            sbClassId.append(HexDump.toHex(this.bytes[i]));
            if (i == 3 || i == 5 || i == 7 || i == 9) {
                sbClassId.append('-');
            }
            ++i;
        }
        sbClassId.append('}');
        return sbClassId.toString();
    }

    public void write(byte[] dst, int offset) throws ArrayStoreException {
        if (dst.length < 16) {
            throw new ArrayStoreException("Destination byte[] must have room for at least 16 bytes, but has a length of only " + dst.length + ".");
        }
        dst[0 + offset] = this.bytes[3];
        dst[1 + offset] = this.bytes[2];
        dst[2 + offset] = this.bytes[1];
        dst[3 + offset] = this.bytes[0];
        dst[4 + offset] = this.bytes[5];
        dst[5 + offset] = this.bytes[4];
        dst[6 + offset] = this.bytes[7];
        dst[7 + offset] = this.bytes[6];
        int i = 8;
        while (i < 16) {
            dst[i + offset] = this.bytes[i];
            ++i;
        }
    }
}

