/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ddf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ddf.EscherProperty;
import org.apache.poi.ddf.EscherPropertyFactory;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherRecordFactory;
import org.apache.poi.ddf.EscherSerializationListener;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class EscherOptRecord
extends EscherRecord {
    public static final String RECORD_DESCRIPTION = "msofbtOPT";
    public static final short RECORD_ID = -4085;
    private List properties = new ArrayList();

    public void addEscherProperty(EscherProperty prop) {
        this.properties.add(prop);
    }

    public int fillFields(byte[] data, int offset, EscherRecordFactory recordFactory) {
        int bytesRemaining = this.readHeader(data, offset);
        int pos = offset + 8;
        EscherPropertyFactory f = new EscherPropertyFactory();
        this.properties = f.createProperties(data, pos, this.getInstance());
        return bytesRemaining + 8;
    }

    public List getEscherProperties() {
        return this.properties;
    }

    public EscherProperty getEscherProperty(int index) {
        return (EscherProperty)this.properties.get(index);
    }

    public short getOptions() {
        this.setOptions((short)(this.properties.size() << 4 | 3));
        return super.getOptions();
    }

    private int getPropertiesSize() {
        int totalSize = 0;
        Iterator iterator = this.properties.iterator();
        while (iterator.hasNext()) {
            EscherProperty escherProperty = (EscherProperty)iterator.next();
            totalSize += escherProperty.getPropertySize();
        }
        return totalSize;
    }

    public String getRecordName() {
        return "Opt";
    }

    public int getRecordSize() {
        return 8 + this.getPropertiesSize();
    }

    public int serialize(int offset, byte[] data, EscherSerializationListener listener) {
        listener.beforeRecordSerialize(offset, this.getRecordId(), this);
        LittleEndian.putShort(data, offset, this.getOptions());
        LittleEndian.putShort(data, offset + 2, this.getRecordId());
        LittleEndian.putInt(data, offset + 4, this.getPropertiesSize());
        int pos = offset + 8;
        Iterator iterator = this.properties.iterator();
        while (iterator.hasNext()) {
            EscherProperty escherProperty = (EscherProperty)iterator.next();
            pos += escherProperty.serializeSimplePart(data, pos);
        }
        Iterator iterator2 = this.properties.iterator();
        while (iterator2.hasNext()) {
            EscherProperty escherProperty = (EscherProperty)iterator2.next();
            pos += escherProperty.serializeComplexPart(data, pos);
        }
        listener.afterRecordSerialize(pos, this.getRecordId(), pos - offset, this);
        return pos - offset;
    }

    public void sortProperties() {
        Collections.sort(this.properties, new Comparator(){

            public int compare(Object o1, Object o2) {
                EscherProperty p1 = (EscherProperty)o1;
                EscherProperty p2 = (EscherProperty)o2;
                return new Short(p1.getPropertyNumber()).compareTo(new Short(p2.getPropertyNumber()));
            }
        });
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuffer propertiesBuf = new StringBuffer();
        Iterator iterator = this.properties.iterator();
        while (iterator.hasNext()) {
            propertiesBuf.append("    " + iterator.next().toString() + nl);
        }
        return "org.apache.poi.ddf.EscherOptRecord:" + nl + "  isContainer: " + this.isContainerRecord() + nl + "  options: 0x" + HexDump.toHex(this.getOptions()) + nl + "  recordId: 0x" + HexDump.toHex(this.getRecordId()) + nl + "  numchildren: " + this.getChildRecords().size() + nl + "  properties:" + nl + propertiesBuf.toString();
    }
}

