/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ddf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherRecordFactory;
import org.apache.poi.ddf.EscherSerializationListener;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class EscherBlipRecord
extends EscherRecord {
    private static final int HEADER_SIZE = 8;
    public static final String RECORD_DESCRIPTION = "msofbtBlip";
    public static final short RECORD_ID_END = -3817;
    public static final short RECORD_ID_START = -4072;
    private byte field_10_compressionFlag;
    private byte field_11_filter;
    private byte[] field_12_data;
    private byte[] field_1_secondaryUID;
    private int field_2_cacheOfSize;
    private int field_3_boundaryTop;
    private int field_4_boundaryLeft;
    private int field_5_boundaryWidth;
    private int field_6_boundaryHeight;
    private int field_7_width;
    private int field_8_height;
    private int field_9_cacheOfSavedSize;

    public static byte[] compress(byte[] data) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(out);
        try {
            int i = 0;
            while (i < data.length) {
                deflaterOutputStream.write(data[i]);
                ++i;
            }
        }
        catch (IOException e) {
            throw new RecordFormatException(e.toString());
        }
        return out.toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] decompress(byte[] data, int pos, int length) {
        byte[] compressedData = new byte[length];
        System.arraycopy(data, pos + 50, compressedData, 0, length);
        ByteArrayInputStream compressedInputStream = new ByteArrayInputStream(compressedData);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(compressedInputStream);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int c;
            while ((c = inflaterInputStream.read()) != -1) {
                void var7_7;
                out.write((int)var7_7);
            }
        }
        catch (IOException e) {
            throw new RecordFormatException(e.toString());
        }
        return out.toByteArray();
    }

    public int fillFields(byte[] data, int offset, EscherRecordFactory recordFactory) {
        int bytesAfterHeader = this.readHeader(data, offset);
        int pos = offset + 8;
        int size = 0;
        this.field_1_secondaryUID = new byte[16];
        System.arraycopy(data, pos + size, this.field_1_secondaryUID, 0, 16);
        this.field_2_cacheOfSize = LittleEndian.getInt(data, pos + (size += 16));
        this.field_3_boundaryTop = LittleEndian.getInt(data, pos + (size += 4));
        this.field_4_boundaryLeft = LittleEndian.getInt(data, pos + (size += 4));
        this.field_5_boundaryWidth = LittleEndian.getInt(data, pos + (size += 4));
        this.field_6_boundaryHeight = LittleEndian.getInt(data, pos + (size += 4));
        this.field_7_width = LittleEndian.getInt(data, pos + (size += 4));
        this.field_8_height = LittleEndian.getInt(data, pos + (size += 4));
        this.field_9_cacheOfSavedSize = LittleEndian.getInt(data, pos + (size += 4));
        this.field_10_compressionFlag = data[pos + (size += 4)];
        this.field_11_filter = data[pos + ++size];
        int bytesRemaining = bytesAfterHeader - ++size;
        this.field_12_data = new byte[bytesRemaining];
        System.arraycopy(data, pos + size, this.field_12_data, 0, bytesRemaining);
        return bytesRemaining + 8 + bytesAfterHeader;
    }

    public int getBoundaryHeight() {
        return this.field_6_boundaryHeight;
    }

    public int getBoundaryLeft() {
        return this.field_4_boundaryLeft;
    }

    public int getBoundaryTop() {
        return this.field_3_boundaryTop;
    }

    public int getBoundaryWidth() {
        return this.field_5_boundaryWidth;
    }

    public int getCacheOfSavedSize() {
        return this.field_9_cacheOfSavedSize;
    }

    public int getCacheOfSize() {
        return this.field_2_cacheOfSize;
    }

    public byte getCompressionFlag() {
        return this.field_10_compressionFlag;
    }

    public byte[] getData() {
        return this.field_12_data;
    }

    public byte getFilter() {
        return this.field_11_filter;
    }

    public int getHeight() {
        return this.field_8_height;
    }

    public String getRecordName() {
        return "Blip";
    }

    public int getRecordSize() {
        return 58 + this.field_12_data.length;
    }

    public byte[] getSecondaryUID() {
        return this.field_1_secondaryUID;
    }

    public int getWidth() {
        return this.field_7_width;
    }

    public int serialize(int offset, byte[] data, EscherSerializationListener listener) {
        listener.beforeRecordSerialize(offset, this.getRecordId(), this);
        LittleEndian.putShort(data, offset, this.getOptions());
        LittleEndian.putShort(data, offset + 2, this.getRecordId());
        int remainingBytes = this.field_12_data.length + 36;
        LittleEndian.putInt(data, offset + 4, remainingBytes);
        int pos = offset + 8;
        System.arraycopy(this.field_1_secondaryUID, 0, data, pos, 16);
        LittleEndian.putInt(data, pos += 16, this.field_2_cacheOfSize);
        LittleEndian.putInt(data, pos += 4, this.field_3_boundaryTop);
        LittleEndian.putInt(data, pos += 4, this.field_4_boundaryLeft);
        LittleEndian.putInt(data, pos += 4, this.field_5_boundaryWidth);
        LittleEndian.putInt(data, pos += 4, this.field_6_boundaryHeight);
        LittleEndian.putInt(data, pos += 4, this.field_7_width);
        LittleEndian.putInt(data, pos += 4, this.field_8_height);
        LittleEndian.putInt(data, pos += 4, this.field_9_cacheOfSavedSize);
        pos += 4;
        data[pos++] = this.field_10_compressionFlag;
        data[pos++] = this.field_11_filter;
        System.arraycopy(this.field_12_data, 0, data, pos, this.field_12_data.length);
        listener.afterRecordSerialize(pos += this.field_12_data.length, this.getRecordId(), pos - offset, this);
        return pos - offset;
    }

    public void setBoundaryHeight(int field_6_boundaryHeight) {
        this.field_6_boundaryHeight = field_6_boundaryHeight;
    }

    public void setBoundaryLeft(int field_4_boundaryLeft) {
        this.field_4_boundaryLeft = field_4_boundaryLeft;
    }

    public void setBoundaryTop(int field_3_boundaryTop) {
        this.field_3_boundaryTop = field_3_boundaryTop;
    }

    public void setBoundaryWidth(int field_5_boundaryWidth) {
        this.field_5_boundaryWidth = field_5_boundaryWidth;
    }

    public void setCacheOfSavedSize(int field_9_cacheOfSavedSize) {
        this.field_9_cacheOfSavedSize = field_9_cacheOfSavedSize;
    }

    public void setCacheOfSize(int field_2_cacheOfSize) {
        this.field_2_cacheOfSize = field_2_cacheOfSize;
    }

    public void setCompressionFlag(byte field_10_compressionFlag) {
        this.field_10_compressionFlag = field_10_compressionFlag;
    }

    public void setData(byte[] field_12_data) {
        this.field_12_data = field_12_data;
    }

    public void setFilter(byte field_11_filter) {
        this.field_11_filter = field_11_filter;
    }

    public void setHeight(int height) {
        this.field_8_height = height;
    }

    public void setSecondaryUID(byte[] field_1_secondaryUID) {
        this.field_1_secondaryUID = field_1_secondaryUID;
    }

    public void setWidth(int width) {
        this.field_7_width = width;
    }

    public String toString() {
        String extraData;
        String nl = System.getProperty("line.separator");
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        try {
            HexDump.dump(this.field_12_data, 0L, b, 0);
            extraData = b.toString();
        }
        catch (Exception e) {
            extraData = e.toString();
        }
        return this.getClass().getName() + ":" + nl + "  RecordId: 0x" + HexDump.toHex(this.getRecordId()) + nl + "  Options: 0x" + HexDump.toHex(this.getOptions()) + nl + "  Secondary UID: " + HexDump.toHex(this.field_1_secondaryUID) + nl + "  CacheOfSize: " + this.field_2_cacheOfSize + nl + "  BoundaryTop: " + this.field_3_boundaryTop + nl + "  BoundaryLeft: " + this.field_4_boundaryLeft + nl + "  BoundaryWidth: " + this.field_5_boundaryWidth + nl + "  BoundaryHeight: " + this.field_6_boundaryHeight + nl + "  X: " + this.field_7_width + nl + "  Y: " + this.field_8_height + nl + "  CacheOfSavedSize: " + this.field_9_cacheOfSavedSize + nl + "  CompressionFlag: " + this.field_10_compressionFlag + nl + "  Filter: " + this.field_11_filter + nl + "  Data:" + nl + extraData;
    }
}

