/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.processing;

import com.supermap.data.CompressedTextureType;
import com.supermap.data.DatasetVector;
import com.supermap.data.EncodeType;
import com.supermap.data.Environment;
import com.supermap.data.PrjCoordSysType;
import com.supermap.data.Recordset;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.processing.InternalEnum;
import com.supermap.data.processing.InternalHandle;
import com.supermap.data.processing.InternalHandleDisposable;
import com.supermap.data.processing.InternalProcessingEnum;
import com.supermap.data.processing.InternalProcessingToolkit;
import com.supermap.data.processing.InternalResource;
import com.supermap.data.processing.InternalToolkitProcessing;
import com.supermap.data.processing.StorageType;
import com.supermap.data.processing.VectorCacheBuilderNative;
import com.supermap.data.processing.VectorCacheTileType;
import java.io.File;
import java.util.Vector;

public class VectorCacheBuilder
extends InternalHandleDisposable {
    private Recordset _$6;
    private DatasetVector _$5;
    private long _$4;
    private Vector _$3;
    private String _$2;
    private static String _$1;

    private VectorCacheBuilder(Recordset recordset, DatasetVector datasetVector, String string, String string2) {
        long l = 0L;
        long l2 = 0L;
        if (recordset != null && (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset)) == 0L) {
            String string3 = InternalResource.loadString("recordset", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string3);
        }
        if (datasetVector != null && (l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector)) == 0L) {
            String string4 = InternalResource.loadString("dataset", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string4);
        }
        File file = new File(string);
        if (!file.exists()) {
            String string5 = InternalResource.loadString("outputFolder", InternalResource.CacheBuilderSCI3DOutputFolderNotExists, "processing_resources") + " " + string;
            throw new IllegalStateException(string5);
        }
        if (string2 == null || string2.length() == 0) {
            String string6 = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "processing_resources");
            throw new IllegalArgumentException(string6);
        }
        long l3 = VectorCacheBuilderNative.jni_New(l, l2, string, string2);
        this.setHandle(l3, true);
        this._$4 = VectorCacheBuilderNative.jni_NewSelfEventHandle(this);
        this._$5 = datasetVector;
        this._$6 = recordset;
    }

    public VectorCacheBuilder() {
        long l = VectorCacheBuilderNative.jni_New();
        this.setHandle(l, true);
        this._$4 = VectorCacheBuilderNative.jni_NewSelfEventHandle(this);
    }

    public VectorCacheBuilder(Recordset recordset, String string) {
        this(recordset, null, string, recordset.getDataset().getName());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)recordset);
    }

    public VectorCacheBuilder(Recordset recordset, String string, String string2) {
        this(recordset, null, string, string2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)recordset);
    }

    public VectorCacheBuilder(DatasetVector datasetVector, String string, String string2) {
        this(null, datasetVector, string, string2);
    }

    public Recordset getRecordset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRecordset()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return this._$6;
    }

    public void setRecordset(Recordset recordset) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRecordset(Recordset value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        long l = 0L;
        if (recordset != null && (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset)) == 0L) {
            String string = InternalResource.loadString("value", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        this._$6 = recordset;
        VectorCacheBuilderNative.jni_setRecordset(this.getHandle(), l);
        this._$5 = null;
        InternalHandleDisposable.makeSureNativeObjectLive((Object)recordset);
    }

    public DatasetVector getDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDataset()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return this._$5;
    }

    public void setDataset(DatasetVector datasetVector) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDataset(DatasetVector value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        long l = 0L;
        if (datasetVector != null && (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector)) == 0L) {
            String string = InternalResource.loadString("value", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        this._$5 = datasetVector;
        VectorCacheBuilderNative.jni_setDataset(this.getHandle(), l);
        this._$6 = null;
    }

    public String[] getFieldNames() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFieldNames()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        String string = VectorCacheBuilderNative.jni_GetFieldNames(this.getHandle());
        return InternalProcessingToolkit.splitString(string, ";");
    }

    public void setFieldNames(String[] stringArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFieldNames(String[] value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        String string = "";
        if (stringArray == null) {
            VectorCacheBuilderNative.jni_SetFieldNames(this.getHandle(), null);
            return;
        }
        string = InternalProcessingToolkit.joinString(stringArray, ";");
        VectorCacheBuilderNative.jni_SetFieldNames(this.getHandle(), string);
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBounds()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        Rectangle2D rectangle2D = new Rectangle2D();
        double[] dArray = new double[4];
        VectorCacheBuilderNative.jni_GetBounds(this.getHandle(), dArray);
        rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public void setBounds(Rectangle2D rectangle2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBoudns(Rectangle2D value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (rectangle2D == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[]{rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop()};
        VectorCacheBuilderNative.jni_SetBounds(this.getHandle(), dArray);
    }

    public String getCacheName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCacheName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return VectorCacheBuilderNative.jni_GetCacheName(this.getHandle());
    }

    public void setCacheName(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setCacheName(String value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("setCacheName()", "Global_StringIsNullOrEmpty", "processing_resources");
            throw new IllegalArgumentException(string3);
        }
        VectorCacheBuilderNative.jni_SetCacheName(this.getHandle(), string);
    }

    public String getOutputFolder() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutputFolder()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return VectorCacheBuilderNative.jni_GetOutputFolder(this.getHandle());
    }

    public void setOutputFolder(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setOutputFolder(String value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string2);
        }
        VectorCacheBuilderNative.jni_SetOutputFolder(this.getHandle(), string);
    }

    public StorageType getStorageType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStorageType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = VectorCacheBuilderNative.jni_GetStorageType(this.getHandle());
        return (StorageType)InternalProcessingEnum.parseUGCValue(StorageType.class, n);
    }

    public void setStorageType(StorageType storageType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStorageType(StorageType value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        VectorCacheBuilderNative.jni_SetStorageType(this.getHandle(), InternalProcessingEnum.getUGCValue(storageType));
    }

    @Deprecated
    public int getLevel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLevel()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return VectorCacheBuilderNative.jni_GetLevel(this.getHandle());
    }

    @Deprecated
    public void setLevel(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLevel(int value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        VectorCacheBuilderNative.jni_SetLevel(this.getHandle(), n);
    }

    @Deprecated
    public int getUpdateSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getUpdateSize()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return VectorCacheBuilderNative.jni_GetUpdateSize(this.getHandle());
    }

    @Deprecated
    public void setUpdateSize(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setUpdateSize(int value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        VectorCacheBuilderNative.jni_SetUpdateSize(this.getHandle(), n);
    }

    public String getPassword() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPassword()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return this._$2;
    }

    public void setPassword(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setPassword(int value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string2);
        }
        this._$2 = string;
    }

    public boolean build() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("build(String password)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this._$5 == null && this._$6 == null) {
            String string = InternalResource.loadString("build()", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this._$2 == null || this._$2.trim().length() == 0) {
            return VectorCacheBuilderNative.jni_Build(this.getHandle(), this._$4);
        }
        boolean bl = false;
        bl = VectorCacheBuilderNative.jni_BuildWithPassword(this.getHandle(), this._$4, this._$2);
        this.getHandle();
        return bl;
    }

    public boolean buildWithoutConfigFile() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("build(String password)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this._$5 == null && this._$6 == null) {
            String string = InternalResource.loadString("build()", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        bl = VectorCacheBuilderNative.jni_BuildWithoutConfigFile(this.getHandle(), this._$4, this._$2);
        this.getHandle();
        return bl;
    }

    @Deprecated
    public boolean buildTexture(String string, int n) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("buildTexture(String texPath, int level)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string2);
        }
        if (this._$5 == null && this._$6 == null) {
            String string3 = InternalResource.loadString("buildTexture(String texPath, int level)", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string3);
        }
        boolean bl = false;
        bl = VectorCacheBuilderNative.jni_BuildTexture(this.getHandle(), string, n);
        return bl;
    }

    @Deprecated
    public String[] computeFileName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("computeFileName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        String string = VectorCacheBuilderNative.jni_ComputeFileName(this.getHandle());
        return InternalProcessingToolkit.splitString(string, ";");
    }

    @Deprecated
    public boolean computeLevel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("computeLevel()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return VectorCacheBuilderNative.jni_ComputeLevel(this.getHandle());
    }

    public boolean toConfigFile(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("toFile(String path)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string2);
        }
        return VectorCacheBuilderNative.jni_ToFile(this.getHandle(), string);
    }

    public boolean fromConfigFile(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("fromFile(String path)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string2);
        }
        return VectorCacheBuilderNative.jni_FromFile(this.getHandle(), string);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            VectorCacheBuilderNative.jni_Delete(this.getHandle());
            this.clearHandle();
            this._$1();
        }
    }

    private void _$1() {
        if (this._$4 != 0L) {
            VectorCacheBuilderNative.jni_DeleteSelfEventHandle(this._$4);
            this._$4 = 0L;
        }
    }

    static void steppedCallBack(VectorCacheBuilder vectorCacheBuilder, int n, long l, String string, String string2, long l2) {
        if (vectorCacheBuilder != null) {
            _$1 = "build";
            boolean bl = InternalToolkitProcessing.getHandleBooleanValue(l2);
            SteppedEvent steppedEvent = new SteppedEvent((Object)vectorCacheBuilder, n, l, string, string2, _$1, bl);
            vectorCacheBuilder.fireStepped(steppedEvent);
            InternalToolkitProcessing.setHandleBooleanValue(l2, steppedEvent.getCancel());
        }
    }

    protected void fireStepped(SteppedEvent steppedEvent) {
        if (this._$3 != null) {
            Vector vector = this._$3;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(steppedEvent);
            }
        }
    }

    public synchronized void addSteppedListener(SteppedListener steppedListener) {
        if (this._$3 == null) {
            this._$3 = new Vector();
        }
        if (!this._$3.contains(steppedListener)) {
            this._$3.add(steppedListener);
        }
    }

    public synchronized void removeSteppedListener(SteppedListener steppedListener) {
        if (this._$3 != null && this._$3.contains(steppedListener)) {
            this._$3.remove(steppedListener);
        }
    }

    public EncodeType getEncodeType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getEncodeType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = VectorCacheBuilderNative.jni_GetEncodeType(this.getHandle());
        return (EncodeType)InternalEnum.parseUGCValue(EncodeType.class, n);
    }

    public void setEncodeType(EncodeType encodeType) {
        if (encodeType == null) {
            String string = InternalResource.loadString("EncodeType", "CacheBuilder_CompressTypeShouldNotBeNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEncodeType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        VectorCacheBuilderNative.jni_SetEncodeType(this.getHandle(), encodeType.value());
    }

    public CompressedTextureType getCompressedTextureType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCompressedTextureType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = VectorCacheBuilderNative.jni_GetCompressedTextureType(this.getHandle());
        return (CompressedTextureType)InternalEnum.parseUGCValue(CompressedTextureType.class, n);
    }

    public void setCompressedTextureType(CompressedTextureType compressedTextureType) {
        if (compressedTextureType == null) {
            String string = InternalResource.loadString("CompressedTextureType", "CacheBuilder_CompressTypeShouldNotBeNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCompressedTextureType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        VectorCacheBuilderNative.jni_SetCompressedTextureType(this.getHandle(), compressedTextureType.value());
    }

    public VectorCacheTileType getVectorCacheTileType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVectorCacheTileType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = VectorCacheBuilderNative.jni_GetVectorCacheTileType(this.getHandle());
        return (VectorCacheTileType)InternalEnum.parseUGCValue(VectorCacheTileType.class, n);
    }

    public void setVectorCacheTileType(VectorCacheTileType vectorCacheTileType) {
        if (vectorCacheTileType == null) {
            String string = InternalResource.loadString("VectorCacheTileType", "CacheBuilder_CompressTypeShouldNotBeNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVectorCacheTileType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        VectorCacheBuilderNative.jni_SetVectorCacheTileType(this.getHandle(), vectorCacheTileType.value());
    }

    public void setOutputScale(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScale(double)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (d < Environment.getMaxEqualZeroPrecision() || d > 1.0 - Environment.getMaxEqualZeroPrecision()) {
            String string = InternalResource.loadString("setScale(double)", "ScaleRangeInvalid", "processing_resources");
            throw new IllegalStateException(string);
        }
        VectorCacheBuilderNative.jni_SetScale(this.getHandle(), d);
    }

    public double getOutputScale() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getScale(double)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return VectorCacheBuilderNative.jni_GetScale(this.getHandle());
    }

    public PrjCoordSysType getDynamicPrjCoordSysType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDynamicPrjCoordSysType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = VectorCacheBuilderNative.jni_GetVectorSplitType(this.getHandle());
        PrjCoordSysType prjCoordSysType = n == 0 ? PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE : PrjCoordSysType.PCS_NON_EARTH;
        return prjCoordSysType;
    }

    public void setDynamicPrjCoordSysType(PrjCoordSysType prjCoordSysType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDynamicPrjCoordSysType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this._$5 != null || this._$6 != null) {
            PrjCoordSysType prjCoordSysType2 = this._$5 != null ? this._$5.getPrjCoordSys().getType() : this._$6.getDataset().getPrjCoordSys().getType();
            if (prjCoordSysType2 == PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE && prjCoordSysType == PrjCoordSysType.PCS_NON_EARTH) {
                String string = InternalResource.loadString("setDynamicPrjCoordSysType()", "Global_ArgumentTypeInvalid", "processing_resources");
                throw new IllegalStateException(string);
            }
            if (prjCoordSysType2 == PrjCoordSysType.PCS_NON_EARTH && prjCoordSysType == PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE) {
                String string = InternalResource.loadString("setDynamicPrjCoordSysType()", "Global_ArgumentTypeInvalid", "processing_resources");
                throw new IllegalStateException(string);
            }
        }
        int n = prjCoordSysType == PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE ? 0 : 1;
        VectorCacheBuilderNative.jni_SetVectorSplitType(this.getHandle(), n);
    }
}

