/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelNode;
import org.springframework.expression.spel.ast.Literal;
import org.springframework.expression.spel.ast.SpelNodeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InlineList
extends SpelNodeImpl {
    TypedValue constant = null;

    public InlineList(int pos, SpelNodeImpl ... args) {
        super(pos, args);
        this.checkIfConstant();
    }

    private void checkIfConstant() {
        boolean isConstant = true;
        int c = 0;
        int max = this.getChildCount();
        while (c < max) {
            SpelNode child = this.getChild(c);
            if (!(child instanceof Literal)) {
                if (child instanceof InlineList) {
                    InlineList inlineList = (InlineList)child;
                    if (!inlineList.isConstant()) {
                        isConstant = false;
                    }
                } else {
                    isConstant = false;
                }
            }
            ++c;
        }
        if (isConstant) {
            ArrayList<Object> constantList = new ArrayList<Object>();
            int childcount = this.getChildCount();
            int c2 = 0;
            while (c2 < childcount) {
                SpelNode child = this.getChild(c2);
                if (child instanceof Literal) {
                    constantList.add(((Literal)child).getLiteralValue().getValue());
                } else if (child instanceof InlineList) {
                    constantList.add(((InlineList)child).getConstantValue());
                }
                ++c2;
            }
            this.constant = new TypedValue(Collections.unmodifiableList(constantList));
        }
    }

    @Override
    public TypedValue getValueInternal(ExpressionState expressionState) throws EvaluationException {
        if (this.constant != null) {
            return this.constant;
        }
        ArrayList<Object> returnValue = new ArrayList<Object>();
        int childcount = this.getChildCount();
        int c = 0;
        while (c < childcount) {
            returnValue.add(this.getChild(c).getValue(expressionState));
            ++c;
        }
        return new TypedValue(returnValue);
    }

    @Override
    public String toStringAST() {
        StringBuilder s = new StringBuilder();
        s.append('{');
        int count = this.getChildCount();
        int c = 0;
        while (c < count) {
            if (c > 0) {
                s.append(',');
            }
            s.append(this.getChild(c).toStringAST());
            ++c;
        }
        s.append('}');
        return s.toString();
    }

    public boolean isConstant() {
        return this.constant != null;
    }

    private List<Object> getConstantValue() {
        return (List)this.constant.getValue();
    }
}

