/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.firewall;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

class FirewalledResponse
extends HttpServletResponseWrapper {
    Pattern CR_OR_LF = Pattern.compile("\\r|\\n");

    public FirewalledResponse(HttpServletResponse response) {
        super(response);
    }

    public void sendRedirect(String location) throws IOException {
        if (this.CR_OR_LF.matcher(location).find()) {
            throw new IllegalArgumentException("Invalid characters (CR/LF) in redirect location");
        }
        super.sendRedirect(location);
    }
}

