/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.data.DatasetGrid;
import com.supermap.data.InternalHandle;
import com.supermap.realspace.InternalResource;
import com.supermap.realspace.Scene;
import com.supermap.realspace.SceneNative;
import com.supermap.realspace.TerrainLayer;
import com.supermap.realspace.TerrainLayerAddedEvent;
import com.supermap.realspace.TerrainLayerAddedListener;
import com.supermap.realspace.TerrainLayerCaptionChangedEvent;
import com.supermap.realspace.TerrainLayerCaptionChangedListener;
import com.supermap.realspace.TerrainLayerRemovedEvent;
import com.supermap.realspace.TerrainLayerRemovedListener;
import com.supermap.realspace.TerrainLayerVisibleChangedEvent;
import com.supermap.realspace.TerrainLayerVisibleChangedListener;
import com.supermap.realspace.TerrainLayersNative;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;

public class TerrainLayers
extends InternalHandle {
    private ArrayList<TerrainLayer> _$2;
    private Scene _$1;
    transient Vector m_terrainLayerAddedListeners;
    transient Vector m_terrainLayerRemovedListeners;
    transient Vector m_terrainLayerCaptionChangedListener;
    transient Vector m_terrainLayerVisibleChangedListener;

    TerrainLayers(Scene scene, long l) {
        this.setHandle(l);
        this._$1 = scene;
        this._$2 = new ArrayList();
        long[] lArray = TerrainLayersNative.jni_refleshFromUGC(l);
        for (int i = 0; i < lArray.length; ++i) {
            TerrainLayer terrainLayer = TerrainLayer.createInstance(this._$1, lArray[i]);
            this._$2.add(terrainLayer);
        }
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return this._$2.size();
    }

    public TerrainLayer get(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("get(String name)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        TerrainLayer terrainLayer = null;
        int n = -1;
        if (string != null && string.trim().length() != 0) {
            n = this.indexOf(string);
        }
        if (n != -1) {
            terrainLayer = this._$2.get(n);
        }
        return terrainLayer;
    }

    public TerrainLayer get(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get(int index)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return this._$2.get(n);
    }

    public TerrainLayer add(String string, boolean bl) {
        long l;
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("add(String file, boolean addToHead)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        File file = new File(string);
        if (!file.exists() || !string.toUpperCase().endsWith(".SCT") && !string.toUpperCase().endsWith(".SCI")) {
            String string3 = InternalResource.loadString("add(String file, boolean addToHead)", "TerrainLayers_ThePathOfFileIsInvalid", "realspace_resources");
            throw new IllegalStateException(string3);
        }
        TerrainLayer terrainLayer = null;
        if (string != null && string.trim().length() != 0 && (l = TerrainLayersNative.jni_add(InternalHandle.getHandle((InternalHandle)this._$1), string, bl)) != 0L) {
            terrainLayer = TerrainLayer.createInstance(this._$1, l);
            this._$2.add(terrainLayer);
            if (bl) {
                this.moveToTop(this._$2.size() - 1);
            }
            if (this._$1 != null) {
                SceneNative.jni_AddTerrainLayers(InternalHandle.getHandle((InternalHandle)this._$1));
                TerrainLayerAddedEvent terrainLayerAddedEvent = new TerrainLayerAddedEvent((Object)this, terrainLayer);
                this.fireTerrainLayerAdded(terrainLayerAddedEvent);
            }
        }
        return terrainLayer;
    }

    public TerrainLayer add(String string, boolean bl, String string2) {
        long l;
        if (this.getHandle() == 0L) {
            String string3 = InternalResource.loadString("add(String file, boolean addToHead)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string3);
        }
        File file = new File(string);
        if (!file.exists() || !string.toUpperCase().endsWith(".SCT") && !string.toUpperCase().endsWith(".SCI")) {
            String string4 = InternalResource.loadString("add(String file, boolean addToHead)", "TerrainLayers_ThePathOfFileIsInvalid", "realspace_resources");
            throw new IllegalStateException(string4);
        }
        if (string2 == null || string2.trim().length() == 0) {
            String string5 = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string5);
        }
        if (this.indexOf(string2) != -1) {
            String string6 = InternalResource.loadString("name", "TerrainLayers_LayerNameIsExist", "realspace_resources");
            throw new IllegalArgumentException(string6);
        }
        TerrainLayer terrainLayer = null;
        if (string != null && string.trim().length() != 0 && (l = TerrainLayersNative.jni_AddWithName(InternalHandle.getHandle((InternalHandle)this._$1), string, bl, string2)) != 0L) {
            terrainLayer = TerrainLayer.createInstance(this._$1, l);
            this._$2.add(terrainLayer);
            if (bl) {
                this.moveToTop(this._$2.size() - 1);
            }
            if (this._$1 != null) {
                SceneNative.jni_AddTerrainLayers(InternalHandle.getHandle((InternalHandle)this._$1));
                TerrainLayerAddedEvent terrainLayerAddedEvent = new TerrainLayerAddedEvent((Object)this, terrainLayer);
                this.fireTerrainLayerAdded(terrainLayerAddedEvent);
            }
        }
        return terrainLayer;
    }

    public TerrainLayer add(DatasetGrid datasetGrid, boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(DatasetGrid  dataset, boolean addToHead)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (datasetGrid == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((InternalHandle)datasetGrid);
        if (l == 0L) {
            String string = InternalResource.loadString("dataset", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        String string = datasetGrid.getName() + "@" + datasetGrid.getDatasource().getAlias();
        TerrainLayer terrainLayer = null;
        long l2 = TerrainLayersNative.jni_addDataset(InternalHandle.getHandle((InternalHandle)this._$1), string, bl);
        if (l2 != 0L) {
            terrainLayer = TerrainLayer.createInstance(this._$1, l2);
            this._$2.add(terrainLayer);
            if (bl) {
                this.moveToTop(this._$2.size() - 1);
            }
            if (this._$1 != null) {
                SceneNative.jni_AddTerrainLayers(InternalHandle.getHandle((InternalHandle)this._$1));
                TerrainLayerAddedEvent terrainLayerAddedEvent = new TerrainLayerAddedEvent((Object)this, terrainLayer);
                this.fireTerrainLayerAdded(terrainLayerAddedEvent);
            }
        }
        return terrainLayer;
    }

    public TerrainLayer add(DatasetGrid datasetGrid, boolean bl, String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("add(DatasetGrid dataset, boolean addToHead, String name)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        if (datasetGrid == null) {
            String string3 = InternalResource.loadString("dataset", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string3);
        }
        long l = InternalHandle.getHandle((InternalHandle)datasetGrid);
        if (l == 0L) {
            String string4 = InternalResource.loadString("dataset", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string4);
        }
        TerrainLayer terrainLayer = this.add(datasetGrid, bl);
        if (terrainLayer != null) {
            terrainLayer.setName(string);
        }
        return terrainLayer;
    }

    public TerrainLayer add(String string, boolean bl, String string2, String string3) {
        long l;
        if (this.getHandle() == 0L) {
            String string4 = InternalResource.loadString("add(String file, boolean addToHead)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string4);
        }
        File file = new File(string);
        if (!file.exists() || !string.toUpperCase().endsWith(".SCT") && !string.toUpperCase().endsWith(".SCI")) {
            String string5 = InternalResource.loadString("add(String file, boolean addToHead)", "TerrainLayers_ThePathOfFileIsInvalid", "realspace_resources");
            throw new IllegalStateException(string5);
        }
        if (string2 == null || string2.trim().length() == 0) {
            String string6 = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string6);
        }
        if (this.indexOf(string2) != -1) {
            String string7 = InternalResource.loadString("name", "TerrainLayers_LayerNameIsExist", "realspace_resources");
            throw new IllegalArgumentException(string7);
        }
        TerrainLayer terrainLayer = null;
        if (string != null && string.trim().length() != 0 && (l = TerrainLayersNative.jni_AddWithPassword(InternalHandle.getHandle((InternalHandle)this._$1), string, bl, string2, string3)) != 0L) {
            terrainLayer = TerrainLayer.createInstance(this._$1, l);
            this._$2.add(terrainLayer);
            if (bl) {
                this.moveToTop(this._$2.size() - 1);
            }
            if (this._$1 != null) {
                SceneNative.jni_AddTerrainLayers(InternalHandle.getHandle((InternalHandle)this._$1));
                TerrainLayerAddedEvent terrainLayerAddedEvent = new TerrainLayerAddedEvent((Object)this, terrainLayer);
                this.fireTerrainLayerAdded(terrainLayerAddedEvent);
            }
        }
        return terrainLayer;
    }

    public TerrainLayer add(String string, String string2) {
        if (this.getHandle() == 0L) {
            String string3 = InternalResource.loadString("add(String file, boolean addToHead)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null || string.trim().length() == 0) {
            String string4 = InternalResource.loadString("iserverURL", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string4);
        }
        if (string2 == null || string2.trim().length() == 0) {
            String string5 = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string5);
        }
        if (this.indexOf(string2) != -1) {
            String string6 = InternalResource.loadString("name", "TerrainLayers_LayerNameIsExist", "realspace_resources");
            throw new IllegalArgumentException(string6);
        }
        TerrainLayer terrainLayer = null;
        long l = TerrainLayersNative.jni_AddIserver(InternalHandle.getHandle((InternalHandle)this._$1), string, string2);
        if (l != 0L) {
            terrainLayer = TerrainLayer.createInstance(this._$1, l);
            this._$2.add(terrainLayer);
            this.moveToTop(this._$2.size() - 1);
            if (this._$1 != null) {
                SceneNative.jni_AddTerrainLayers(InternalHandle.getHandle((InternalHandle)this._$1));
                TerrainLayerAddedEvent terrainLayerAddedEvent = new TerrainLayerAddedEvent((Object)this, terrainLayer);
                this.fireTerrainLayerAdded(terrainLayerAddedEvent);
            }
        }
        return terrainLayer;
    }

    public boolean remove(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove(int index)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        String string = this.get(n).getName();
        boolean bl = false;
        bl = TerrainLayersNative.jni_remove(this.getHandle(), n);
        if (bl) {
            TerrainLayer terrainLayer = this._$2.get(n);
            terrainLayer.clearHandle();
            this._$2.remove(n);
            if (this._$1 != null) {
                SceneNative.jni_RemoveTerrainLayers(InternalHandle.getHandle((InternalHandle)this._$1));
                TerrainLayerRemovedEvent terrainLayerRemovedEvent = new TerrainLayerRemovedEvent((Object)this, terrainLayer, n, string);
                this.fireTerrainLayerRemoved(terrainLayerRemovedEvent);
            }
        }
        return bl;
    }

    public boolean remove(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("remove(String name)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        int n = -1;
        if (string != null && string.trim().length() != 0) {
            n = this.indexOf(string);
        }
        boolean bl = false;
        if (n != -1 && (bl = TerrainLayersNative.jni_remove(this.getHandle(), n))) {
            TerrainLayer terrainLayer = this._$2.get(n);
            terrainLayer.clearHandle();
            this._$2.remove(n);
            if (this._$1 != null) {
                SceneNative.jni_RemoveTerrainLayers(InternalHandle.getHandle((InternalHandle)this._$1));
                TerrainLayerRemovedEvent terrainLayerRemovedEvent = new TerrainLayerRemovedEvent((Object)this, terrainLayer, n, string);
                this.fireTerrainLayerRemoved(terrainLayerRemovedEvent);
            }
        }
        return bl;
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        TerrainLayersNative.jni_clear(this.getHandle());
        if (this._$2 != null) {
            int n = this._$2.size();
            for (int i = 0; i < n; ++i) {
                TerrainLayer terrainLayer = this._$2.get(i);
                terrainLayer.clearHandle();
            }
            this._$2.clear();
        }
    }

    public int indexOf(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("indexOf(String name)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        int n = -1;
        if (string != null && string.trim().length() != 0) {
            n = TerrainLayersNative.jni_indexOf(this.getHandle(), string);
        }
        return n;
    }

    public boolean contains(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("contains(String name)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        int n = -1;
        if (string != null && string.trim().length() != 0) {
            n = this.indexOf(string);
        }
        boolean bl = false;
        if (n != -1) {
            bl = true;
        }
        return bl;
    }

    public boolean moveToTop(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("moveToTop(int index)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = true;
        if (n != 0) {
            bl = this.moveTo(n, 0);
        }
        return bl;
    }

    public boolean moveToBottom(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("moveToBottom(int index)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = true;
        if (n != this.getCount() - 1) {
            bl = this.moveTo(n, this.getCount() - 1);
        }
        return bl;
    }

    public boolean moveUp(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("moveUp(int index)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = true;
        if (n != 0) {
            bl = this.moveTo(n, n - 1);
        }
        return bl;
    }

    public boolean moveDown(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("moveDown(int index)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = true;
        if (n != this.getCount() - 1) {
            bl = this.moveTo(n, n + 1);
        }
        return bl;
    }

    public boolean moveTo(int n, int n2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("moveTo(int sourceIndex, int targetIndex)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (n2 < 0 || n2 >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n3 = n2 - n;
        boolean bl = false;
        bl = n3 == 0 ? true : TerrainLayersNative.jni_moveTo(InternalHandle.getHandle((InternalHandle)this._$1), n, n3);
        if (bl) {
            TerrainLayer terrainLayer = this._$2.get(n);
            this._$2.remove(n);
            this._$2.add(n2, terrainLayer);
            if (this._$1 != null) {
                SceneNative.jni_RemoveTerrainLayers(InternalHandle.getHandle((InternalHandle)this._$1));
            }
        }
        return bl;
    }

    public synchronized void addTerrainLayerAddedListener(TerrainLayerAddedListener terrainLayerAddedListener) {
        if (this.m_terrainLayerAddedListeners == null) {
            this.m_terrainLayerAddedListeners = new Vector();
        }
        if (!this.m_terrainLayerAddedListeners.contains(terrainLayerAddedListener)) {
            this.m_terrainLayerAddedListeners.add(terrainLayerAddedListener);
        }
    }

    public synchronized void removeTerrainLayerAddedListener(TerrainLayerAddedListener terrainLayerAddedListener) {
        if (this.m_terrainLayerAddedListeners != null && this.m_terrainLayerAddedListeners.contains(terrainLayerAddedListener)) {
            this.m_terrainLayerAddedListeners.remove(terrainLayerAddedListener);
        }
    }

    protected void fireTerrainLayerAdded(TerrainLayerAddedEvent terrainLayerAddedEvent) {
        if (this.m_terrainLayerAddedListeners != null) {
            Vector vector = this.m_terrainLayerAddedListeners;
            int n = this.m_terrainLayerAddedListeners.size();
            for (int i = 0; i < n; ++i) {
                ((TerrainLayerAddedListener)vector.elementAt(i)).terrainLayerAdded(terrainLayerAddedEvent);
            }
        }
    }

    public synchronized void addTerrainLayerRemovedListener(TerrainLayerRemovedListener terrainLayerRemovedListener) {
        if (this.m_terrainLayerRemovedListeners == null) {
            this.m_terrainLayerRemovedListeners = new Vector();
        }
        if (!this.m_terrainLayerRemovedListeners.contains(terrainLayerRemovedListener)) {
            this.m_terrainLayerRemovedListeners.add(terrainLayerRemovedListener);
        }
    }

    public synchronized void removeTerrainLayerRemovedListener(TerrainLayerRemovedListener terrainLayerRemovedListener) {
        if (this.m_terrainLayerRemovedListeners != null && this.m_terrainLayerRemovedListeners.contains(terrainLayerRemovedListener)) {
            this.m_terrainLayerRemovedListeners.remove(terrainLayerRemovedListener);
        }
    }

    protected void fireTerrainLayerRemoved(TerrainLayerRemovedEvent terrainLayerRemovedEvent) {
        if (this.m_terrainLayerRemovedListeners != null) {
            Vector vector = this.m_terrainLayerRemovedListeners;
            int n = this.m_terrainLayerRemovedListeners.size();
            for (int i = 0; i < n; ++i) {
                ((TerrainLayerRemovedListener)vector.elementAt(i)).terrainLayerRemoved(terrainLayerRemovedEvent);
            }
        }
    }

    public synchronized void addTerrainLayerCaptionChangedListener(TerrainLayerCaptionChangedListener terrainLayerCaptionChangedListener) {
        if (this.m_terrainLayerCaptionChangedListener == null) {
            this.m_terrainLayerCaptionChangedListener = new Vector();
        }
        if (!this.m_terrainLayerCaptionChangedListener.contains(terrainLayerCaptionChangedListener)) {
            this.m_terrainLayerCaptionChangedListener.add(terrainLayerCaptionChangedListener);
        }
    }

    public synchronized void removeTerrainLayerCaptionChangedListener(TerrainLayerCaptionChangedListener terrainLayerCaptionChangedListener) {
        if (this.m_terrainLayerCaptionChangedListener != null && this.m_terrainLayerCaptionChangedListener.contains(terrainLayerCaptionChangedListener)) {
            this.m_terrainLayerCaptionChangedListener.remove(terrainLayerCaptionChangedListener);
        }
    }

    protected void fireCaptionChanged(TerrainLayerCaptionChangedEvent terrainLayerCaptionChangedEvent) {
        if (this.m_terrainLayerCaptionChangedListener != null) {
            Vector vector = this.m_terrainLayerCaptionChangedListener;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((TerrainLayerCaptionChangedListener)vector.elementAt(i)).captionChanged(terrainLayerCaptionChangedEvent);
            }
        }
    }

    public synchronized void addTerrainLayerVisibleChangedListener(TerrainLayerVisibleChangedListener terrainLayerVisibleChangedListener) {
        if (this.m_terrainLayerVisibleChangedListener == null) {
            this.m_terrainLayerVisibleChangedListener = new Vector();
        }
        if (!this.m_terrainLayerVisibleChangedListener.contains(terrainLayerVisibleChangedListener)) {
            this.m_terrainLayerVisibleChangedListener.add(terrainLayerVisibleChangedListener);
        }
    }

    public synchronized void removeTerrainLayerVisibleChangedListener(TerrainLayerVisibleChangedListener terrainLayerVisibleChangedListener) {
        if (this.m_terrainLayerVisibleChangedListener != null && this.m_terrainLayerVisibleChangedListener.contains(terrainLayerVisibleChangedListener)) {
            this.m_terrainLayerVisibleChangedListener.remove(terrainLayerVisibleChangedListener);
        }
    }

    protected void fireVisibleChanged(TerrainLayerVisibleChangedEvent terrainLayerVisibleChangedEvent) {
        if (this.m_terrainLayerVisibleChangedListener != null) {
            Vector vector = this.m_terrainLayerVisibleChangedListener;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((TerrainLayerVisibleChangedListener)vector.elementAt(i)).visibleChanged(terrainLayerVisibleChangedEvent);
            }
        }
    }

    protected static TerrainLayers createInstance(Scene scene, long l) {
        return new TerrainLayers(scene, l);
    }

    protected void clearHandle() {
        for (int i = 0; i < this._$2.size(); ++i) {
            this._$2.get(i).clearHandle();
        }
        this._$2 = null;
        this.setHandle(0L);
    }
}

