/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.realspace.FlyEventType;
import com.supermap.realspace.FlyManager;
import com.supermap.realspace.InternalHandle;
import com.supermap.realspace.InternalHandleDisposable;
import com.supermap.realspace.InternalResource;
import com.supermap.realspace.PropertiesChangedEvent;
import com.supermap.realspace.RouteStop;
import com.supermap.realspace.RouteStopsNative;
import java.util.ArrayList;

public class RouteStops
extends InternalHandle {
    FlyManager m_flyManager;
    ArrayList<RouteStop> m_routeStops;

    RouteStops(long l) {
        this.setHandle(l);
        this.m_routeStops = new ArrayList();
        this._$1();
    }

    private void _$1() {
        int n = this.getCount();
        for (int i = 0; i < n; ++i) {
            long l = RouteStopsNative.jni_Get(this.getHandle(), i);
            RouteStop routeStop = new RouteStop(l);
            routeStop.m_flyManager = this.m_flyManager;
            this.m_routeStops.add(routeStop);
        }
    }

    public int getStartIndex() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStartIndex", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return RouteStopsNative.jni_GetStartIndex(this.getHandle());
    }

    public void setStartIndex(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStartIndex", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("setStartIndex", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        RouteStopsNative.jni_SetStartIndex(this.getHandle(), n);
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return RouteStopsNative.jni_GetCount(this.getHandle());
    }

    public int indexOf(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("indexOf", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            String string3 = InternalResource.loadString("indexOf", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string3);
        }
        int n = -1;
        if (string != null && string.trim().length() != 0) {
            int n2 = this.getCount();
            for (int i = 0; i < n2; ++i) {
                if (!string.equalsIgnoreCase(this.get(i).getName())) continue;
                n = i;
                break;
            }
        }
        return n;
    }

    public boolean contains(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("contains", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        return this.indexOf(string) != -1;
    }

    public int add(RouteStop routeStop) {
        String string = routeStop.getName();
        if (this.contains(string)) {
            String string2 = InternalResource.loadString("add", "Route_IsAlreadyExist", "realspace_resources");
            throw new IllegalArgumentException(string2);
        }
        RouteStop routeStop2 = new RouteStop(routeStop, false);
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)routeStop2);
        int n = -1;
        if (l != 0L && (n = RouteStopsNative.jni_Add(this.getHandle(), l)) != -1) {
            this.m_routeStops.add(routeStop2);
        }
        if (this.m_flyManager != null) {
            routeStop2.m_flyManager = this.m_flyManager;
            routeStop.m_flyManager = this.m_flyManager;
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.STOP_COUNT_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)routeStop));
        return n;
    }

    public boolean insert(int n, RouteStop routeStop) {
        String string = routeStop.getName();
        if (this.contains(string)) {
            String string2 = InternalResource.loadString("insert", "Route_IsAlreadyExist", "realspace_resources");
            throw new IllegalArgumentException(string2);
        }
        boolean bl = false;
        RouteStop routeStop2 = new RouteStop(routeStop);
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)routeStop2);
        if (l != 0L && (bl = RouteStopsNative.jni_Insert(this.getHandle(), n, l))) {
            this.m_routeStops.add(n, routeStop2);
        }
        if (this.m_flyManager != null) {
            routeStop2.m_flyManager = this.m_flyManager;
            routeStop.m_flyManager = this.m_flyManager;
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.STOP_COUNT_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)routeStop2));
        return bl;
    }

    public boolean remove(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("remove", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        RouteStop routeStop = this.get(n);
        boolean bl = RouteStopsNative.jni_Remove(this.getHandle(), n);
        if (bl) {
            this.m_routeStops.remove(n);
            routeStop.clearHandle();
        }
        if (this.m_flyManager != null) {
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.STOP_COUNT_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
        return bl;
    }

    public boolean remove(String string) {
        int n = this.indexOf(string);
        return this.remove(n);
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        RouteStopsNative.jni_Clear(this.getHandle());
        if (this.m_flyManager != null) {
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.STOP_COUNT_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
    }

    public RouteStop get(String string) {
        return this.get(this.indexOf(string));
    }

    public RouteStop get(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("get", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        RouteStop routeStop = this.m_routeStops.get(n);
        routeStop.m_flyManager = this.m_flyManager;
        return routeStop;
    }

    public void set(String string, RouteStop routeStop) {
        this.set(this.indexOf(string), routeStop);
    }

    public void set(int n, RouteStop routeStop) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("set", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("set", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)routeStop);
        RouteStopsNative.jni_Set(this.getHandle(), n, l);
        this.m_routeStops.set(n, routeStop);
        if (this.m_flyManager != null) {
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.STOP_PROPERTIES_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)routeStop));
    }

    protected void finalize() throws Throwable {
        if (this.getHandle() != 0L) {
            this.clearHandle();
        }
    }

    protected void clearHandle() {
        this.setHandle(0L);
        int n = this.m_routeStops.size();
        for (int i = 0; i < n; ++i) {
            RouteStop routeStop = this.m_routeStops.get(i);
            routeStop.clearHandle();
        }
    }
}

