/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.Dataset;
import com.supermap.data.DatasetGroup;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.FieldInfo;
import com.supermap.data.FieldType;
import com.supermap.data.Workspace;
import com.supermap.mapping.InternalDataset;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.InternalToolkitMapping;
import com.supermap.mapping.Layer;
import com.supermap.mapping.LayerAddedEvent;
import com.supermap.mapping.LayerAddedListener;
import com.supermap.mapping.LayerCaptionChangedEvent;
import com.supermap.mapping.LayerCaptionChangedListener;
import com.supermap.mapping.LayerChart;
import com.supermap.mapping.LayerChartNative;
import com.supermap.mapping.LayerDrawingEvent;
import com.supermap.mapping.LayerDrawingListener;
import com.supermap.mapping.LayerDrawnEvent;
import com.supermap.mapping.LayerDrawnListener;
import com.supermap.mapping.LayerEditableChangedEvent;
import com.supermap.mapping.LayerEditableChangedListener;
import com.supermap.mapping.LayerGroup;
import com.supermap.mapping.LayerGroupAddedEvent;
import com.supermap.mapping.LayerGroupAddedListener;
import com.supermap.mapping.LayerGroupNative;
import com.supermap.mapping.LayerGroupRemovedEvent;
import com.supermap.mapping.LayerGroupRemovedListener;
import com.supermap.mapping.LayerNative;
import com.supermap.mapping.LayerRemovedEvent;
import com.supermap.mapping.LayerRemovedListener;
import com.supermap.mapping.LayerSelectableChangedEvent;
import com.supermap.mapping.LayerSelectableChangedListener;
import com.supermap.mapping.LayerSetting;
import com.supermap.mapping.LayerSnapableChangedEvent;
import com.supermap.mapping.LayerSnapableChangedListener;
import com.supermap.mapping.LayerVisibleChangedEvent;
import com.supermap.mapping.LayerVisibleChangedListener;
import com.supermap.mapping.LayersNative;
import com.supermap.mapping.Map;
import com.supermap.mapping.MapPainter;
import com.supermap.mapping.Theme;
import com.supermap.mapping.ThemeDotDensity;
import com.supermap.mapping.ThemeType;
import java.util.ArrayList;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Layers
extends InternalHandle {
    private Map _$2;
    protected ArrayList<Layer> m_layersList;
    transient Vector m_layerDrawingListeners;
    transient Vector m_layerDrawnListeners;
    transient Vector m_layerAddedListeners;
    transient Vector m_layerRemovedListeners;
    transient Vector m_layerCaptionChangedListener;
    transient Vector m_layerSelectableChangedListener;
    transient Vector m_layerEditableChangedListener;
    transient Vector m_layerVisibleChangedListener;
    transient Vector m_layerSnapableChangedListener;
    transient Vector<LayerGroupAddedListener> m_layerGroupAddedListenerList;
    transient Vector<LayerGroupRemovedListener> m_layerGroupRemovedListenerList;
    private boolean _$1 = true;
    ReentrantLock m_lock;

    protected Layers(long l, Map map, ReentrantLock reentrantLock) {
        this.setHandle(l);
        this.m_layersList = new ArrayList();
        this._$2 = map;
        this.m_lock = reentrantLock;
        int n = this.getCount();
        for (int i = 0; i < n; ++i) {
            long l2 = LayersNative.jni_GetItemByIndex(this.getHandle(), i);
            if (l2 == 0L) continue;
            boolean bl = LayerNative.jni_IsChartLayer(l2);
            boolean bl2 = LayerGroupNative.jni_IsLayerGroup(l2);
            if (bl) {
                long l3 = LayerChartNative.jni_GetDatasetGroup(l2);
                DatasetGroup datasetGroup = InternalToolkitMapping.toMangedDatasetGroup(this._$2.getWorkspace(), l3);
                LayerChart layerChart = new LayerChart(l2, this, this._$2, datasetGroup);
                this.m_layersList.add(layerChart);
                continue;
            }
            if (bl2) {
                LayerGroup layerGroup = new LayerGroup(l2, null, this, this._$2);
                this.m_layersList.add(layerGroup);
                continue;
            }
            Layer layer = new Layer(l2, this, this._$2);
            this.m_layersList.add(layer);
            layer.getDataset();
        }
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayersNative.jni_GetCount(this.getHandle());
    }

    public Layer get(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("getItem(String name)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            string = "";
        }
        int n = this.indexOf(string);
        Layer layer = null;
        if (n != -1) {
            layer = this.m_layersList.get(n);
        }
        return layer;
    }

    public Layer get(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getItem(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return this.m_layersList.get(n);
    }

    public Layer addChart(DatasetGroup datasetGroup, boolean bl) {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(Dataset dataset, boolean addToHead)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (datasetGroup == null) {
            String string = InternalResource.loadString("datasetGroup", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGroup);
        if (l2 == 0L) {
            String string = InternalResource.loadString("datasetGroup", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        Workspace workspace = datasetGroup.getDatasource().getWorkspace();
        Workspace workspace2 = this._$2.getWorkspace();
        long l3 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)workspace);
        if (l3 != (l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)workspace2))) {
            String string = InternalResource.loadString("datasetGroup", "Layers_TheWorkspaceOfDatasetGroupShouldBeTheSameAsMap", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l4 = LayersNative.jni_AddChartLayer(this.getHandle(), l2, bl);
        LayerChart layerChart = null;
        if (l4 != 0L) {
            layerChart = new LayerChart(l4, this, this._$2, datasetGroup);
            layerChart.reset();
            if (bl) {
                this.m_layersList.add(0, layerChart);
            } else {
                this.m_layersList.add(layerChart);
            }
            LayerAddedEvent layerAddedEvent = new LayerAddedEvent((Object)this, layerChart);
            this.fireLayerAdded(layerAddedEvent);
            if (this._$1) {
                this._$2.setImageSize(this._$2.getImageSize());
                this._$1 = false;
            }
        }
        return layerChart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Layer add(Dataset dataset, boolean bl) {
        Layer layer = null;
        try {
            long l;
            this.m_lock.lock();
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("add(Dataset dataset, boolean addToHead)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            if (dataset == null) {
                String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            long l2 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
            if (l2 == 0L) {
                String string = InternalResource.loadString("dataset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            if (dataset.getType().equals((Object)DatasetType.TABULAR)) {
                String string = InternalResource.loadString("dataset", "Layers_TheTypeOfDatasetCanNotBeTABULAR", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            Workspace workspace = dataset.getDatasource().getWorkspace();
            Workspace workspace2 = this._$2.getWorkspace();
            long l3 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)workspace);
            if (l3 != (l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)workspace2))) {
                String string = InternalResource.loadString("dataset", "Layers_TheWorkspaceOfDatasetShouldBeTheSameAsMap", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            long l4 = LayersNative.jni_AddLayer(this.getHandle(), l2, bl);
            if (l4 != 0L) {
                layer = new Layer(l4, this, this._$2);
                layer.reset();
                if (bl) {
                    this.m_layersList.add(0, layer);
                } else {
                    this.m_layersList.add(layer);
                }
                layer.getDataset();
                LayerAddedEvent layerAddedEvent = new LayerAddedEvent((Object)this, layer);
                this.fireLayerAdded(layerAddedEvent);
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return layer;
    }

    public Layer add(Dataset dataset, LayerSetting layerSetting, boolean bl) {
        Layer layer = this.add(dataset, bl);
        if (layerSetting != null) {
            layer.setAdditionalSetting(layerSetting);
        }
        return layer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Layer add(Dataset dataset, Theme theme, boolean bl) {
        Layer layer = null;
        try {
            Object object;
            long l;
            this.m_lock.lock();
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("add(Dataset dataset, Theme theme, boolean addToHead)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            if (dataset == null) {
                String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            long l2 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
            if (l2 == 0L) {
                String string = InternalResource.loadString("dataset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            if (dataset.getType().equals((Object)DatasetType.TABULAR)) {
                String string = InternalResource.loadString("dataset", "Layers_TheTypeOfDatasetCanNotBeTABULAR", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            Workspace workspace = dataset.getDatasource().getWorkspace();
            Workspace workspace2 = this._$2.getWorkspace();
            long l3 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)workspace);
            if (l3 != (l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)workspace2))) {
                String string = InternalResource.loadString("dataset", "Layers_TheWorkspaceOfDatasetShouldBeTheSameAsMap", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            long l4 = 0L;
            if (theme == null) {
                Layer layer2 = this.add(dataset, bl);
                return layer2;
            }
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)theme) == 0L) {
                String string = InternalResource.loadString("theme", "Layers_InvalidTheme", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            ThemeType themeType = theme.getType();
            if (!this._$1(dataset, themeType)) {
                String string = InternalResource.loadString("dataset || theme", "Layers_TheTypeOfDatasetIsNotMatchingWithTheTheme", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            if (themeType.equals((Object)ThemeType.DOTDENSITY)) {
                object = ((ThemeDotDensity)theme).getDotExpression();
                FieldInfo fieldInfo = ((DatasetVector)dataset).getFieldInfos().get((String)object);
                if (fieldInfo != null) {
                    boolean bl2;
                    FieldType fieldType = fieldInfo.getType();
                    boolean bl3 = bl2 = fieldType.equals((Object)FieldType.BYTE) || fieldType.equals((Object)FieldType.INT16) || fieldType.equals((Object)FieldType.INT32) || fieldType.equals((Object)FieldType.DOUBLE) || fieldType.equals((Object)FieldType.SINGLE);
                    if (!bl2) {
                        String string = InternalResource.loadString("", "ThemeDotDensity_OnlySupportNumberField", "mapping_resources");
                        throw new IllegalArgumentException(string);
                    }
                }
            }
            object = Theme.clone(theme);
            InternalHandleDisposable.setIsDisposable(object, false);
            long l5 = InternalHandle.getHandle((com.supermap.data.InternalHandle)object);
            if (l5 == 0L) {
                String string = InternalResource.loadString("theme", "Layers_InvalidTheme", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            l4 = LayersNative.jni_AddLayerWithTheme(this.getHandle(), l2, l5, bl);
            if (l4 != 0L) {
                layer = new Layer(l4, this, this._$2);
                layer.reset();
                if (bl) {
                    this.m_layersList.add(0, layer);
                } else {
                    this.m_layersList.add(layer);
                }
                layer.getDataset();
                LayerAddedEvent layerAddedEvent = new LayerAddedEvent((Object)this, layer);
                this.fireLayerAdded(layerAddedEvent);
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return layer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Layer insert(int n, Dataset dataset) {
        Layer layer = null;
        try {
            long l;
            this.m_lock.lock();
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("insert(int index, Dataset dataset)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            if (n < 0 || n > this.getCount()) {
                String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            if (dataset == null) {
                String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            long l2 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
            if (l2 == 0L) {
                String string = InternalResource.loadString("dataset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            if (dataset.getType().equals((Object)DatasetType.TABULAR)) {
                String string = InternalResource.loadString("dataset", "Layers_TheTypeOfDatasetCanNotBeTABULAR", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            Workspace workspace = dataset.getDatasource().getWorkspace();
            Workspace workspace2 = this._$2.getWorkspace();
            long l3 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)workspace);
            if (l3 != (l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)workspace2))) {
                String string = InternalResource.loadString("dataset", "Layers_TheWorkspaceOfDatasetShouldBeTheSameAsMap", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            long l4 = LayersNative.jni_Insert(this.getHandle(), l2, n);
            if (l4 != 0L) {
                layer = new Layer(l4, this, this._$2);
                layer.reset();
                this.m_layersList.add(n, layer);
                layer.getDataset();
                LayerAddedEvent layerAddedEvent = new LayerAddedEvent((Object)this, layer);
                this.fireLayerAdded(layerAddedEvent);
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return layer;
    }

    public Layer insert(int n, Dataset dataset, LayerSetting layerSetting) {
        Layer layer = this.insert(n, dataset);
        layer.setAdditionalSetting(layerSetting);
        return layer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Layer insert(int n, Dataset dataset, Theme theme) {
        Layer layer = null;
        try {
            Object object;
            long l;
            this.m_lock.lock();
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("insert(int index, Dataset dataset, Theme theme)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            if (n < 0 || n > this.getCount()) {
                String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            if (dataset == null) {
                String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            long l2 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
            if (l2 == 0L) {
                String string = InternalResource.loadString("dataset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            if (dataset.getType().equals((Object)DatasetType.TABULAR)) {
                String string = InternalResource.loadString("dataset", "Layers_TheTypeOfDatasetCanNotBeTABULAR", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            Workspace workspace = dataset.getDatasource().getWorkspace();
            Workspace workspace2 = this._$2.getWorkspace();
            long l3 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)workspace);
            if (l3 != (l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)workspace2))) {
                String string = InternalResource.loadString("dataset", "Layers_TheWorkspaceOfDatasetShouldBeTheSameAsMap", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            long l4 = 0L;
            if (theme == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)theme) == 0L) {
                String string = InternalResource.loadString("theme", "Layers_InvalidTheme", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            ThemeType themeType = theme.getType();
            if (!this._$1(dataset, themeType)) {
                String string = InternalResource.loadString("dataset || theme", "Layers_TheTypeOfDatasetIsNotMatchingWithTheTheme", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            if (themeType.equals((Object)ThemeType.DOTDENSITY)) {
                object = ((ThemeDotDensity)theme).getDotExpression();
                FieldInfo fieldInfo = ((DatasetVector)dataset).getFieldInfos().get((String)object);
                if (fieldInfo != null) {
                    boolean bl;
                    FieldType fieldType = fieldInfo.getType();
                    boolean bl2 = bl = fieldType.equals((Object)FieldType.BYTE) || fieldType.equals((Object)FieldType.INT16) || fieldType.equals((Object)FieldType.INT32) || fieldType.equals((Object)FieldType.DOUBLE) || fieldType.equals((Object)FieldType.SINGLE);
                    if (!bl) {
                        String string = InternalResource.loadString("", "ThemeDotDensity_OnlySupportNumberField", "mapping_resources");
                        throw new IllegalArgumentException(string);
                    }
                }
            }
            object = Theme.clone(theme);
            InternalHandleDisposable.setIsDisposable(object, false);
            long l5 = InternalHandle.getHandle((com.supermap.data.InternalHandle)object);
            if (l5 == 0L) {
                String string = InternalResource.loadString("theme", "Layers_InvalidTheme", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            l4 = LayersNative.jni_InsertWithTheme(this.getHandle(), l2, l5, n);
            if (l4 != 0L) {
                layer = new Layer(l4, this, this._$2);
                layer.reset();
                this.m_layersList.add(n, layer);
                layer.getDataset();
                LayerAddedEvent layerAddedEvent = new LayerAddedEvent((Object)this, layer);
                this.fireLayerAdded(layerAddedEvent);
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return layer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeRange(int n, int n2) {
        int n3 = 0;
        try {
            this.m_lock.lock();
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("removeRange(int startIndex, int count)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            int n4 = this.getCount();
            if (n < 0 || n >= n4) {
                String string = InternalResource.loadString("startIndex", "Global_IndexOutOfBounds", "mapping_resources");
                throw new IndexOutOfBoundsException(string);
            }
            if (n + n2 < n || n + n2 > n4) {
                String string = InternalResource.loadString("count", "Layers_TheCountIsInvalid", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            n3 = LayersNative.jni_RemoveRange(this.getHandle(), n, n2);
            for (int i = n + n3 - 1; i >= n; --i) {
                Layer layer = this.m_layersList.get(i);
                this.m_layersList.remove(i);
                layer.clearHandle();
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(int n) {
        boolean bl = false;
        try {
            this.m_lock.lock();
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("remove(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            if (n < 0 || n >= this.getCount()) {
                String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
                throw new IndexOutOfBoundsException(string);
            }
            String string = this.m_layersList.get(n).getName();
            int n2 = LayersNative.jni_RemoveByIndex(this.getHandle(), n);
            if (n2 == 1) {
                Layer layer = this.m_layersList.get(n);
                this.m_layersList.remove(n);
                bl = true;
                LayerRemovedEvent layerRemovedEvent = new LayerRemovedEvent((Object)this, layer, string, n);
                this.fireLayerRemoved(layerRemovedEvent);
                layer.clearHandle();
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String string) {
        boolean bl = false;
        try {
            int n;
            int n2;
            this.m_lock.lock();
            if (this.getHandle() == 0L) {
                String string2 = InternalResource.loadString("remove(String name)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string2);
            }
            if (string != null && (n2 = this.indexOf(string)) != -1 && (n = LayersNative.jni_RemoveByIndex(this.getHandle(), n2)) == 1) {
                Layer layer = this.m_layersList.get(n2);
                this.m_layersList.remove(n2);
                layer.clearHandle();
                bl = true;
                LayerRemovedEvent layerRemovedEvent = new LayerRemovedEvent((Object)this, layer, string, n2);
                this.fireLayerRemoved(layerRemovedEvent);
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return bl;
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        LayersNative.jni_Clear(this.getHandle());
        if (this.m_layersList != null) {
            int n = this.m_layersList.size();
            for (int i = 0; i < n; ++i) {
                Layer layer = this.m_layersList.get(i);
                layer.clearHandle();
            }
            this.m_layersList.clear();
        }
        this.m_lock.unlock();
    }

    public int indexOf(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("indexOf(String name)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        this.m_lock.lock();
        int n = -1;
        if (string != null) {
            n = LayersNative.jni_IndexOf(this.getHandle(), string);
        }
        this.m_lock.unlock();
        return n;
    }

    public boolean contains(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("contains(String name)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        boolean bl = false;
        if (string != null) {
            bl = LayersNative.jni_Contains(this.getHandle(), string);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveToTop(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("moveToTop(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = false;
        if (n == 0) {
            bl = true;
        } else {
            try {
                this.m_lock.lock();
                Layer layer = this.m_layersList.remove(n);
                this.m_layersList.add(0, layer);
                bl = LayersNative.jni_MoveToTop(this.getHandle(), n);
            }
            finally {
                this.m_lock.unlock();
            }
        }
        return bl;
    }

    public boolean moveToBottom(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("moveToBottom(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n2 = this.getCount();
        if (n < 0 || n >= n2) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = false;
        if (n == n2 - 1) {
            bl = true;
        } else {
            this.m_lock.lock();
            Layer layer = this.m_layersList.remove(n);
            this.m_layersList.add(layer);
            bl = LayersNative.jni_MoveBottom(this.getHandle(), n);
            this.m_lock.unlock();
        }
        return bl;
    }

    public boolean moveUp(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("moveUp(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = false;
        if (n == 0) {
            bl = true;
        } else {
            this.m_lock.lock();
            Layer layer = this.m_layersList.remove(n);
            this.m_layersList.add(n - 1, layer);
            bl = LayersNative.jni_MoveUp(this.getHandle(), n);
            this.m_lock.unlock();
        }
        return bl;
    }

    public boolean moveDown(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("moveDown(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n2 = this.getCount();
        if (n < 0 || n >= n2) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = false;
        if (n == n2 - 1) {
            bl = true;
        } else {
            this.m_lock.lock();
            Layer layer = this.m_layersList.remove(n + 1);
            this.m_layersList.add(n, layer);
            bl = LayersNative.jni_MoveDown(this.getHandle(), n);
            this.m_lock.unlock();
        }
        return bl;
    }

    public boolean moveTo(int n, int n2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("moveTo(int srcIndex, int desIndex)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n3 = this.getCount();
        if (n < 0 || n >= n3) {
            String string = InternalResource.loadString("srcIndex", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (n2 < 0 || n2 >= n3) {
            String string = InternalResource.loadString("desIndex", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = false;
        if (n == n2) {
            bl = true;
        } else {
            this.m_lock.lock();
            Layer layer = this.m_layersList.remove(n);
            this.m_layersList.add(n2, layer);
            bl = LayersNative.jni_MoveTo(this.getHandle(), n, n2);
            this.m_lock.unlock();
        }
        return bl;
    }

    protected static Layers createInstance(long l, Map map, ReentrantLock reentrantLock) {
        return new Layers(l, map, reentrantLock);
    }

    protected void clearHandle() {
        if (this.m_layersList != null) {
            int n = this.m_layersList.size();
            for (int i = 0; i < n; ++i) {
                Layer layer = this.m_layersList.get(i);
                layer.clearHandle();
            }
            this.m_layersList.clear();
            this.m_layersList = null;
        }
        this._$2 = null;
        this.setHandle(0L);
    }

    ArrayList<Layer> getLayersList() {
        return this.m_layersList;
    }

    @Deprecated
    public synchronized void addDrawingListener(LayerDrawingListener layerDrawingListener) {
        if (this.m_layerDrawingListeners == null) {
            this.m_layerDrawingListeners = new Vector();
        }
        if (!this.m_layerDrawingListeners.contains(layerDrawingListener)) {
            this.m_layerDrawingListeners.add(layerDrawingListener);
        }
    }

    public synchronized void addLayerDrawingListener(LayerDrawingListener layerDrawingListener) {
        if (this.m_layerDrawingListeners == null) {
            this.m_layerDrawingListeners = new Vector();
        }
        if (this.m_layerDrawingListeners.isEmpty() && (this.m_layerDrawnListeners == null || this.m_layerDrawnListeners.isEmpty())) {
            LayersNative.jni_SetEnableLayerDrawingCallback(this.getHandle(), this, true);
        }
        if (!this.m_layerDrawingListeners.contains(layerDrawingListener)) {
            this.m_layerDrawingListeners.add(layerDrawingListener);
        }
    }

    @Deprecated
    public synchronized void removeDrawingListener(LayerDrawingListener layerDrawingListener) {
        if (this.m_layerDrawingListeners != null && this.m_layerDrawingListeners.contains(layerDrawingListener)) {
            this.m_layerDrawingListeners.remove(layerDrawingListener);
        }
        if (this.m_layerDrawingListeners.isEmpty() && this.m_layerDrawnListeners.isEmpty()) {
            LayersNative.jni_SetEnableLayerDrawingCallback(this.getHandle(), this, false);
        }
    }

    public synchronized void removeLayerDrawingListener(LayerDrawingListener layerDrawingListener) {
        if (this.m_layerDrawingListeners != null && this.m_layerDrawingListeners.contains(layerDrawingListener)) {
            this.m_layerDrawingListeners.remove(layerDrawingListener);
        }
        if ((this.m_layerDrawingListeners == null || this.m_layerDrawingListeners.isEmpty()) && (this.m_layerDrawnListeners == null || this.m_layerDrawnListeners.isEmpty())) {
            LayersNative.jni_SetEnableLayerDrawingCallback(this.getHandle(), this, false);
        }
    }

    protected void fireDrawing(LayerDrawingEvent layerDrawingEvent) {
        if (this.m_layerDrawingListeners != null) {
            Vector vector = this.m_layerDrawingListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((LayerDrawingListener)vector.elementAt(i)).layerDrawing(layerDrawingEvent);
            }
        }
    }

    static void layerDrawingCallBack(Layers layers, int n, long l, long l2, long l3, String string) {
        if (layers != null) {
            Layer layer = Layers.findLayerInLayers(layers, n, string);
            if (layer == null) {
                return;
            }
            Boolean bl = InternalToolkitMapping.getHandleBooleanValue(l3);
            MapPainter mapPainter = new MapPainter(layers._$2, l2);
            long l4 = InternalHandle.getHandle((com.supermap.data.InternalHandle)layers._$2);
            LayerDrawingEvent layerDrawingEvent = new LayerDrawingEvent((Object)layers, layer, mapPainter, bl);
            layers.fireDrawing(layerDrawingEvent);
            InternalToolkitMapping.setHandleBooleanValue(l3, layerDrawingEvent.getCancel());
        }
    }

    @Deprecated
    public synchronized void addDrawnListener(LayerDrawnListener layerDrawnListener) {
        this.addLayerDrawnListener(layerDrawnListener);
    }

    public synchronized void addLayerDrawnListener(LayerDrawnListener layerDrawnListener) {
        if (this.m_layerDrawnListeners == null) {
            this.m_layerDrawnListeners = new Vector();
        }
        if ((this.m_layerDrawingListeners == null || this.m_layerDrawingListeners.isEmpty()) && this.m_layerDrawnListeners.isEmpty()) {
            LayersNative.jni_SetEnableLayerDrawnCallback(this.getHandle(), this, true);
        }
        if (!this.m_layerDrawnListeners.contains(layerDrawnListener)) {
            this.m_layerDrawnListeners.add(layerDrawnListener);
        }
    }

    @Deprecated
    public synchronized void removeDrawnListener(LayerDrawnListener layerDrawnListener) {
        this.removeLayerDrawnListener(layerDrawnListener);
    }

    public synchronized void removeLayerDrawnListener(LayerDrawnListener layerDrawnListener) {
        if (this.m_layerDrawnListeners != null && this.m_layerDrawnListeners.contains(layerDrawnListener)) {
            this.m_layerDrawnListeners.remove(layerDrawnListener);
        }
        if ((this.m_layerDrawingListeners == null || this.m_layerDrawingListeners.isEmpty()) && (this.m_layerDrawnListeners == null || this.m_layerDrawnListeners.isEmpty())) {
            LayersNative.jni_SetEnableLayerDrawnCallback(this.getHandle(), this, false);
        }
    }

    protected void fireDrawn(LayerDrawnEvent layerDrawnEvent) {
        if (this.m_layerDrawnListeners != null) {
            Vector vector = this.m_layerDrawnListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((LayerDrawnListener)vector.elementAt(i)).layerDrawn(layerDrawnEvent);
            }
        }
    }

    static Layer findLayerInLayers(Layers layers, int n, String string) {
        int n2 = string.indexOf("/");
        if (n2 < 0) {
            if (0 <= n && n < layers.getCount()) {
                return layers.get(n);
            }
            return null;
        }
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n2 + 1);
        int n3 = Layers.parseToInt(string2);
        LayerGroup layerGroup = (LayerGroup)layers.get(n3);
        if (layerGroup != null) {
            return Layers.findLayerInGroup(layerGroup, string3);
        }
        return null;
    }

    static Layer findLayerInGroup(LayerGroup layerGroup, String string) {
        int n = string.indexOf("/");
        if (n < 0) {
            int n2 = Layers.parseToInt(string);
            if (0 <= n2 && n2 < layerGroup.getCount()) {
                return layerGroup.get(n2);
            }
            return null;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        int n3 = Layers.parseToInt(string2);
        if (0 <= n3 && n3 < layerGroup.getCount()) {
            LayerGroup layerGroup2 = (LayerGroup)layerGroup.get(n3);
            if (layerGroup2 != null) {
                return Layers.findLayerInGroup(layerGroup2, string3);
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int parseToInt(String string) {
        int n = -1;
        n = Integer.parseInt(string);
        return n;
    }

    static void layerDrawnCallBack(Layers layers, int n, long l, String string) {
        if (layers != null) {
            Layer layer = Layers.findLayerInLayers(layers, n, string);
            if (layer == null) {
                return;
            }
            MapPainter mapPainter = new MapPainter(layers._$2, l);
            LayerDrawnEvent layerDrawnEvent = new LayerDrawnEvent((Object)layers, layer, mapPainter);
            layers.fireDrawn(layerDrawnEvent);
            mapPainter.copyBufferImageToUGC();
            mapPainter.realeaseGraphics();
        }
    }

    @Deprecated
    public synchronized void addAddedListener(LayerAddedListener layerAddedListener) {
        this.addLayerAddedListener(layerAddedListener);
    }

    public synchronized void addLayerAddedListener(LayerAddedListener layerAddedListener) {
        if (this.m_layerAddedListeners == null) {
            this.m_layerAddedListeners = new Vector();
        }
        if (!this.m_layerAddedListeners.contains(layerAddedListener)) {
            this.m_layerAddedListeners.add(layerAddedListener);
        }
    }

    @Deprecated
    public synchronized void removeAddedListener(LayerAddedListener layerAddedListener) {
        this.removeLayerAddedListener(layerAddedListener);
    }

    public synchronized void removeLayerAddedListener(LayerAddedListener layerAddedListener) {
        if (this.m_layerAddedListeners != null && this.m_layerAddedListeners.contains(layerAddedListener)) {
            this.m_layerAddedListeners.remove(layerAddedListener);
        }
    }

    protected void fireLayerAdded(LayerAddedEvent layerAddedEvent) {
        if (this.m_layerAddedListeners != null) {
            Vector vector = this.m_layerAddedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((LayerAddedListener)vector.elementAt(i)).layerAdded(layerAddedEvent);
            }
        }
    }

    @Deprecated
    public synchronized void addRemovedListener(LayerRemovedListener layerRemovedListener) {
        this.addLayerRemovedListener(layerRemovedListener);
    }

    public synchronized void addLayerRemovedListener(LayerRemovedListener layerRemovedListener) {
        if (this.m_layerRemovedListeners == null) {
            this.m_layerRemovedListeners = new Vector();
        }
        if (!this.m_layerRemovedListeners.contains(layerRemovedListener)) {
            this.m_layerRemovedListeners.add(layerRemovedListener);
        }
    }

    @Deprecated
    public synchronized void removeRemovedListener(LayerRemovedListener layerRemovedListener) {
        this.removeLayerRemovedListener(layerRemovedListener);
    }

    public synchronized void removeLayerRemovedListener(LayerRemovedListener layerRemovedListener) {
        if (this.m_layerRemovedListeners != null && this.m_layerRemovedListeners.contains(layerRemovedListener)) {
            this.m_layerRemovedListeners.remove(layerRemovedListener);
        }
    }

    protected void fireLayerRemoved(LayerRemovedEvent layerRemovedEvent) {
        if (this.m_layerRemovedListeners != null) {
            Vector vector = this.m_layerRemovedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((LayerRemovedListener)vector.elementAt(i)).layerRemoved(layerRemovedEvent);
            }
        }
    }

    public synchronized void addLayerCaptionChangedListener(LayerCaptionChangedListener layerCaptionChangedListener) {
        if (this.m_layerCaptionChangedListener == null) {
            this.m_layerCaptionChangedListener = new Vector();
        }
        if (!this.m_layerCaptionChangedListener.contains(layerCaptionChangedListener)) {
            this.m_layerCaptionChangedListener.add(layerCaptionChangedListener);
        }
    }

    public synchronized void removeLayerCaptionChangedListener(LayerCaptionChangedListener layerCaptionChangedListener) {
        if (this.m_layerCaptionChangedListener != null && this.m_layerCaptionChangedListener.contains(layerCaptionChangedListener)) {
            this.m_layerCaptionChangedListener.remove(layerCaptionChangedListener);
        }
    }

    protected void fireCaptionChanged(LayerCaptionChangedEvent layerCaptionChangedEvent) {
        if (this.m_layerCaptionChangedListener != null) {
            Vector vector = this.m_layerCaptionChangedListener;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((LayerCaptionChangedListener)vector.elementAt(i)).captionChanged(layerCaptionChangedEvent);
            }
        }
    }

    public synchronized void addLayerSelectableChangedListener(LayerSelectableChangedListener layerSelectableChangedListener) {
        if (this.m_layerSelectableChangedListener == null) {
            this.m_layerSelectableChangedListener = new Vector();
        }
        if (!this.m_layerSelectableChangedListener.contains(layerSelectableChangedListener)) {
            this.m_layerSelectableChangedListener.add(layerSelectableChangedListener);
        }
    }

    public synchronized void removeLayerSelectableChangedListener(LayerSelectableChangedListener layerSelectableChangedListener) {
        if (this.m_layerSelectableChangedListener != null && this.m_layerSelectableChangedListener.contains(layerSelectableChangedListener)) {
            this.m_layerSelectableChangedListener.remove(layerSelectableChangedListener);
        }
    }

    protected void fireSelectableChanged(LayerSelectableChangedEvent layerSelectableChangedEvent) {
        if (this.m_layerSelectableChangedListener != null) {
            Vector vector = this.m_layerSelectableChangedListener;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((LayerSelectableChangedListener)vector.elementAt(i)).selectableChanged(layerSelectableChangedEvent);
            }
        }
    }

    public synchronized void addLayerEditableChangedListener(LayerEditableChangedListener layerEditableChangedListener) {
        if (this.m_layerEditableChangedListener == null) {
            this.m_layerEditableChangedListener = new Vector();
        }
        if (!this.m_layerEditableChangedListener.contains(layerEditableChangedListener)) {
            this.m_layerEditableChangedListener.add(layerEditableChangedListener);
        }
    }

    public synchronized void removeLayerEditableChangedListener(LayerEditableChangedListener layerEditableChangedListener) {
        if (this.m_layerEditableChangedListener != null && this.m_layerEditableChangedListener.contains(layerEditableChangedListener)) {
            this.m_layerEditableChangedListener.remove(layerEditableChangedListener);
        }
    }

    protected void fireEditableChanged(LayerEditableChangedEvent layerEditableChangedEvent) {
        if (this.m_layerEditableChangedListener != null) {
            Vector vector = this.m_layerEditableChangedListener;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((LayerEditableChangedListener)vector.elementAt(i)).editableChanged(layerEditableChangedEvent);
            }
        }
    }

    public synchronized void addLayerVisibleChangedListener(LayerVisibleChangedListener layerVisibleChangedListener) {
        if (this.m_layerVisibleChangedListener == null) {
            this.m_layerVisibleChangedListener = new Vector();
        }
        if (!this.m_layerVisibleChangedListener.contains(layerVisibleChangedListener)) {
            this.m_layerVisibleChangedListener.add(layerVisibleChangedListener);
        }
    }

    public synchronized void removeLayerVisibleChangedListener(LayerVisibleChangedListener layerVisibleChangedListener) {
        if (this.m_layerVisibleChangedListener != null && this.m_layerVisibleChangedListener.contains(layerVisibleChangedListener)) {
            this.m_layerVisibleChangedListener.remove(layerVisibleChangedListener);
        }
    }

    protected void fireVisibleChanged(LayerVisibleChangedEvent layerVisibleChangedEvent) {
        if (this.m_layerVisibleChangedListener != null) {
            Vector vector = this.m_layerVisibleChangedListener;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((LayerVisibleChangedListener)vector.elementAt(i)).visibleChanged(layerVisibleChangedEvent);
            }
        }
    }

    public synchronized void addLayerSnapableChangedListener(LayerSnapableChangedListener layerSnapableChangedListener) {
        if (this.m_layerSnapableChangedListener == null) {
            this.m_layerSnapableChangedListener = new Vector();
        }
        if (!this.m_layerSnapableChangedListener.contains(layerSnapableChangedListener)) {
            this.m_layerSnapableChangedListener.add(layerSnapableChangedListener);
        }
    }

    public synchronized void removeLayerSnapableChangedListener(LayerSnapableChangedListener layerSnapableChangedListener) {
        if (this.m_layerSnapableChangedListener != null && this.m_layerSnapableChangedListener.contains(layerSnapableChangedListener)) {
            this.m_layerSnapableChangedListener.remove(layerSnapableChangedListener);
        }
    }

    protected void fireSnapableChanged(LayerSnapableChangedEvent layerSnapableChangedEvent) {
        if (this.m_layerSnapableChangedListener != null) {
            Vector vector = this.m_layerSnapableChangedListener;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((LayerSnapableChangedListener)vector.elementAt(i)).snapableChanged(layerSnapableChangedEvent);
            }
        }
    }

    private boolean _$1(Dataset dataset, ThemeType themeType) {
        DatasetType datasetType = dataset.getType();
        boolean bl = true;
        if (themeType.equals((Object)ThemeType.UNIQUE) || themeType.equals((Object)ThemeType.GRADUATEDSYMBOL) || themeType.equals((Object)ThemeType.RANGE) || themeType.equals((Object)ThemeType.LABEL)) {
            if (!InternalDataset.getIsVector(dataset)) {
                bl = false;
            }
        } else if (themeType.equals((Object)ThemeType.DOTDENSITY)) {
            if (!InternalDataset.getIsVector(dataset)) {
                bl = false;
            }
            if (!datasetType.equals((Object)DatasetType.REGION)) {
                bl = false;
            }
        } else if ((themeType.equals((Object)ThemeType.GRIDRANGE) || themeType.equals((Object)ThemeType.GRIDUNIQUE)) && !datasetType.equals((Object)DatasetType.GRID)) {
            bl = false;
        }
        if (datasetType.equals((Object)DatasetType.IMAGE)) {
            bl = false;
        }
        return bl;
    }

    public int removeByDataset(Dataset dataset) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeByDataset(Dataset dataset)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = 0;
        Layer layer = null;
        for (int i = this.m_layersList.size() - 1; i >= 0; --i) {
            layer = this.m_layersList.get(i);
            if (layer.getDataset() != dataset || !this.remove(i)) continue;
            ++n;
        }
        return n;
    }

    public LayerGroup addGroup(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("addGroup(String groupName)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            string = "";
        }
        return this._$1(-1, string);
    }

    public LayerGroup insertGroup(int n, String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("insertGroup(int index, String groupName)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (n < 0 || n > this.getCount()) {
            String string3 = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        if (string == null) {
            string = "";
        }
        return this._$1(n, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LayerGroup _$1(int n, String string) {
        LayerGroup layerGroup = null;
        try {
            this.m_lock.lock();
            long l = LayersNative.jni_InsertGroup(this.getHandle(), string, n);
            layerGroup = new LayerGroup(l, null, this, this._$2);
            layerGroup.setMap(this._$2);
            layerGroup.m_layers = this;
            if (n < 0 || n >= this.m_layersList.size()) {
                this.m_layersList.add(layerGroup);
                n = this.m_layersList.size();
            } else {
                this.m_layersList.add(n, layerGroup);
            }
            LayerGroupAddedEvent layerGroupAddedEvent = new LayerGroupAddedEvent((Object)this, layerGroup, null, n);
            this.fireLayerGroupAdded(layerGroupAddedEvent);
        }
        finally {
            this.m_lock.unlock();
        }
        return layerGroup;
    }

    public boolean removeGroup(LayerGroup layerGroup) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeGroup(LayerGroup group)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (layerGroup == null) {
            String string = InternalResource.loadString("group", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(layerGroup);
        if (l == 0L) {
            String string = InternalResource.loadString("group", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return this.removeLayer(layerGroup, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeLayer(Layer layer, boolean bl) {
        boolean bl2 = false;
        try {
            this.m_lock.lock();
            int n = this.m_layersList.indexOf((Object)layer);
            if (n < 0) {
                boolean bl3 = false;
                return bl3;
            }
            long l = InternalHandle.getHandle(layer);
            String string = layer.getName();
            bl2 = LayersNative.jni_Remove(this.getHandle(), l, bl);
            if (bl2) {
                this.m_layersList.remove((Object)layer);
                if (layer instanceof LayerGroup) {
                    LayerGroupRemovedEvent layerGroupRemovedEvent = new LayerGroupRemovedEvent((Object)this, (LayerGroup)layer, null, n);
                    this.fireLayerGroupRemoved(layerGroupRemovedEvent);
                } else {
                    LayerRemovedEvent layerRemovedEvent = new LayerRemovedEvent((Object)this, layer, string, n);
                    this.fireLayerRemoved(layerRemovedEvent);
                }
                if (bl) {
                    layer.clearHandle();
                }
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addLayer(int n, Layer layer) {
        boolean bl = false;
        try {
            this.m_lock.lock();
            int n2 = this.m_layersList.indexOf((Object)layer);
            if (n2 > 0) {
                if (n == n2) {
                    boolean bl2 = true;
                    return bl2;
                }
                boolean bl3 = this.moveTo(n2, n);
                return bl3;
            }
            if (layer.getParentGroup() != null) {
                layer.getParentGroup().removeLayer(layer, false);
                layer.setParentGroup(null);
            }
            long l = InternalHandle.getHandle(layer);
            bl = LayersNative.jni_AddLayerFromGroup(this.getHandle(), l, n);
            if (bl) {
                if (layer instanceof LayerGroup) {
                    LayerGroupAddedEvent layerGroupAddedEvent = new LayerGroupAddedEvent((Object)this, (LayerGroup)layer, null, n);
                    this.fireLayerGroupAdded(layerGroupAddedEvent);
                } else {
                    LayerAddedEvent layerAddedEvent = null;
                    if (n < 0 || n >= this.m_layersList.size()) {
                        this.m_layersList.add(layer);
                        layerAddedEvent = new LayerAddedEvent((Object)this, layer);
                    } else {
                        this.m_layersList.add(n, layer);
                        layerAddedEvent = new LayerAddedEvent((Object)this, layer, n);
                    }
                    this.fireLayerAdded(layerAddedEvent);
                }
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return bl;
    }

    public boolean add(Layer layer) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeGroup(LayerGroup group)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (layer == null) {
            String string = InternalResource.loadString("layer", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(layer);
        if (l == 0L) {
            String string = InternalResource.loadString("layer", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return this.addLayer(-1, layer);
    }

    public boolean insert(int n, Layer layer) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeGroup(LayerGroup group)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (layer == null) {
            String string = InternalResource.loadString("layer", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(layer);
        if (l == 0L) {
            String string = InternalResource.loadString("layer", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (n < 0 || n > this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return this.addLayer(n, layer);
    }

    public boolean remove(Layer layer) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeGroup(LayerGroup group)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (layer == null) {
            String string = InternalResource.loadString("layer", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(layer);
        if (l == 0L) {
            String string = InternalResource.loadString("layer", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return this.removeLayer(layer, true);
    }

    public synchronized void addLayerGroupAddedListener(LayerGroupAddedListener layerGroupAddedListener) {
        if (this.m_layerGroupAddedListenerList == null) {
            this.m_layerGroupAddedListenerList = new Vector();
        }
        if (!this.m_layerGroupAddedListenerList.contains(layerGroupAddedListener)) {
            this.m_layerGroupAddedListenerList.add(layerGroupAddedListener);
        }
    }

    public synchronized void removeLayerGroupAddedListener(LayerGroupAddedListener layerGroupAddedListener) {
        if (this.m_layerGroupAddedListenerList != null && this.m_layerGroupAddedListenerList.contains(layerGroupAddedListener)) {
            this.m_layerGroupAddedListenerList.remove(layerGroupAddedListener);
        }
    }

    protected void fireLayerGroupAdded(LayerGroupAddedEvent layerGroupAddedEvent) {
        if (this.m_layerGroupAddedListenerList != null) {
            Vector<LayerGroupAddedListener> vector = this.m_layerGroupAddedListenerList;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).layerGroupAdded(layerGroupAddedEvent);
            }
        }
    }

    public synchronized void addLayerGroupRemovedListener(LayerGroupRemovedListener layerGroupRemovedListener) {
        if (this.m_layerGroupRemovedListenerList == null) {
            this.m_layerGroupRemovedListenerList = new Vector();
        }
        if (!this.m_layerGroupRemovedListenerList.contains(layerGroupRemovedListener)) {
            this.m_layerGroupRemovedListenerList.add(layerGroupRemovedListener);
        }
    }

    public synchronized void removeLayerGroupRemovedListener(LayerGroupRemovedListener layerGroupRemovedListener) {
        if (this.m_layerGroupRemovedListenerList != null && this.m_layerGroupRemovedListenerList.contains(layerGroupRemovedListener)) {
            this.m_layerGroupRemovedListenerList.remove(layerGroupRemovedListener);
        }
    }

    protected void fireLayerGroupRemoved(LayerGroupRemovedEvent layerGroupRemovedEvent) {
        if (this.m_layerGroupRemovedListenerList != null) {
            Vector<LayerGroupRemovedListener> vector = this.m_layerGroupRemovedListenerList;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).layerGroupRemoved(layerGroupRemovedEvent);
            }
        }
    }
}

