/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.InternalDatasetVector;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalEnum;
import com.supermap.analyst.spatialanalyst.InternalGeometry;
import com.supermap.analyst.spatialanalyst.InternalHandle;
import com.supermap.analyst.spatialanalyst.InternalHandleDisposable;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.SurfaceAnalystNative;
import com.supermap.analyst.spatialanalyst.SurfaceExtractParameter;
import com.supermap.analyst.spatialanalyst.TerrainInterpolateType;
import com.supermap.data.CursorType;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoRegion;
import com.supermap.data.License;
import com.supermap.data.Point3Ds;
import com.supermap.data.ProductType;
import com.supermap.data.Recordset;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import java.util.ArrayList;
import java.util.Vector;

public class SurfaceAnalyst {
    private static transient Vector _$2;
    private static License _$1;

    private SurfaceAnalyst() {
    }

    public static DatasetVector extractIsoregion(SurfaceExtractParameter surfaceExtractParameter, DatasetGrid datasetGrid, Datasource datasource, String string, GeoRegion geoRegion) {
        if (surfaceExtractParameter == null) {
            String string2 = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (datasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid) == 0L) {
            String string3 = InternalResource.loadString("extractedGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            String string4 = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string4);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string5 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        long l = 0L;
        if (geoRegion != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion) != 0L) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        long l4 = 0L;
        l4 = surfaceExtractParameter.getExpectedZValues() == null ? SurfaceAnalystNative.jni_ExtractIsoRegionWithOutZ(l2, l, l3, string, surfaceExtractParameter.getInterval(), surfaceExtractParameter.getDatumValue(), surfaceExtractParameter.getSmoothness(), InternalEnum.getUGCValue(surfaceExtractParameter.getSmoothMethod()), surfaceExtractParameter.getResampleTolerance()) : SurfaceAnalystNative.jni_ExtractIsoRegionWithZ(l2, l, l3, string, surfaceExtractParameter.getExpectedZValues(), surfaceExtractParameter.getSmoothness(), InternalEnum.getUGCValue(surfaceExtractParameter.getSmoothMethod()), surfaceExtractParameter.getResampleTolerance());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoRegion);
        DatasetVector datasetVector = null;
        if (l4 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l4, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public static GeoRegion[] extractIsoregion(SurfaceExtractParameter surfaceExtractParameter, DatasetGrid datasetGrid, GeoRegion geoRegion) {
        String string;
        if (surfaceExtractParameter == null) {
            String string2 = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (datasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid) == 0L) {
            String string3 = InternalResource.loadString("extractedGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        Datasource datasource = datasetGrid.getDatasource();
        DatasetVector datasetVector = SurfaceAnalyst.extractIsoregion(surfaceExtractParameter, datasetGrid, datasource, string = datasetGrid.getDatasource().getDatasets().getAvailableDatasetName("tempDataset"), geoRegion);
        if (datasetVector == null) {
            return new GeoRegion[0];
        }
        ArrayList<GeoRegion> arrayList = new ArrayList<GeoRegion>();
        Recordset recordset = datasetVector.getRecordset(false, CursorType.STATIC);
        while (!recordset.isEOF()) {
            GeoRegion geoRegion2 = (GeoRegion)recordset.getGeometry();
            arrayList.add(geoRegion2);
            recordset.moveNext();
        }
        int n = arrayList.size();
        GeoRegion[] geoRegionArray = new GeoRegion[n];
        for (int i = 0; i < n; ++i) {
            geoRegionArray[i] = (GeoRegion)arrayList.get(i);
        }
        recordset.dispose();
        datasource.getDatasets().delete(datasetVector.getName());
        return geoRegionArray;
    }

    public static DatasetVector extractIsoline(SurfaceExtractParameter surfaceExtractParameter, DatasetGrid datasetGrid, Datasource datasource, String string) {
        return SurfaceAnalyst.extractIsoline(surfaceExtractParameter, datasetGrid, datasource, string, null);
    }

    public static DatasetVector extractIsoline(SurfaceExtractParameter surfaceExtractParameter, DatasetGrid datasetGrid, Datasource datasource, String string, GeoRegion geoRegion) {
        SurfaceAnalyst._$1();
        if (surfaceExtractParameter == null) {
            String string2 = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (datasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid) == 0L) {
            String string3 = InternalResource.loadString("extractedGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            String string4 = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string4);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string5 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        long l = 0L;
        if (geoRegion != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion) != 0L) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        long l4 = 0L;
        l4 = surfaceExtractParameter.getExpectedZValues() == null ? SurfaceAnalystNative.jni_ExtractIsoline1(l2, l, l3, string, surfaceExtractParameter.getInterval(), surfaceExtractParameter.getDatumValue(), surfaceExtractParameter.getSmoothness(), InternalEnum.getUGCValue(surfaceExtractParameter.getSmoothMethod()), surfaceExtractParameter.getResampleTolerance()) : SurfaceAnalystNative.jni_ExtractIsoline2(l2, l, l3, string, surfaceExtractParameter.getExpectedZValues(), surfaceExtractParameter.getSmoothness(), InternalEnum.getUGCValue(surfaceExtractParameter.getSmoothMethod()), surfaceExtractParameter.getResampleTolerance());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoRegion);
        DatasetVector datasetVector = null;
        if (l4 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l4, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public static DatasetVector extractIsoline(SurfaceExtractParameter surfaceExtractParameter, DatasetVector datasetVector, String string, Datasource datasource, String string2, double d, GeoRegion geoRegion) {
        if (datasetVector == null) {
            String string3 = InternalResource.loadString("extractedPoint", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        Recordset recordset = datasetVector.getRecordset(false, CursorType.STATIC);
        DatasetVector datasetVector2 = SurfaceAnalyst.extractIsoline(surfaceExtractParameter, recordset, string, datasource, string2, d, geoRegion);
        recordset.dispose();
        return datasetVector2;
    }

    public static DatasetVector extractIsoline(SurfaceExtractParameter surfaceExtractParameter, DatasetVector datasetVector, String string, TerrainInterpolateType terrainInterpolateType, Datasource datasource, String string2, double d, GeoRegion geoRegion) {
        if (datasetVector == null) {
            String string3 = InternalResource.loadString("extractedPoint", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        Recordset recordset = datasetVector.getRecordset(false, CursorType.STATIC);
        DatasetVector datasetVector2 = SurfaceAnalyst.extractIsoline(surfaceExtractParameter, recordset, string, terrainInterpolateType, datasource, string2, d, geoRegion);
        recordset.dispose();
        return datasetVector2;
    }

    public static DatasetVector extractIsoline(SurfaceExtractParameter surfaceExtractParameter, Recordset recordset, String string, Datasource datasource, String string2, double d, GeoRegion geoRegion) {
        SurfaceAnalyst._$1();
        if (surfaceExtractParameter == null) {
            String string3 = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (recordset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset) == 0L) {
            String string4 = InternalResource.loadString("extractedPointRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string4);
        }
        if (!recordset.getDataset().getType().equals((Object)DatasetType.POINT)) {
            String string5 = InternalResource.loadString("extractedPointRecordset", "SurfaceAnalystNotPointType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (recordset.getFieldInfos().indexOf(string) == -1) {
            String string6 = InternalResource.loadString("zValueFieldName", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            String string7 = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string7);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string2)) {
            String string8 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string8);
        }
        if (d <= 0.0) {
            String string9 = InternalResource.loadString("resolution", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string9);
        }
        SurfaceAnalyst._$1(d, recordset.getBounds());
        long l = 0L;
        if (geoRegion != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion) != 0L) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        long l4 = 0L;
        int n = InternalEnum.getUGCValue(TerrainInterpolateType.IDW);
        l4 = surfaceExtractParameter.getExpectedZValues() == null ? SurfaceAnalystNative.jni_ExtractIsolineByPoint1(l2, string, n, l, d, surfaceExtractParameter.getInterval(), surfaceExtractParameter.getDatumValue(), l3, string2, surfaceExtractParameter.getResampleTolerance(), surfaceExtractParameter.getSmoothness(), InternalEnum.getUGCValue(surfaceExtractParameter.getSmoothMethod())) : SurfaceAnalystNative.jni_ExtractIsolineByPoint2(l2, string, n, l, d, surfaceExtractParameter.getExpectedZValues(), l3, string2, surfaceExtractParameter.getResampleTolerance(), surfaceExtractParameter.getSmoothness(), InternalEnum.getUGCValue(surfaceExtractParameter.getSmoothMethod()));
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoRegion);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)recordset);
        DatasetVector datasetVector = null;
        if (l4 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l4, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public static DatasetVector extractIsoline(SurfaceExtractParameter surfaceExtractParameter, Recordset recordset, String string, TerrainInterpolateType terrainInterpolateType, Datasource datasource, String string2, double d, GeoRegion geoRegion) {
        SurfaceAnalyst._$1();
        if (surfaceExtractParameter == null) {
            String string3 = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (recordset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset) == 0L) {
            String string4 = InternalResource.loadString("extractedPointRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string4);
        }
        if (!recordset.getDataset().getType().equals((Object)DatasetType.POINT)) {
            String string5 = InternalResource.loadString("extractedPointRecordset", "SurfaceAnalystNotPointType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (recordset.getFieldInfos().indexOf(string) == -1) {
            String string6 = InternalResource.loadString("zValueFieldName", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            String string7 = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string7);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string2)) {
            String string8 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string8);
        }
        if (d <= 0.0) {
            String string9 = InternalResource.loadString("resolution", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string9);
        }
        SurfaceAnalyst._$1(d, recordset.getBounds());
        long l = 0L;
        if (geoRegion != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion) != 0L) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        long l4 = 0L;
        int n = InternalEnum.getUGCValue(terrainInterpolateType);
        l4 = surfaceExtractParameter.getExpectedZValues() == null ? SurfaceAnalystNative.jni_ExtractIsolineByPoint1(l2, string, n, l, d, surfaceExtractParameter.getInterval(), surfaceExtractParameter.getDatumValue(), l3, string2, surfaceExtractParameter.getResampleTolerance(), surfaceExtractParameter.getSmoothness(), InternalEnum.getUGCValue(surfaceExtractParameter.getSmoothMethod())) : SurfaceAnalystNative.jni_ExtractIsolineByPoint2(l2, string, n, l, d, surfaceExtractParameter.getExpectedZValues(), l3, string2, surfaceExtractParameter.getResampleTolerance(), surfaceExtractParameter.getSmoothness(), InternalEnum.getUGCValue(surfaceExtractParameter.getSmoothMethod()));
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoRegion);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)recordset);
        DatasetVector datasetVector = null;
        if (l4 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l4, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public static DatasetVector extractIsoline(SurfaceExtractParameter surfaceExtractParameter, Point3Ds point3Ds, Datasource datasource, String string, double d, GeoRegion geoRegion) {
        SurfaceAnalyst._$1();
        if (surfaceExtractParameter == null) {
            String string2 = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (point3Ds == null || point3Ds.getCount() == 0) {
            String string3 = InternalResource.loadString("extractedPoints", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            String string4 = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string4);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string5 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (d <= 0.0) {
            String string6 = InternalResource.loadString("resolution", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        long l = 0L;
        if (geoRegion != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion) != 0L) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        long l3 = 0L;
        int n = point3Ds.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = point3Ds.getItem(i).getX();
            dArray2[i] = point3Ds.getItem(i).getY();
            dArray3[i] = point3Ds.getItem(i).getZ();
        }
        double d2 = dArray[0];
        double d3 = dArray[0];
        double d4 = dArray2[0];
        double d5 = dArray2[0];
        for (int i = 1; i < n; ++i) {
            d2 = d2 <= dArray[i] ? d2 : dArray[i];
            d3 = d3 >= dArray[i] ? d3 : dArray[i];
            d4 = d4 <= dArray2[i] ? d4 : dArray2[i];
            d5 = d5 >= dArray2[i] ? d5 : dArray2[i];
        }
        Rectangle2D rectangle2D = new Rectangle2D(d2, d4, d3, d5);
        SurfaceAnalyst._$1(d, rectangle2D);
        int n2 = InternalEnum.getUGCValue(TerrainInterpolateType.IDW);
        l3 = surfaceExtractParameter.getExpectedZValues() == null ? SurfaceAnalystNative.jni_ExtractIsolineByPoint3D1(dArray, dArray2, dArray3, n2, l, l2, string, d, surfaceExtractParameter.getInterval(), surfaceExtractParameter.getDatumValue(), surfaceExtractParameter.getSmoothness(), InternalEnum.getUGCValue(surfaceExtractParameter.getSmoothMethod()), surfaceExtractParameter.getResampleTolerance()) : SurfaceAnalystNative.jni_ExtractIsolineByPoint3D2(dArray, dArray2, dArray3, n2, l, l2, string, d, surfaceExtractParameter.getExpectedZValues(), surfaceExtractParameter.getSmoothness(), InternalEnum.getUGCValue(surfaceExtractParameter.getSmoothMethod()), surfaceExtractParameter.getResampleTolerance());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoRegion);
        DatasetVector datasetVector = null;
        if (l3 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l3, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public static DatasetVector extractIsoline(SurfaceExtractParameter surfaceExtractParameter, Point3Ds point3Ds, TerrainInterpolateType terrainInterpolateType, Datasource datasource, String string, double d, GeoRegion geoRegion) {
        SurfaceAnalyst._$1();
        if (surfaceExtractParameter == null) {
            String string2 = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (point3Ds == null || point3Ds.getCount() == 0) {
            String string3 = InternalResource.loadString("extractedPoints", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            String string4 = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string4);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string5 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (d <= 0.0) {
            String string6 = InternalResource.loadString("resolution", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        long l = 0L;
        if (geoRegion != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion) != 0L) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        long l3 = 0L;
        int n = point3Ds.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = point3Ds.getItem(i).getX();
            dArray2[i] = point3Ds.getItem(i).getY();
            dArray3[i] = point3Ds.getItem(i).getZ();
        }
        double d2 = dArray[0];
        double d3 = dArray[0];
        double d4 = dArray2[0];
        double d5 = dArray2[0];
        for (int i = 1; i < n; ++i) {
            d2 = d2 <= dArray[i] ? d2 : dArray[i];
            d3 = d3 >= dArray[i] ? d3 : dArray[i];
            d4 = d4 <= dArray2[i] ? d4 : dArray2[i];
            d5 = d5 >= dArray2[i] ? d5 : dArray2[i];
        }
        Rectangle2D rectangle2D = new Rectangle2D(d2, d4, d3, d5);
        SurfaceAnalyst._$1(d, rectangle2D);
        int n2 = InternalEnum.getUGCValue(terrainInterpolateType);
        l3 = surfaceExtractParameter.getExpectedZValues() == null ? SurfaceAnalystNative.jni_ExtractIsolineByPoint3D1(dArray, dArray2, dArray3, n2, l, l2, string, d, surfaceExtractParameter.getInterval(), surfaceExtractParameter.getDatumValue(), surfaceExtractParameter.getSmoothness(), InternalEnum.getUGCValue(surfaceExtractParameter.getSmoothMethod()), surfaceExtractParameter.getResampleTolerance()) : SurfaceAnalystNative.jni_ExtractIsolineByPoint3D2(dArray, dArray2, dArray3, n2, l, l2, string, d, surfaceExtractParameter.getExpectedZValues(), surfaceExtractParameter.getSmoothness(), InternalEnum.getUGCValue(surfaceExtractParameter.getSmoothMethod()), surfaceExtractParameter.getResampleTolerance());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoRegion);
        DatasetVector datasetVector = null;
        if (l3 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l3, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public static DatasetVector extractIsoregion(SurfaceExtractParameter surfaceExtractParameter, Point3Ds point3Ds, Datasource datasource, String string, double d, GeoRegion geoRegion) {
        SurfaceAnalyst._$1();
        if (surfaceExtractParameter == null) {
            String string2 = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (point3Ds == null || point3Ds.getCount() == 0) {
            String string3 = InternalResource.loadString("extractedPoints", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            String string4 = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string4);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string5 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (d <= 0.0) {
            String string6 = InternalResource.loadString("resolution", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        long l = 0L;
        if (geoRegion != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion) != 0L) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        long l3 = 0L;
        int n = point3Ds.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = point3Ds.getItem(i).getX();
            dArray2[i] = point3Ds.getItem(i).getY();
            dArray3[i] = point3Ds.getItem(i).getZ();
        }
        double d2 = dArray[0];
        double d3 = dArray[0];
        double d4 = dArray2[0];
        double d5 = dArray2[0];
        for (int i = 1; i < n; ++i) {
            d2 = d2 <= dArray[i] ? d2 : dArray[i];
            d3 = d3 >= dArray[i] ? d3 : dArray[i];
            d4 = d4 <= dArray2[i] ? d4 : dArray2[i];
            d5 = d5 >= dArray2[i] ? d5 : dArray2[i];
        }
        Rectangle2D rectangle2D = new Rectangle2D(d2, d4, d3, d5);
        SurfaceAnalyst._$1(d, rectangle2D);
        int n2 = InternalEnum.getUGCValue(TerrainInterpolateType.IDW);
        l3 = surfaceExtractParameter.getExpectedZValues() == null ? SurfaceAnalystNative.jni_ExtractIsoregionByPoint3D(dArray, dArray2, dArray3, n2, l, l2, string, d, surfaceExtractParameter.getInterval(), surfaceExtractParameter.getDatumValue(), surfaceExtractParameter.getSmoothness(), InternalEnum.getUGCValue(surfaceExtractParameter.getSmoothMethod()), surfaceExtractParameter.getResampleTolerance()) : SurfaceAnalystNative.jni_ExtractIsoregionByPoint3DWithZ(dArray, dArray2, dArray3, n2, l, l2, string, d, surfaceExtractParameter.getExpectedZValues(), surfaceExtractParameter.getSmoothness(), InternalEnum.getUGCValue(surfaceExtractParameter.getSmoothMethod()), surfaceExtractParameter.getResampleTolerance());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoRegion);
        DatasetVector datasetVector = null;
        if (l3 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l3, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public static DatasetVector extractIsoregion(SurfaceExtractParameter surfaceExtractParameter, Point3Ds point3Ds, TerrainInterpolateType terrainInterpolateType, Datasource datasource, String string, double d, GeoRegion geoRegion) {
        SurfaceAnalyst._$1();
        if (surfaceExtractParameter == null) {
            String string2 = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (point3Ds == null || point3Ds.getCount() == 0) {
            String string3 = InternalResource.loadString("extractedPoints", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            String string4 = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string4);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string5 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (d <= 0.0) {
            String string6 = InternalResource.loadString("resolution", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        long l = 0L;
        if (geoRegion != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion) != 0L) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        long l3 = 0L;
        int n = point3Ds.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = point3Ds.getItem(i).getX();
            dArray2[i] = point3Ds.getItem(i).getY();
            dArray3[i] = point3Ds.getItem(i).getZ();
        }
        double d2 = dArray[0];
        double d3 = dArray[0];
        double d4 = dArray2[0];
        double d5 = dArray2[0];
        for (int i = 1; i < n; ++i) {
            d2 = d2 <= dArray[i] ? d2 : dArray[i];
            d3 = d3 >= dArray[i] ? d3 : dArray[i];
            d4 = d4 <= dArray2[i] ? d4 : dArray2[i];
            d5 = d5 >= dArray2[i] ? d5 : dArray2[i];
        }
        Rectangle2D rectangle2D = new Rectangle2D(d2, d4, d3, d5);
        SurfaceAnalyst._$1(d, rectangle2D);
        int n2 = InternalEnum.getUGCValue(terrainInterpolateType);
        l3 = surfaceExtractParameter.getExpectedZValues() == null ? SurfaceAnalystNative.jni_ExtractIsoregionByPoint3D(dArray, dArray2, dArray3, n2, l, l2, string, d, surfaceExtractParameter.getInterval(), surfaceExtractParameter.getDatumValue(), surfaceExtractParameter.getSmoothness(), InternalEnum.getUGCValue(surfaceExtractParameter.getSmoothMethod()), surfaceExtractParameter.getResampleTolerance()) : SurfaceAnalystNative.jni_ExtractIsoregionByPoint3DWithZ(dArray, dArray2, dArray3, n2, l, l2, string, d, surfaceExtractParameter.getExpectedZValues(), surfaceExtractParameter.getSmoothness(), InternalEnum.getUGCValue(surfaceExtractParameter.getSmoothMethod()), surfaceExtractParameter.getResampleTolerance());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoRegion);
        DatasetVector datasetVector = null;
        if (l3 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l3, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public static DatasetVector extractIsoregion(SurfaceExtractParameter surfaceExtractParameter, DatasetVector datasetVector, String string, Datasource datasource, String string2, double d, GeoRegion geoRegion) {
        Recordset recordset = datasetVector.getRecordset(false, CursorType.STATIC);
        DatasetVector datasetVector2 = SurfaceAnalyst.extractIsoregion(surfaceExtractParameter, recordset, string, datasource, string2, d, geoRegion);
        recordset.dispose();
        return datasetVector2;
    }

    public static DatasetVector extractIsoregion(SurfaceExtractParameter surfaceExtractParameter, DatasetVector datasetVector, String string, TerrainInterpolateType terrainInterpolateType, Datasource datasource, String string2, double d, GeoRegion geoRegion) {
        Recordset recordset = datasetVector.getRecordset(false, CursorType.STATIC);
        DatasetVector datasetVector2 = SurfaceAnalyst.extractIsoregion(surfaceExtractParameter, recordset, string, terrainInterpolateType, datasource, string2, d, geoRegion);
        recordset.dispose();
        return datasetVector2;
    }

    public static DatasetVector extractIsoregion(SurfaceExtractParameter surfaceExtractParameter, Recordset recordset, String string, Datasource datasource, String string2, double d, GeoRegion geoRegion) {
        SurfaceAnalyst._$1();
        if (surfaceExtractParameter == null) {
            String string3 = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (recordset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset) == 0L) {
            String string4 = InternalResource.loadString("extractedPointRecrodset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string4);
        }
        if (recordset.getFieldInfos().indexOf(string) == -1) {
            String string5 = InternalResource.loadString("zValueFieldName", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        DatasetVector datasetVector = recordset.getDataset();
        if (!datasetVector.getType().equals((Object)DatasetType.POINT)) {
            String string6 = InternalResource.loadString("extractedPointRecrodset", "SurfaceAnalystNotPointType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            String string7 = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string7);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string2)) {
            String string8 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string8);
        }
        if (d <= 0.0) {
            String string9 = InternalResource.loadString("resolution", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string9);
        }
        SurfaceAnalyst._$1(d, recordset.getBounds());
        long l = 0L;
        if (geoRegion != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion) != 0L) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        int n = InternalEnum.getUGCValue(TerrainInterpolateType.IDW);
        long l4 = surfaceExtractParameter.getExpectedZValues() == null ? SurfaceAnalystNative.jni_ExtractIsoregion(l2, string, n, l, d, surfaceExtractParameter.getInterval(), surfaceExtractParameter.getDatumValue(), l3, string2, surfaceExtractParameter.getResampleTolerance(), surfaceExtractParameter.getSmoothness(), InternalEnum.getUGCValue(surfaceExtractParameter.getSmoothMethod())) : SurfaceAnalystNative.jni_ExtractIsoRegionByRsWithZ(l2, string, n, l, d, surfaceExtractParameter.getExpectedZValues(), l3, string2, surfaceExtractParameter.getResampleTolerance(), surfaceExtractParameter.getSmoothness(), InternalEnum.getUGCValue(surfaceExtractParameter.getSmoothMethod()));
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoRegion);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)recordset);
        DatasetVector datasetVector2 = null;
        if (l4 != 0L) {
            datasetVector2 = InternalDatasetVector.createInstance(l4, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector2);
        }
        return datasetVector2;
    }

    public static DatasetVector extractIsoregion(SurfaceExtractParameter surfaceExtractParameter, Recordset recordset, String string, TerrainInterpolateType terrainInterpolateType, Datasource datasource, String string2, double d, GeoRegion geoRegion) {
        SurfaceAnalyst._$1();
        if (surfaceExtractParameter == null) {
            String string3 = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (recordset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset) == 0L) {
            String string4 = InternalResource.loadString("extractedPointRecrodset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string4);
        }
        if (recordset.getFieldInfos().indexOf(string) == -1) {
            String string5 = InternalResource.loadString("zValueFieldName", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        DatasetVector datasetVector = recordset.getDataset();
        if (!datasetVector.getType().equals((Object)DatasetType.POINT)) {
            String string6 = InternalResource.loadString("extractedPointRecrodset", "SurfaceAnalystNotPointType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            String string7 = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string7);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string2)) {
            String string8 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string8);
        }
        if (d <= 0.0) {
            String string9 = InternalResource.loadString("resolution", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string9);
        }
        SurfaceAnalyst._$1(d, recordset.getBounds());
        long l = 0L;
        if (geoRegion != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion) != 0L) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        int n = InternalEnum.getUGCValue(terrainInterpolateType);
        long l4 = surfaceExtractParameter.getExpectedZValues() == null ? SurfaceAnalystNative.jni_ExtractIsoregion(l2, string, n, l, d, surfaceExtractParameter.getInterval(), surfaceExtractParameter.getDatumValue(), l3, string2, surfaceExtractParameter.getResampleTolerance(), surfaceExtractParameter.getSmoothness(), InternalEnum.getUGCValue(surfaceExtractParameter.getSmoothMethod())) : SurfaceAnalystNative.jni_ExtractIsoRegionByRsWithZ(l2, string, n, l, d, surfaceExtractParameter.getExpectedZValues(), l3, string2, surfaceExtractParameter.getResampleTolerance(), surfaceExtractParameter.getSmoothness(), InternalEnum.getUGCValue(surfaceExtractParameter.getSmoothMethod()));
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoRegion);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)recordset);
        DatasetVector datasetVector2 = null;
        if (l4 != 0L) {
            datasetVector2 = InternalDatasetVector.createInstance(l4, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector2);
        }
        return datasetVector2;
    }

    public static GeoLine[] extractIsoline(SurfaceExtractParameter surfaceExtractParameter, DatasetGrid datasetGrid) {
        String string;
        SurfaceAnalyst._$1();
        if (surfaceExtractParameter == null) {
            String string2 = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (datasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid) == 0L) {
            String string3 = InternalResource.loadString("extractedGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        Datasource datasource = datasetGrid.getDatasource();
        DatasetVector datasetVector = SurfaceAnalyst.extractIsoline(surfaceExtractParameter, datasetGrid, datasource, string = datasetGrid.getDatasource().getDatasets().getAvailableDatasetName("tempDataset"));
        if (datasetVector == null) {
            return new GeoLine[0];
        }
        ArrayList<GeoLine> arrayList = new ArrayList<GeoLine>();
        Recordset recordset = datasetVector.getRecordset(false, CursorType.STATIC);
        while (!recordset.isEOF()) {
            GeoLine geoLine = (GeoLine)recordset.getGeometry();
            arrayList.add(geoLine);
            recordset.moveNext();
        }
        int n = arrayList.size();
        GeoLine[] geoLineArray = new GeoLine[n];
        for (int i = 0; i < n; ++i) {
            geoLineArray[i] = (GeoLine)arrayList.get(i);
        }
        recordset.dispose();
        datasource.getDatasets().delete(datasetVector.getName());
        return geoLineArray;
    }

    public static GeoLine[] extractIsoline(SurfaceExtractParameter surfaceExtractParameter, DatasetGrid datasetGrid, GeoRegion geoRegion) {
        String string;
        SurfaceAnalyst._$1();
        if (surfaceExtractParameter == null) {
            String string2 = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (datasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid) == 0L) {
            String string3 = InternalResource.loadString("extractedGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        Datasource datasource = datasetGrid.getDatasource();
        DatasetVector datasetVector = SurfaceAnalyst.extractIsoline(surfaceExtractParameter, datasetGrid, datasource, string = datasetGrid.getDatasource().getDatasets().getAvailableDatasetName("tempDataset"), geoRegion);
        if (datasetVector == null) {
            return new GeoLine[0];
        }
        ArrayList<GeoLine> arrayList = new ArrayList<GeoLine>();
        Recordset recordset = datasetVector.getRecordset(false, CursorType.STATIC);
        while (!recordset.isEOF()) {
            GeoLine geoLine = (GeoLine)recordset.getGeometry();
            arrayList.add(geoLine);
            recordset.moveNext();
        }
        int n = arrayList.size();
        GeoLine[] geoLineArray = new GeoLine[n];
        for (int i = 0; i < n; ++i) {
            geoLineArray[i] = (GeoLine)arrayList.get(i);
        }
        recordset.dispose();
        datasource.getDatasets().delete(datasetVector.getName());
        return geoLineArray;
    }

    public static GeoLine[] extractIsoline(SurfaceExtractParameter surfaceExtractParameter, DatasetVector datasetVector, String string, double d, GeoRegion geoRegion) {
        if (datasetVector == null) {
            String string2 = InternalResource.loadString("extractedPoint", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        Recordset recordset = datasetVector.getRecordset(false, CursorType.STATIC);
        GeoLine[] geoLineArray = SurfaceAnalyst.extractIsoline(surfaceExtractParameter, recordset, string, d, geoRegion);
        recordset.dispose();
        return geoLineArray;
    }

    public static GeoLine[] extractIsoline(SurfaceExtractParameter surfaceExtractParameter, DatasetVector datasetVector, String string, TerrainInterpolateType terrainInterpolateType, double d, GeoRegion geoRegion) {
        if (datasetVector == null) {
            String string2 = InternalResource.loadString("extractedPoint", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        Recordset recordset = datasetVector.getRecordset(false, CursorType.STATIC);
        GeoLine[] geoLineArray = SurfaceAnalyst.extractIsoline(surfaceExtractParameter, recordset, string, d, geoRegion);
        recordset.dispose();
        return geoLineArray;
    }

    public static GeoLine[] extractIsoline(SurfaceExtractParameter surfaceExtractParameter, Recordset recordset, String string, double d, GeoRegion geoRegion) {
        String string2;
        SurfaceAnalyst._$1();
        if (surfaceExtractParameter == null) {
            String string3 = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (recordset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset) == 0L) {
            String string4 = InternalResource.loadString("extractedPointRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string4);
        }
        if (!recordset.getDataset().getType().equals((Object)DatasetType.POINT)) {
            String string5 = InternalResource.loadString("extractedPointRecordset", "SurfaceAnalystNotPointType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (recordset.getFieldInfos().indexOf(string) == -1) {
            String string6 = InternalResource.loadString("zValueFieldName", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        if (d <= 0.0) {
            String string7 = InternalResource.loadString("resolution", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string7);
        }
        Datasource datasource = recordset.getDataset().getDatasource();
        DatasetVector datasetVector = SurfaceAnalyst.extractIsoline(surfaceExtractParameter, recordset, string, datasource, string2 = recordset.getDataset().getDatasource().getDatasets().getAvailableDatasetName("tempDataset"), d, geoRegion);
        if (datasetVector == null) {
            return new GeoLine[0];
        }
        ArrayList<GeoLine> arrayList = new ArrayList<GeoLine>();
        Recordset recordset2 = datasetVector.getRecordset(false, CursorType.STATIC);
        while (!recordset2.isEOF()) {
            GeoLine geoLine = (GeoLine)recordset2.getGeometry();
            arrayList.add(geoLine);
            recordset2.moveNext();
        }
        int n = arrayList.size();
        GeoLine[] geoLineArray = new GeoLine[n];
        for (int i = 0; i < n; ++i) {
            geoLineArray[i] = (GeoLine)arrayList.get(i);
        }
        recordset2.dispose();
        datasource.getDatasets().delete(datasetVector.getName());
        return geoLineArray;
    }

    public static GeoLine[] extractIsoline(SurfaceExtractParameter surfaceExtractParameter, Recordset recordset, String string, TerrainInterpolateType terrainInterpolateType, double d, GeoRegion geoRegion) {
        String string2;
        SurfaceAnalyst._$1();
        if (surfaceExtractParameter == null) {
            String string3 = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (recordset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset) == 0L) {
            String string4 = InternalResource.loadString("extractedPointRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string4);
        }
        if (!recordset.getDataset().getType().equals((Object)DatasetType.POINT)) {
            String string5 = InternalResource.loadString("extractedPointRecordset", "SurfaceAnalystNotPointType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (recordset.getFieldInfos().indexOf(string) == -1) {
            String string6 = InternalResource.loadString("zValueFieldName", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        if (d <= 0.0) {
            String string7 = InternalResource.loadString("resolution", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string7);
        }
        Datasource datasource = recordset.getDataset().getDatasource();
        DatasetVector datasetVector = SurfaceAnalyst.extractIsoline(surfaceExtractParameter, recordset, string, terrainInterpolateType, datasource, string2 = recordset.getDataset().getDatasource().getDatasets().getAvailableDatasetName("tempDataset"), d, geoRegion);
        if (datasetVector == null) {
            return new GeoLine[0];
        }
        ArrayList<GeoLine> arrayList = new ArrayList<GeoLine>();
        Recordset recordset2 = datasetVector.getRecordset(false, CursorType.STATIC);
        while (!recordset2.isEOF()) {
            GeoLine geoLine = (GeoLine)recordset2.getGeometry();
            arrayList.add(geoLine);
            recordset2.moveNext();
        }
        int n = arrayList.size();
        GeoLine[] geoLineArray = new GeoLine[n];
        for (int i = 0; i < n; ++i) {
            geoLineArray[i] = (GeoLine)arrayList.get(i);
        }
        recordset2.dispose();
        datasource.getDatasets().delete(datasetVector.getName());
        return geoLineArray;
    }

    public static GeoLine[] extractIsoline(SurfaceExtractParameter surfaceExtractParameter, Point3Ds point3Ds, double d, GeoRegion geoRegion) {
        SurfaceAnalyst._$1();
        if (surfaceExtractParameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (point3Ds == null || point3Ds.getCount() == 0) {
            String string = InternalResource.loadString("extractedPoints", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("resolution", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        if (geoRegion != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion) != 0L) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion);
        }
        int n = point3Ds.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = point3Ds.getItem(i).getX();
            dArray2[i] = point3Ds.getItem(i).getY();
            dArray3[i] = point3Ds.getItem(i).getZ();
        }
        double d2 = dArray[0];
        double d3 = dArray[0];
        double d4 = dArray2[0];
        double d5 = dArray2[0];
        for (int i = 1; i < n; ++i) {
            d2 = d2 <= dArray[i] ? d2 : dArray[i];
            d3 = d3 >= dArray[i] ? d3 : dArray[i];
            d4 = d4 <= dArray2[i] ? d4 : dArray2[i];
            d5 = d5 >= dArray2[i] ? d5 : dArray2[i];
        }
        Rectangle2D rectangle2D = new Rectangle2D(d2, d4, d3, d5);
        SurfaceAnalyst._$1(d, rectangle2D);
        int n2 = InternalEnum.getUGCValue(TerrainInterpolateType.IDW);
        long[] lArray = surfaceExtractParameter.getExpectedZValues() == null ? SurfaceAnalystNative.jni_ExtractIsolineRGeoLine1(dArray, dArray2, dArray3, n2, l, d, surfaceExtractParameter.getInterval(), surfaceExtractParameter.getDatumValue(), surfaceExtractParameter.getSmoothness(), InternalEnum.getUGCValue(surfaceExtractParameter.getSmoothMethod()), surfaceExtractParameter.getResampleTolerance()) : SurfaceAnalystNative.jni_ExtractIsolineRGeoLine2(dArray, dArray2, dArray3, n2, l, d, surfaceExtractParameter.getExpectedZValues(), surfaceExtractParameter.getSmoothness(), InternalEnum.getUGCValue(surfaceExtractParameter.getSmoothMethod()), surfaceExtractParameter.getResampleTolerance());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoRegion);
        if (lArray == null) {
            return new GeoLine[0];
        }
        int n3 = lArray.length;
        GeoLine[] geoLineArray = new GeoLine[n3];
        for (int i = 0; i < n3; ++i) {
            geoLineArray[i] = (GeoLine)InternalGeometry.createInstance(lArray[i]);
        }
        return geoLineArray;
    }

    public static GeoLine[] extractIsoline(SurfaceExtractParameter surfaceExtractParameter, Point3Ds point3Ds, TerrainInterpolateType terrainInterpolateType, double d, GeoRegion geoRegion) {
        SurfaceAnalyst._$1();
        if (surfaceExtractParameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (point3Ds == null || point3Ds.getCount() == 0) {
            String string = InternalResource.loadString("extractedPoints", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("resolution", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        if (geoRegion != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion) != 0L) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion);
        }
        int n = point3Ds.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = point3Ds.getItem(i).getX();
            dArray2[i] = point3Ds.getItem(i).getY();
            dArray3[i] = point3Ds.getItem(i).getZ();
        }
        double d2 = dArray[0];
        double d3 = dArray[0];
        double d4 = dArray2[0];
        double d5 = dArray2[0];
        for (int i = 1; i < n; ++i) {
            d2 = d2 <= dArray[i] ? d2 : dArray[i];
            d3 = d3 >= dArray[i] ? d3 : dArray[i];
            d4 = d4 <= dArray2[i] ? d4 : dArray2[i];
            d5 = d5 >= dArray2[i] ? d5 : dArray2[i];
        }
        Rectangle2D rectangle2D = new Rectangle2D(d2, d4, d3, d5);
        SurfaceAnalyst._$1(d, rectangle2D);
        int n2 = InternalEnum.getUGCValue(terrainInterpolateType);
        long[] lArray = surfaceExtractParameter.getExpectedZValues() == null ? SurfaceAnalystNative.jni_ExtractIsolineRGeoLine1(dArray, dArray2, dArray3, n2, l, d, surfaceExtractParameter.getInterval(), surfaceExtractParameter.getDatumValue(), surfaceExtractParameter.getSmoothness(), InternalEnum.getUGCValue(surfaceExtractParameter.getSmoothMethod()), surfaceExtractParameter.getResampleTolerance()) : SurfaceAnalystNative.jni_ExtractIsolineRGeoLine2(dArray, dArray2, dArray3, n2, l, d, surfaceExtractParameter.getExpectedZValues(), surfaceExtractParameter.getSmoothness(), InternalEnum.getUGCValue(surfaceExtractParameter.getSmoothMethod()), surfaceExtractParameter.getResampleTolerance());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoRegion);
        if (lArray == null) {
            return new GeoLine[0];
        }
        int n3 = lArray.length;
        GeoLine[] geoLineArray = new GeoLine[n3];
        for (int i = 0; i < n3; ++i) {
            geoLineArray[i] = (GeoLine)InternalGeometry.createInstance(lArray[i]);
        }
        return geoLineArray;
    }

    public static GeoRegion[] extractIsoregion(SurfaceExtractParameter surfaceExtractParameter, DatasetVector datasetVector, String string, double d, GeoRegion geoRegion) {
        if (datasetVector == null) {
            String string2 = InternalResource.loadString("extractedPoint", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        Recordset recordset = datasetVector.getRecordset(false, CursorType.STATIC);
        GeoRegion[] geoRegionArray = SurfaceAnalyst.extractIsoregion(surfaceExtractParameter, recordset, string, d, geoRegion);
        recordset.dispose();
        return geoRegionArray;
    }

    public static GeoRegion[] extractIsoregion(SurfaceExtractParameter surfaceExtractParameter, DatasetVector datasetVector, String string, TerrainInterpolateType terrainInterpolateType, double d, GeoRegion geoRegion) {
        if (datasetVector == null) {
            String string2 = InternalResource.loadString("extractedPoint", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        Recordset recordset = datasetVector.getRecordset(false, CursorType.STATIC);
        GeoRegion[] geoRegionArray = SurfaceAnalyst.extractIsoregion(surfaceExtractParameter, recordset, string, terrainInterpolateType, d, geoRegion);
        recordset.dispose();
        return geoRegionArray;
    }

    public static GeoRegion[] extractIsoregion(SurfaceExtractParameter surfaceExtractParameter, Point3Ds point3Ds, double d, GeoRegion geoRegion) {
        SurfaceAnalyst._$1();
        if (surfaceExtractParameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (point3Ds == null || point3Ds.getCount() == 0) {
            String string = InternalResource.loadString("extractedPoints", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("resolution", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        if (geoRegion != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion) != 0L) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion);
        }
        int n = point3Ds.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = point3Ds.getItem(i).getX();
            dArray2[i] = point3Ds.getItem(i).getY();
            dArray3[i] = point3Ds.getItem(i).getZ();
        }
        double d2 = dArray[0];
        double d3 = dArray[0];
        double d4 = dArray2[0];
        double d5 = dArray2[0];
        for (int i = 1; i < n; ++i) {
            d2 = d2 <= dArray[i] ? d2 : dArray[i];
            d3 = d3 >= dArray[i] ? d3 : dArray[i];
            d4 = d4 <= dArray2[i] ? d4 : dArray2[i];
            d5 = d5 >= dArray2[i] ? d5 : dArray2[i];
        }
        Rectangle2D rectangle2D = new Rectangle2D(d2, d4, d3, d5);
        SurfaceAnalyst._$1(d, rectangle2D);
        int n2 = InternalEnum.getUGCValue(TerrainInterpolateType.IDW);
        long[] lArray = surfaceExtractParameter.getExpectedZValues() == null ? SurfaceAnalystNative.jni_ExtractIsolineRGeoRegion1(dArray, dArray2, dArray3, n2, l, d, surfaceExtractParameter.getInterval(), surfaceExtractParameter.getDatumValue(), surfaceExtractParameter.getSmoothness(), InternalEnum.getUGCValue(surfaceExtractParameter.getSmoothMethod()), surfaceExtractParameter.getResampleTolerance()) : SurfaceAnalystNative.jni_ExtractIsolineRGeoRegion1WithZ(dArray, dArray2, dArray3, n2, l, d, surfaceExtractParameter.getExpectedZValues(), surfaceExtractParameter.getSmoothness(), InternalEnum.getUGCValue(surfaceExtractParameter.getSmoothMethod()), surfaceExtractParameter.getResampleTolerance());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoRegion);
        if (lArray == null) {
            return new GeoRegion[0];
        }
        int n3 = lArray.length;
        GeoRegion[] geoRegionArray = new GeoRegion[n3];
        for (int i = 0; i < n3; ++i) {
            geoRegionArray[i] = (GeoRegion)InternalGeometry.createInstance(lArray[i]);
        }
        return geoRegionArray;
    }

    public static GeoRegion[] extractIsoregion(SurfaceExtractParameter surfaceExtractParameter, Point3Ds point3Ds, TerrainInterpolateType terrainInterpolateType, double d, GeoRegion geoRegion) {
        SurfaceAnalyst._$1();
        if (surfaceExtractParameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (point3Ds == null || point3Ds.getCount() == 0) {
            String string = InternalResource.loadString("extractedPoints", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("resolution", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        if (geoRegion != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion) != 0L) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion);
        }
        int n = point3Ds.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = point3Ds.getItem(i).getX();
            dArray2[i] = point3Ds.getItem(i).getY();
            dArray3[i] = point3Ds.getItem(i).getZ();
        }
        double d2 = dArray[0];
        double d3 = dArray[0];
        double d4 = dArray2[0];
        double d5 = dArray2[0];
        for (int i = 1; i < n; ++i) {
            d2 = d2 <= dArray[i] ? d2 : dArray[i];
            d3 = d3 >= dArray[i] ? d3 : dArray[i];
            d4 = d4 <= dArray2[i] ? d4 : dArray2[i];
            d5 = d5 >= dArray2[i] ? d5 : dArray2[i];
        }
        Rectangle2D rectangle2D = new Rectangle2D(d2, d4, d3, d5);
        SurfaceAnalyst._$1(d, rectangle2D);
        int n2 = InternalEnum.getUGCValue(terrainInterpolateType);
        long[] lArray = surfaceExtractParameter.getExpectedZValues() == null ? SurfaceAnalystNative.jni_ExtractIsolineRGeoRegion1(dArray, dArray2, dArray3, n2, l, d, surfaceExtractParameter.getInterval(), surfaceExtractParameter.getDatumValue(), surfaceExtractParameter.getSmoothness(), InternalEnum.getUGCValue(surfaceExtractParameter.getSmoothMethod()), surfaceExtractParameter.getResampleTolerance()) : SurfaceAnalystNative.jni_ExtractIsolineRGeoRegion1WithZ(dArray, dArray2, dArray3, n2, l, d, surfaceExtractParameter.getExpectedZValues(), surfaceExtractParameter.getSmoothness(), InternalEnum.getUGCValue(surfaceExtractParameter.getSmoothMethod()), surfaceExtractParameter.getResampleTolerance());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoRegion);
        if (lArray == null) {
            return new GeoRegion[0];
        }
        int n3 = lArray.length;
        GeoRegion[] geoRegionArray = new GeoRegion[n3];
        for (int i = 0; i < n3; ++i) {
            geoRegionArray[i] = (GeoRegion)InternalGeometry.createInstance(lArray[i]);
        }
        return geoRegionArray;
    }

    public static GeoRegion[] extractIsoregion(SurfaceExtractParameter surfaceExtractParameter, Recordset recordset, String string, double d, GeoRegion geoRegion) {
        String string2;
        SurfaceAnalyst._$1();
        if (surfaceExtractParameter == null) {
            String string3 = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (recordset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset) == 0L) {
            String string4 = InternalResource.loadString("extractedPointRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string4);
        }
        if (!recordset.getDataset().getType().equals((Object)DatasetType.POINT)) {
            String string5 = InternalResource.loadString("extractedPointRecordset", "SurfaceAnalystNotPointType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (recordset.getFieldInfos().indexOf(string) == -1) {
            String string6 = InternalResource.loadString("zValueFieldName", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        if (d <= 0.0) {
            String string7 = InternalResource.loadString("resolution", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string7);
        }
        Datasource datasource = recordset.getDataset().getDatasource();
        DatasetVector datasetVector = SurfaceAnalyst.extractIsoregion(surfaceExtractParameter, recordset, string, datasource, string2 = recordset.getDataset().getDatasource().getDatasets().getAvailableDatasetName("tempDataset"), d, geoRegion);
        if (datasetVector == null) {
            return new GeoRegion[0];
        }
        ArrayList<GeoRegion> arrayList = new ArrayList<GeoRegion>();
        Recordset recordset2 = datasetVector.getRecordset(false, CursorType.STATIC);
        while (!recordset2.isEOF()) {
            GeoRegion geoRegion2 = (GeoRegion)recordset2.getGeometry();
            arrayList.add(geoRegion2);
            recordset2.moveNext();
        }
        int n = arrayList.size();
        GeoRegion[] geoRegionArray = new GeoRegion[n];
        for (int i = 0; i < n; ++i) {
            geoRegionArray[i] = (GeoRegion)arrayList.get(i);
        }
        recordset2.dispose();
        datasource.getDatasets().delete(datasetVector.getName());
        return geoRegionArray;
    }

    public static GeoRegion[] extractIsoregion(SurfaceExtractParameter surfaceExtractParameter, Recordset recordset, String string, TerrainInterpolateType terrainInterpolateType, double d, GeoRegion geoRegion) {
        String string2;
        SurfaceAnalyst._$1();
        if (surfaceExtractParameter == null) {
            String string3 = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (recordset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset) == 0L) {
            String string4 = InternalResource.loadString("extractedPointRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string4);
        }
        if (!recordset.getDataset().getType().equals((Object)DatasetType.POINT)) {
            String string5 = InternalResource.loadString("extractedPointRecordset", "SurfaceAnalystNotPointType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (recordset.getFieldInfos().indexOf(string) == -1) {
            String string6 = InternalResource.loadString("zValueFieldName", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        if (d <= 0.0) {
            String string7 = InternalResource.loadString("resolution", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string7);
        }
        Datasource datasource = recordset.getDataset().getDatasource();
        DatasetVector datasetVector = SurfaceAnalyst.extractIsoregion(surfaceExtractParameter, recordset, string, terrainInterpolateType, datasource, string2 = recordset.getDataset().getDatasource().getDatasets().getAvailableDatasetName("tempDataset"), d, geoRegion);
        if (datasetVector == null) {
            return new GeoRegion[0];
        }
        ArrayList<GeoRegion> arrayList = new ArrayList<GeoRegion>();
        Recordset recordset2 = datasetVector.getRecordset(false, CursorType.STATIC);
        while (!recordset2.isEOF()) {
            GeoRegion geoRegion2 = (GeoRegion)recordset2.getGeometry();
            arrayList.add(geoRegion2);
            recordset2.moveNext();
        }
        int n = arrayList.size();
        GeoRegion[] geoRegionArray = new GeoRegion[n];
        for (int i = 0; i < n; ++i) {
            geoRegionArray[i] = (GeoRegion)arrayList.get(i);
        }
        recordset2.dispose();
        datasource.getDatasets().delete(datasetVector.getName());
        return geoRegionArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _$1() {
        int n = -1;
        Object object = _$1;
        synchronized (object) {
            n = _$1.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener steppedListener) {
        if (_$2 == null) {
            _$2 = new Vector();
        }
        if (!_$2.contains(steppedListener)) {
            _$2.add(steppedListener);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener steppedListener) {
        if (_$2 != null && _$2.contains(steppedListener)) {
            _$2.remove(steppedListener);
        }
    }

    protected static void fireStepped(SteppedEvent steppedEvent) {
        if (_$2 != null) {
            Vector vector = _$2;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(steppedEvent);
            }
        }
    }

    static void steppedCallBack(int n, long l, String string, String string2, long l2) {
        String string3 = "SurfaceAnalyst";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(l2);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, n, l, string, string2, string3);
        SurfaceAnalyst.fireStepped(steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(l2, steppedEvent.getCancel());
    }

    private static void _$1(double d, Rectangle2D rectangle2D) {
        double d2 = rectangle2D.getWidth();
        double d3 = rectangle2D.getHeight();
        int n = (int)(d2 / d);
        int n2 = (int)(d3 / d);
        if (n > 10000 || n2 > 10000) {
            String string = InternalResource.loadString("Resolution", "InterPolator_Resolution_TooSmall", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        _$1 = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

