/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.DissolveParameter;
import com.supermap.analyst.spatialanalyst.EliminateMode;
import com.supermap.analyst.spatialanalyst.GeneralizationNative;
import com.supermap.analyst.spatialanalyst.InternalDatasetVector;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalGeometry;
import com.supermap.analyst.spatialanalyst.InternalHandle;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.DatasetVectorInfo;
import com.supermap.data.Datasource;
import com.supermap.data.FieldInfos;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoRegion;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.License;
import com.supermap.data.Point2D;
import com.supermap.data.PrjCoordSysType;
import com.supermap.data.ProductType;
import com.supermap.data.Recordset;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.Unit;
import java.util.ArrayList;
import java.util.Vector;

public class Generalization {
    private static License _$2;
    private static transient Vector _$1;

    private Generalization() {
    }

    public static DatasetVector dissolve(DatasetVector datasetVector, Datasource datasource, String string, DissolveParameter dissolveParameter) {
        Generalization._$1();
        if (datasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector) == 0L) {
            String string2 = InternalResource.loadString("sourceDatasetVector", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            String string3 = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string4 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            String string5 = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string5);
        }
        if (dissolveParameter == null) {
            String string6 = InternalResource.loadString("dissolveParameter", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)dissolveParameter);
        long l4 = GeneralizationNative.jni_Dissolve(l, l2, string, l3);
        DatasetVector datasetVector2 = null;
        if (l4 != 0L) {
            datasetVector2 = InternalDatasetVector.createInstance(l4, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector2);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)dissolveParameter));
        return datasetVector2;
    }

    public static boolean eliminate(DatasetVector datasetVector, double d, double d2, EliminateMode eliminateMode, boolean bl) {
        if (datasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector) == 0L) {
            String string = InternalResource.loadString("sourceDatasetVector", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("sourceDatasetVector", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("regionTolerance", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (d2 < 0.0) {
            String string = InternalResource.loadString("vertexTolerance", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (eliminateMode == null) {
            String string = InternalResource.loadString("eliminateMode", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        boolean bl2 = false;
        bl2 = GeneralizationNative.jni_Eliminate(l, d, d2, eliminateMode.value(), bl);
        return bl2;
    }

    public static DatasetVector dualLineToCenterLine(Recordset recordset, double d, double d2, Datasource datasource, String string) {
        Generalization._$1();
        if (recordset == null) {
            String string2 = InternalResource.loadString("sourceRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset);
        if (l == 0L) {
            String string3 = InternalResource.loadString("sourceRecordset", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        if (datasource == null) {
            String string4 = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        if (l2 == 0L) {
            String string5 = InternalResource.loadString("outputDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string6 = InternalResource.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        if (d <= 0.0 || d2 < 0.0) {
            String string7 = InternalResource.loadString("width", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string7);
        }
        long l3 = GeneralizationNative.jni_dualLineToCenterLine(l, d, d2, l2, string);
        DatasetVector datasetVector = null;
        if (l3 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l3, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)recordset);
        return datasetVector;
    }

    public static DatasetVector regionToCenterLine(Recordset recordset, Datasource datasource, String string) {
        Generalization._$1();
        if (recordset == null) {
            String string2 = InternalResource.loadString("regionRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset);
        if (l == 0L) {
            String string3 = InternalResource.loadString("regionRecordset", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        if (datasource == null) {
            String string4 = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        if (l2 == 0L) {
            String string5 = InternalResource.loadString("outputDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string6 = InternalResource.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        if (recordset.getDataset().getType() != DatasetType.REGION) {
            String string7 = InternalResource.loadString("regionRecordset", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string7);
        }
        long l3 = GeneralizationNative.jni_regionToCenterLine(l, l2, string);
        DatasetVector datasetVector = null;
        if (l3 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l3, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)recordset);
        return datasetVector;
    }

    public static GeoLine regionToCenterLine(GeoRegion geoRegion, Point2D point2D, Point2D point2D2) {
        Generalization._$1();
        if (geoRegion == null) {
            String string = InternalResource.loadString("region", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion);
        if (l == 0L) {
            String string = InternalResource.loadString("region", "Handle_ObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeneralizationNative.jni_regionToCenterLine(l, point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY());
        GeoLine geoLine = null;
        if (l2 != 0L) {
            geoLine = (GeoLine)InternalGeometry.createInstance(l2);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoRegion);
        return geoLine;
    }

    public static GeoLine regionToCenterLine(GeoRegion geoRegion) {
        Generalization._$1();
        if (geoRegion == null) {
            String string = InternalResource.loadString("region", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion);
        if (l == 0L) {
            String string = InternalResource.loadString("region", "Handle_ObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeneralizationNative.jni_regionToCenterLine(l);
        GeoLine geoLine = null;
        if (l2 != 0L) {
            geoLine = (GeoLine)InternalGeometry.createInstance(l2);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoRegion);
        return geoLine;
    }

    public static GeoRegion[] autoCompletePolygon(DatasetVector datasetVector, Rectangle2D rectangle2D, GeoLine geoLine) {
        long[] lArray;
        Generalization._$1();
        if (datasetVector == null) {
            String string = InternalResource.loadString("regionDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        if (l == 0L) {
            String string = InternalResource.loadString("regionDataset", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("sourceDatasetVector", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoLine == null) {
            String string = InternalResource.loadString("geoLine", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoLine);
        if (l2 == 0L) {
            String string = InternalResource.loadString("geoLineHandle", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        Rectangle2D rectangle2D2 = new Rectangle2D(0.0, 0.0, 0.0, 0.0);
        if (rectangle2D != null) {
            rectangle2D2 = rectangle2D;
        }
        if ((lArray = GeneralizationNative.jni_autoCompletePolygon(l, rectangle2D2.getLeft(), rectangle2D2.getRight(), rectangle2D2.getTop(), rectangle2D2.getBottom(), l2)) == null || lArray.length == 0) {
            return null;
        }
        GeoRegion[] geoRegionArray = new GeoRegion[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            geoRegionArray[i] = (GeoRegion)InternalGeometry.createInstance(lArray[i]);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoLine);
        return geoRegionArray;
    }

    public static boolean aggregatePoints(DatasetVector datasetVector, double d, Unit unit, int n, Datasource datasource, String string, String string2) {
        String string3;
        FieldInfos fieldInfos;
        if (datasetVector == null) {
            String string4 = InternalResource.loadString("pointDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        if (l == 0L) {
            String string5 = InternalResource.loadString("pointDataset", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (datasetVector.getType() != DatasetType.POINT) {
            String string6 = InternalResource.loadString("pointDataset", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        if (n < 2) {
            String string7 = InternalResource.loadString("minPilePointCount", "Must_Larger_Than_One", "spatialanalyst_resources");
            throw new IllegalArgumentException(string7);
        }
        if (d <= 0.0) {
            String string8 = InternalResource.loadString("distance", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string8);
        }
        if (string2 == null && string == null) {
            String string9 = InternalResource.loadString("resultClassFieldName && resultRegionDatasetName", "ResultClassFieldAndResultRegionDatasetNotNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string9);
        }
        long l2 = 0L;
        if (string != null) {
            if (datasource == null) {
                String string10 = InternalResource.loadString("outDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string10);
            }
            if (!datasource.getDatasets().isAvailableDatasetName(string)) {
                String string11 = InternalResource.loadString("resultRegionDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string11);
            }
            fieldInfos = new DatasetVectorInfo();
            fieldInfos.setName(string);
            fieldInfos.setType(DatasetType.REGION);
            string3 = datasource.getDatasets().create((DatasetVectorInfo)fieldInfos);
            string3.open();
            string3.setPrjCoordSys(datasetVector.getPrjCoordSys());
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)string3);
        }
        if (string2 != null) {
            fieldInfos = datasetVector.getFieldInfos();
            int n2 = fieldInfos.indexOf(string2);
            if (n2 == -1) {
                String string12 = InternalResource.loadString("GlobalSpecifiedNameNotExists", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                throw new IllegalArgumentException(string12);
            }
            if (fieldInfos.get(n2).isSystemField()) {
                String string13 = InternalResource.loadString("FieldNotSystemField", "FieldNotSystemField", "spatialanalyst_resources");
                throw new IllegalArgumentException(string13);
            }
        }
        datasetVector.open();
        fieldInfos = datasetVector.getPrjCoordSys();
        if (fieldInfos.getType() != PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE && (unit == Unit.SECOND || unit == Unit.MINUTE || unit == Unit.DEGREE || unit == Unit.RADIAN)) {
            string3 = InternalResource.loadString("unit", "CannotBeAngleUnit", "spatialanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        return GeneralizationNative.jni_AggregatePoints(l, d, unit.value(), n, l2, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _$1() {
        int n = -1;
        Object object = _$2;
        synchronized (object) {
            n = _$2.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener steppedListener) {
        if (_$1 == null) {
            _$1 = new Vector();
        }
        if (!_$1.contains(steppedListener)) {
            _$1.add(steppedListener);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener steppedListener) {
        if (_$1 != null && _$1.contains(steppedListener)) {
            _$1.remove(steppedListener);
        }
    }

    protected static void fireStepped(SteppedEvent steppedEvent) {
        if (_$1 != null) {
            Vector vector = _$1;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(steppedEvent);
            }
        }
    }

    static void steppedCallBack(int n, long l, String string, String string2, long l2) {
        String string3 = "Generalization";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(l2);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, n, l, string, string2, string3);
        Generalization.fireStepped(steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(l2, steppedEvent.getCancel());
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        _$2 = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

