/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.addressmatching;

import com.supermap.analyst.addressmatching.AddressMatchNative;
import com.supermap.analyst.addressmatching.AddressMatchParameter;
import com.supermap.analyst.addressmatching.AddressMatchResults;
import com.supermap.analyst.addressmatching.AddressMatchSetting;
import com.supermap.analyst.addressmatching.InternalHandle;
import com.supermap.analyst.addressmatching.InternalHandleDisposable;
import com.supermap.analyst.addressmatching.InternalResource;
import com.supermap.analyst.addressmatching.InternalToolkitAddressMatching;
import com.supermap.data.DatasetVector;
import com.supermap.data.GeoRegion;
import com.supermap.data.License;
import com.supermap.data.ProductType;
import java.util.ArrayList;
import java.util.HashMap;

public class AddressMatch
extends InternalHandleDisposable {
    private AddressMatchSetting _$3;
    private boolean _$2;
    private License _$1;

    public AddressMatch() {
        this._$4();
        long l = AddressMatchNative.jni_New();
        this.setHandle(l, true);
        this._$3 = new AddressMatchSetting();
        this._$2 = false;
    }

    private void _$4() {
        ArrayList<ProductType> arrayList = InternalToolkitAddressMatching.managerProducts(InternalToolkitAddressMatching.getAddressMatchingProducts());
        this._$1 = InternalToolkitAddressMatching.verifyLicense(arrayList);
    }

    private void _$3() {
        if (this._$1 != null) {
            this._$1.disconnect();
            this._$1.dispose();
            this._$1 = null;
        }
    }

    private void _$2() {
        int n = this._$1.verify();
        if (n != 0) {
            String string = License.getErrorMessage((int)n);
            throw new IllegalStateException(string);
        }
    }

    public void dispose() {
        this._$3();
        if (this.getHandle() != 0L) {
            AddressMatchNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    protected void clearHandle() {
        if (this._$3 != null) {
            this._$3 = null;
        }
    }

    public AddressMatchSetting getSetting() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSetting()", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        return this._$3;
    }

    public void setSetting(AddressMatchSetting addressMatchSetting) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSetting(AddressMatchSetting value)", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        if (addressMatchSetting == null) {
            String string = InternalResource.loadString("setAnalystSetting(NetworkAnalystSetting value)", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        if (!this._$3.equals(addressMatchSetting)) {
            this._$3.copyFrom(addressMatchSetting);
        }
    }

    public boolean load() {
        this._$2();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("load()", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        DatasetVector[] datasetVectorArray = this._$3.getDatasets();
        int n = datasetVectorArray.length;
        if (n <= 0) {
            String string = InternalResource.loadString("getSetting().getDatasets().length", "Global_ArrayLengthShouldGreaterThanZero", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVectorArray[i]);
        }
        String[] stringArray = this._$3.getFields();
        if (stringArray.length <= 0) {
            String string = InternalResource.loadString("getSetting().getFields().length", "Global_ArrayLengthShouldGreaterThanZero", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        String string = this._$3.getDictionaryFile();
        if (string == null || string.trim().length() == 0) {
            String string2 = InternalResource.loadString("getSetting().getDictionaryFile()", "Global_StringIsNullOrEmpty", "addressmatching_resources");
            throw new IllegalArgumentException(string2);
        }
        bl = AddressMatchNative.jni_Load(this.getHandle(), lArray, stringArray, string);
        this._$3.setChanged(false);
        if (bl) {
            this._$2 = true;
        }
        return bl;
    }

    public boolean load(DatasetVector[] datasetVectorArray, String[] stringArray, double[] dArray, String string) {
        this._$2();
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("load()", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string2);
        }
        boolean bl = false;
        int n = datasetVectorArray.length;
        if (n <= 0) {
            String string3 = InternalResource.loadString("datasets.length", "Global_ArrayLengthShouldGreaterThanZero", "addressmatching_resources");
            throw new IllegalStateException(string3);
        }
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVectorArray[i]);
        }
        if (stringArray.length <= 0) {
            String string4 = InternalResource.loadString("fields.length", "Global_ArrayLengthShouldGreaterThanZero", "addressmatching_resources");
            throw new IllegalStateException(string4);
        }
        if (dArray.length != stringArray.length) {
            String string5 = InternalResource.loadString("weights.length != fields.length", "Global_ArrayLengthShouldGreaterThanZero", "addressmatching_resources");
            throw new IllegalStateException(string5);
        }
        if (string == null || string.trim().length() == 0) {
            String string6 = InternalResource.loadString("getSetting().getDictionaryFile()", "Global_StringIsNullOrEmpty", "addressmatching_resources");
            throw new IllegalArgumentException(string6);
        }
        bl = AddressMatchNative.jni_Load1(this.getHandle(), lArray, stringArray, dArray, string);
        this._$3.setChanged(false);
        if (bl) {
            this._$2 = true;
        }
        return bl;
    }

    public AddressMatchResults match(AddressMatchParameter addressMatchParameter) {
        Object object;
        int n;
        this._$2();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("match(AddressMatchParameter parameter)", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        if (this._$1()) {
            String string = InternalResource.loadString("", "AddressMatch_LoadNeeded", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        if (addressMatchParameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        String string = addressMatchParameter.getSearchAddress();
        if (string == null || string.trim().length() == 0) {
            String string2 = InternalResource.loadString("parameter.getSearchAddress()", "Global_StringIsNullOrEmpty", "addressmatching_resources");
            throw new IllegalArgumentException(string2);
        }
        DatasetVector[] datasetVectorArray = addressMatchParameter.getSearchDatasets() != null && addressMatchParameter.getSearchDatasets().length > 0 ? addressMatchParameter.getSearchDatasets() : this.getSetting().getDatasets();
        int n2 = datasetVectorArray.length;
        long[] lArray = new long[n2];
        HashMap<GeoRegion, DatasetVector> hashMap = new HashMap<GeoRegion, DatasetVector>();
        for (n = 0; n < n2; ++n) {
            lArray[n] = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVectorArray[n]);
            int[] nArray = AddressMatchNative.jni_GetDatasetLayerIDs(this.getHandle(), lArray[n]);
            if (nArray == null) continue;
            for (int i = 0; i < nArray.length; ++i) {
                object = new Integer(nArray[i]);
                if (hashMap.containsKey(object)) continue;
                hashMap.put((GeoRegion)object, datasetVectorArray[n]);
            }
        }
        n = addressMatchParameter.getResultCount();
        long l = 0L;
        object = addressMatchParameter.getSearchRegion();
        if (object != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)object);
        }
        boolean bl = addressMatchParameter.isLocationReturn();
        boolean bl2 = addressMatchParameter.isAddressSegmented();
        long l2 = AddressMatchNative.jni_Match(this.getHandle(), string, lArray, n, l, bl, bl2);
        AddressMatchResults addressMatchResults = null;
        if (l2 != 0L) {
            addressMatchResults = new AddressMatchResults(l2, hashMap);
        }
        return addressMatchResults;
    }

    public String segmentAddress(String string) {
        this._$2();
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("getSetting()", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string2);
        }
        return AddressMatchNative.jni_SegmentAddress(this.getHandle(), string);
    }

    private boolean _$1() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isLoadNeeded()", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        return this._$3.isChanged() || !this._$2;
    }
}

