/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web;

import java.net.URL;
import java.util.Arrays;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.aspect.LogAspect;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.HttpBasedServiceCredentials;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.services.UnauthorizedServiceException;
import org.jasig.cas.ticket.TicketException;
import org.jasig.cas.ticket.TicketValidationException;
import org.jasig.cas.ticket.proxy.ProxyHandler;
import org.jasig.cas.validation.Assertion;
import org.jasig.cas.validation.Cas20ProtocolValidationSpecification;
import org.jasig.cas.validation.ValidationSpecification;
import org.jasig.cas.web.DelegateController;
import org.jasig.cas.web.support.ArgumentExtractor;
import org.slf4j.Logger;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.servlet.ModelAndView;

public class ServiceValidateController
extends DelegateController {
    private static final String DEFAULT_SERVICE_FAILURE_VIEW_NAME = "casServiceFailureView";
    private static final String DEFAULT_SERVICE_SUCCESS_VIEW_NAME = "casServiceSuccessView";
    private static final String MODEL_PROXY_GRANTING_TICKET_IOU = "pgtIou";
    private static final String MODEL_ASSERTION = "assertion";
    @NotNull
    private CentralAuthenticationService centralAuthenticationService;
    @NotNull
    private Class<?> validationSpecificationClass = Cas20ProtocolValidationSpecification.class;
    @NotNull
    private ProxyHandler proxyHandler;
    @NotNull
    private String successView = "casServiceSuccessView";
    @NotNull
    private String failureView = "casServiceFailureView";
    @NotNull
    private ArgumentExtractor argumentExtractor;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    protected Credentials getServiceCredentialsFromRequest(HttpServletRequest request) {
        String pgtUrl = request.getParameter("pgtUrl");
        if (StringUtils.hasText((String)pgtUrl)) {
            try {
                return new HttpBasedServiceCredentials(new URL(pgtUrl));
            }
            catch (Exception e) {
                this.logger.error((Object)"Error constructing pgtUrl", (Throwable)e);
            }
        }
        return null;
    }

    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) {
        binder.setRequiredFields(new String[]{"renew"});
    }

    protected final ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String serviceTicketId;
        WebApplicationService service = this.argumentExtractor.extractService(request);
        String string = serviceTicketId = service != null ? service.getArtifactId() : null;
        if (service == null || serviceTicketId == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)String.format("Could not process request; Service: %s, Service Ticket Id: %s", service, serviceTicketId));
            }
            return this.generateErrorView("INVALID_REQUEST", "INVALID_REQUEST", null);
        }
        try {
            Credentials serviceCredentials = this.getServiceCredentialsFromRequest(request);
            String proxyGrantingTicketId = null;
            if (serviceCredentials != null) {
                try {
                    proxyGrantingTicketId = this.centralAuthenticationService.delegateTicketGrantingTicket(serviceTicketId, serviceCredentials);
                }
                catch (TicketException e) {
                    this.logger.error((Object)("TicketException generating ticket for: " + serviceCredentials), (Throwable)e);
                }
            }
            Assertion assertion = this.centralAuthenticationService.validateServiceTicket(serviceTicketId, service);
            ValidationSpecification validationSpecification = this.getCommandClass();
            ServletRequestDataBinder binder = new ServletRequestDataBinder((Object)validationSpecification, "validationSpecification");
            this.initBinder(request, binder);
            binder.bind((ServletRequest)request);
            if (!validationSpecification.isSatisfiedBy(assertion)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("ServiceTicket [" + serviceTicketId + "] does not satisfy validation specification."));
                }
                return this.generateErrorView("INVALID_TICKET", "INVALID_TICKET_SPEC", null);
            }
            this.onSuccessfulValidation(serviceTicketId, assertion);
            ModelAndView success = new ModelAndView(this.successView);
            success.addObject(MODEL_ASSERTION, (Object)assertion);
            if (serviceCredentials != null && proxyGrantingTicketId != null) {
                String proxyIou = this.proxyHandler.handle(serviceCredentials, proxyGrantingTicketId);
                success.addObject(MODEL_PROXY_GRANTING_TICKET_IOU, (Object)proxyIou);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)String.format("Successfully validated service ticket: %s", serviceTicketId));
            }
            return success;
        }
        catch (TicketValidationException e) {
            return this.generateErrorView(e.getCode(), e.getCode(), new Object[]{serviceTicketId, e.getOriginalService().getId(), service.getId()});
        }
        catch (TicketException te) {
            return this.generateErrorView(te.getCode(), te.getCode(), new Object[]{serviceTicketId});
        }
        catch (UnauthorizedServiceException e) {
            return this.generateErrorView(e.getMessage(), e.getMessage(), null);
        }
    }

    protected void onSuccessfulValidation(String serviceTicketId, Assertion assertion) {
    }

    private ModelAndView generateErrorView(String code, String description, Object[] args) {
        ModelAndView modelAndView = new ModelAndView(this.failureView);
        String convertedDescription = this.getMessageSourceAccessor().getMessage(description, args, description);
        modelAndView.addObject("code", (Object)code);
        modelAndView.addObject("description", (Object)convertedDescription);
        return modelAndView;
    }

    private ValidationSpecification getCommandClass() {
        try {
            return (ValidationSpecification)this.validationSpecificationClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean canHandle(HttpServletRequest request, HttpServletResponse response) {
        HttpServletRequest httpServletRequest = request;
        HttpServletResponse httpServletResponse = response;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)httpServletRequest, (Object)httpServletResponse);
        return Conversions.booleanValue((Object)ServiceValidateController.canHandle_aroundBody1$advice(this, httpServletRequest, httpServletResponse, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint));
    }

    public final void setCentralAuthenticationService(CentralAuthenticationService centralAuthenticationService) {
        this.centralAuthenticationService = centralAuthenticationService;
    }

    public final void setArgumentExtractor(ArgumentExtractor argumentExtractor) {
        this.argumentExtractor = argumentExtractor;
    }

    public final void setValidationSpecificationClass(Class<?> validationSpecificationClass) {
        this.validationSpecificationClass = validationSpecificationClass;
    }

    public final void setFailureView(String failureView) {
        this.failureView = failureView;
    }

    public final void setSuccessView(String successView) {
        this.successView = successView;
    }

    public final void setProxyHandler(ProxyHandler proxyHandler) {
        this.proxyHandler = proxyHandler;
    }

    static {
        ServiceValidateController.ajc$preClinit();
    }

    private static final /* synthetic */ boolean canHandle_aroundBody0(ServiceValidateController ajc$this, HttpServletRequest request, HttpServletResponse response, JoinPoint joinPoint) {
        return true;
    }

    private static final /* synthetic */ Object canHandle_aroundBody1$advice(ServiceValidateController ajc$this, HttpServletRequest request, HttpServletResponse response, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            object = returnVal = Conversions.booleanObject((boolean)ServiceValidateController.canHandle_aroundBody0(ajc$this, request, response, (JoinPoint)proceedingJoinPoint2));
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return object;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ServiceValidateController.java", ServiceValidateController.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "canHandle", "org.jasig.cas.web.ServiceValidateController", "javax.servlet.http.HttpServletRequest:javax.servlet.http.HttpServletResponse", "request:response", "", "boolean"), 210);
    }
}

