/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sojo.interchange.csv;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import net.sf.sojo.common.WalkerInterceptor;
import net.sf.sojo.interchange.csv.CsvParserException;
import net.sf.sojo.util.Table;

public class CsvWalkerInterceptor
implements WalkerInterceptor {
    private Table table = new Table();
    private boolean wrapSimpleValueAsList = false;
    private boolean withColumnNames = true;
    private String nullValue = "";

    public String getNullValue() {
        return this.nullValue;
    }

    public void setNullValue(String pvNullValue) {
        this.nullValue = pvNullValue;
    }

    public void setWrapSimpleValueAsList(boolean pvWrapSimpleValueAsList) {
        this.wrapSimpleValueAsList = pvWrapSimpleValueAsList;
    }

    public boolean gettWrapSimpleValueAsList() {
        return this.wrapSimpleValueAsList;
    }

    public void setWithColumnNames(boolean pvWithColumnNames) {
        this.withColumnNames = pvWithColumnNames;
    }

    public boolean getWithColumnNames() {
        return this.withColumnNames;
    }

    @Override
    public void endWalk() {
    }

    @Override
    public void startWalk(Object pvStartObject) {
        this.table.clear();
        this.table.setWithColumnNames(this.getWithColumnNames());
    }

    private String getColumnName(Object pvKey, String pvPath) {
        String lvName = null;
        if (this.getWithColumnNames()) {
            lvName = pvKey == null ? (this.gettWrapSimpleValueAsList() ? "" : pvPath) : pvKey.toString();
        }
        return lvName;
    }

    private String convertValue2CsvValidValue(Object pvValue) {
        String lvValue = pvValue.toString();
        if (lvValue.indexOf(34) > -1) {
            lvValue = '\"' + lvValue.replaceAll("\"", "\"\"") + '\"';
        } else if (lvValue.trim().length() > "\r\n".length() && lvValue.indexOf("\r\n") > -1) {
            lvValue = '\"' + lvValue + '\"';
        } else if (lvValue.indexOf(44) > -1) {
            lvValue = '\"' + lvValue + '\"';
        }
        return lvValue;
    }

    @Override
    public boolean visitElement(Object pvKey, int pvIndex, Object pvValue, int pvType, String pvPath, int pvNumberOfRecursion) {
        if (pvType == 1) {
            if (this.table.getCurrentRowNumber() == 0) {
                this.table.newRow();
            }
            this.table.addValue2CurrentRow(this.getColumnName(pvKey, pvPath), this.convertValue2CsvValidValue(pvValue));
        } else if (pvType == 0) {
            this.table.addValue2CurrentRow(this.getColumnName(pvKey, pvPath), this.nullValue);
        }
        return false;
    }

    @Override
    public void visitIterateableElement(Object pvValue, int pvType, String pvPath, int pvTypeBeginOrEnd) {
        if (1 == pvTypeBeginOrEnd && pvPath.length() > 0 && this.getSize(pvValue, pvType) > 0) {
            int c = pvPath.split("\\.").length;
            if (c > 1) {
                throw new CsvParserException("The properties are to deep nested for CSV (property-path: " + pvPath + ")");
            }
            this.table.newRow();
        }
    }

    private int getSize(Object pvValue, int pvType) {
        int lvSize = 0;
        lvSize = 7 == pvType ? (pvValue instanceof Collection ? ((Collection)pvValue).size() : Arrays.asList((Object[])pvValue).size()) : ((Map)pvValue).size();
        return lvSize;
    }

    public String getCsvString() {
        if (this.getWithColumnNames()) {
            return this.table.getRowsWithColumnsAndColumnsNamesAsString();
        }
        return this.table.getRowsWithColumnsAsString();
    }

    public Table getTable() {
        return this.table;
    }
}

