/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.engine;

import java.io.Serializable;
import javax.validation.Path;

public class NodeImpl
implements Path.Node,
Serializable {
    private static final long serialVersionUID = 2075466571633860499L;
    public static final String INDEX_OPEN = "[";
    public static final String INDEX_CLOSE = "]";
    private final String name;
    private final NodeImpl parent;
    private final boolean isIterable;
    private final Integer index;
    private final Object key;
    private final int hashCode;
    private String asString;

    public NodeImpl(String name, NodeImpl parent, boolean indexable, Integer index, Object key) {
        this.name = name;
        this.parent = parent;
        this.index = index;
        this.key = key;
        this.isIterable = indexable;
        this.hashCode = this.buildHashCode();
    }

    NodeImpl(NodeImpl node, NodeImpl parent) {
        this(node.name, parent, node.isIterable, node.index, node.key);
    }

    public final String getName() {
        return this.name;
    }

    public final boolean isInIterable() {
        if (this.parent == null) {
            return false;
        }
        return this.parent.isIterable();
    }

    public final boolean isIterable() {
        return this.isIterable;
    }

    public final Integer getIndex() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.index;
    }

    public final Object getKey() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.key;
    }

    public final NodeImpl getParent() {
        return this.parent;
    }

    public String toString() {
        return this.asString();
    }

    public final String asString() {
        if (this.asString == null) {
            this.asString = this.buildToString();
        }
        return this.asString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeImpl node = (NodeImpl)o;
        if (this.isIterable != node.isIterable) {
            return false;
        }
        if (this.index != null ? !this.index.equals(node.index) : node.index != null) {
            return false;
        }
        if (this.key != null ? !this.key.equals(node.key) : node.key != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(node.name) : node.name != null);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int buildHashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.isIterable ? 1 : 0);
        result = 31 * result + (this.index != null ? this.index.hashCode() : 0);
        result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
        return result;
    }

    private String buildToString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getName());
        if (this.isIterable()) {
            builder.append(INDEX_OPEN);
            if (this.index != null) {
                builder.append(this.index);
            } else if (this.key != null) {
                builder.append(this.key);
            }
            builder.append(INDEX_CLOSE);
        }
        return builder.toString();
    }
}

